/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.KnownConfigurationsAdapter;
import org.hibernate.console.KnownConfigurationsListener;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.osgi.framework.BundleContext;

public class HibernateJptPlugin
extends Plugin {
    public static final String ID = "org.jboss.tools.hibernate.jpt.core";
    private static HibernateJptPlugin inst = null;
    private static String JAVA_PROPERTIES_CONTENT_TYPE_NAME = "org.eclipse.jdt.core.javaProperties";
    public static IContentType JAVA_PROPERTIES_CONTENT_TYPE = Platform.getContentTypeManager().getContentType(JAVA_PROPERTIES_CONTENT_TYPE_NAME);

    public static HibernateJptPlugin getDefault() {
        return inst;
    }

    private static void log(int severity, String message, Throwable e) {
        HibernateJptPlugin.getDefault().getLog().log((IStatus)new Status(severity, ID, message, e));
    }

    public static void logException(Throwable e) {
        HibernateJptPlugin.log(4, e.getMessage(), e);
    }

    public static void logException(String message, Throwable e) {
        HibernateJptPlugin.log(4, message, e);
    }

    public static void logError(String message) {
        HibernateJptPlugin.log(4, message, null);
    }

    public static void logWarning(String message) {
        HibernateJptPlugin.log(2, message, null);
    }

    public static void logInfo(String message) {
        HibernateJptPlugin.log(1, message, null);
    }

    public HibernateJptPlugin() {
        if (inst == null) {
            inst = this;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        KnownConfigurations.getInstance().addConsoleConfigurationListener((KnownConfigurationsListener)new KnownConfigurationsAdapter(){

            private void revalidateProjects(ConsoleConfiguration ccfg) {
                JpaProjectManager manager = (JpaProjectManager)ResourcesPlugin.getWorkspace().getAdapter(JpaProjectManager.class);
                for (JpaProject jpaProject : manager.getJpaProjects()) {
                    if (!(jpaProject instanceof HibernateJpaProject)) continue;
                    String ccName = ((HibernateJpaProject)jpaProject).getDefaultConsoleConfigurationName();
                    if (!ccfg.getName().equals(ccName)) continue;
                    HibernateJptPlugin.this.rebuildJpaProject(jpaProject.getJavaProject().getProject());
                }
            }

            public void configurationBuilt(ConsoleConfiguration ccfg) {
                if (ccfg.getConfiguration() == null) {
                    return;
                }
                this.revalidateProjects(ccfg);
            }

            public void configurationRemoved(ConsoleConfiguration root, boolean forUpdate) {
                if (forUpdate) {
                    return;
                }
                this.revalidateProjects(root);
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        inst = null;
    }

    private void rebuildJpaProject(final IProject project) {
        try {
            IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        ((JpaProject.Reference)project.getAdapter(JpaProject.Reference.class)).rebuild();
                    }
                    catch (InterruptedException e) {
                        throw new CoreException((IStatus)new Status(8, "org.hibernate.eclipse.console", null, (Throwable)e));
                    }
                    project.build(6, monitor);
                }
            };
            try {
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            throw new RuntimeException(te);
        }
    }
}

