/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.config.internal;

import java.util.Arrays;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.thym.core.config.Icon;
import org.eclipse.thym.core.config.Splash;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.config.internal.ConfigEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class IconsPage
extends FormPage {
    private DataBindingContext m_bindingContext;
    private FormToolkit formToolkit;
    private Table iconsTable;
    private Table splashTable;
    private Text txtWidth;
    private Text txtHeight;
    private Text txtPlatform;
    private Text txtDensity;
    private TableViewer iconsTableViewer;
    private TableViewer splashTableViewer;
    private Text txtSplshWidth;
    private Text txtSplshHeight;
    private Text txtSplshPlatform;
    private Text txtSplshDensity;

    public IconsPage(FormEditor editor) {
        super(editor, "icons", "Icons && Splash Screen");
        this.formToolkit = editor.getToolkit();
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        this.formToolkit.decorateFormHeading(form.getForm());
        managedForm.getForm().setText(this.getTitle());
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.makeColumnsEqualWidth = true;
        tableWrapLayout.numColumns = 1;
        managedForm.getForm().getBody().setLayout((Layout)tableWrapLayout);
        Section sctnIcons = managedForm.getToolkit().createSection(managedForm.getForm().getBody(), 256);
        TableWrapData twd_sctnIcons = new TableWrapData(128, 16, 1, 1);
        twd_sctnIcons.grabHorizontal = true;
        sctnIcons.setLayoutData((Object)twd_sctnIcons);
        managedForm.getToolkit().paintBordersFor((Composite)sctnIcons);
        sctnIcons.setText("Icons");
        Composite composite = managedForm.getToolkit().createComposite((Composite)sctnIcons, 0);
        managedForm.getToolkit().paintBordersFor(composite);
        sctnIcons.setClient((Control)composite);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.iconsTableViewer = new TableViewer(composite, 67584);
        this.iconsTable = this.iconsTableViewer.getTable();
        this.iconsTable.setHeaderVisible(true);
        GridData gd_iconsTable = new GridData(4, 4, true, false, 1, 1);
        gd_iconsTable.heightHint = 125;
        this.iconsTable.setLayoutData((Object)gd_iconsTable);
        managedForm.getToolkit().paintBordersFor((Composite)this.iconsTable);
        Composite composite_3 = managedForm.getToolkit().createComposite(composite, 0);
        composite_3.setLayoutData((Object)new GridData(16384, 1024, false, false, 1, 1));
        managedForm.getToolkit().paintBordersFor(composite_3);
        composite_3.setLayout((Layout)new FillLayout(512));
        Button btnIconAdd = managedForm.getToolkit().createButton(composite_3, "Add...", 0);
        btnIconAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String src = IconsPage.this.getImageSrc();
                ConfigEditor editor = (ConfigEditor)IconsPage.this.getEditor();
                Icon icon = editor.getWidgetModel().createIcon(IconsPage.this.getWidget());
                icon.setSrc(src);
                IconsPage.this.getWidget().addIcon(icon);
            }
        });
        Button btnIconRemove = managedForm.getToolkit().createButton(composite_3, "Remove", 0);
        Group iconDetailGrp = new Group(composite, 0);
        iconDetailGrp.setText("Icon Image Details");
        iconDetailGrp.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        managedForm.getToolkit().adapt((Composite)iconDetailGrp);
        managedForm.getToolkit().paintBordersFor((Composite)iconDetailGrp);
        iconDetailGrp.setLayout((Layout)new GridLayout(1, false));
        Composite imageDetailComposite = managedForm.getToolkit().createComposite((Composite)iconDetailGrp, 0);
        managedForm.getToolkit().paintBordersFor(imageDetailComposite);
        imageDetailComposite.setLayout((Layout)new GridLayout(2, false));
        managedForm.getToolkit().createLabel(imageDetailComposite, "Width:", 0);
        this.txtWidth = managedForm.getToolkit().createText(imageDetailComposite, "New Text", 0);
        this.txtWidth.setText("");
        this.txtWidth.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        managedForm.getToolkit().createLabel(imageDetailComposite, "Height:", 0);
        this.txtHeight = managedForm.getToolkit().createText(imageDetailComposite, "New Text", 0);
        this.txtHeight.setText("");
        this.txtHeight.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        managedForm.getToolkit().createLabel(imageDetailComposite, "Platform:", 0);
        this.txtPlatform = managedForm.getToolkit().createText(imageDetailComposite, "New Text", 0);
        this.txtPlatform.setText("");
        this.txtPlatform.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        managedForm.getToolkit().createLabel(imageDetailComposite, "Density:", 0);
        this.txtDensity = managedForm.getToolkit().createText(imageDetailComposite, "New Text", 0);
        this.txtDensity.setText("");
        this.txtDensity.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        btnIconRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)IconsPage.this.iconsTableViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Icon icon = (Icon)selection.getFirstElement();
                IconsPage.this.getWidget().removeIcon(icon);
            }
        });
        Section sctnSplashes = managedForm.getToolkit().createSection(managedForm.getForm().getBody(), 256);
        sctnSplashes.setLayoutData((Object)new TableWrapData(128, 16, 1, 1));
        managedForm.getToolkit().paintBordersFor((Composite)sctnSplashes);
        sctnSplashes.setText("Splash Screens");
        Composite composite_1 = managedForm.getToolkit().createComposite((Composite)sctnSplashes, 0);
        managedForm.getToolkit().paintBordersFor(composite_1);
        sctnSplashes.setClient((Control)composite_1);
        composite_1.setLayout((Layout)new GridLayout(3, false));
        this.splashTableViewer = new TableViewer(composite_1, 67584);
        this.splashTable = this.splashTableViewer.getTable();
        this.splashTable.setHeaderVisible(true);
        GridData gd_splashTable = new GridData(4, 4, true, false, 1, 1);
        gd_splashTable.heightHint = 125;
        this.splashTable.setLayoutData((Object)gd_splashTable);
        managedForm.getToolkit().paintBordersFor((Composite)this.splashTable);
        Composite composite_4 = managedForm.getToolkit().createComposite(composite_1, 0);
        composite_4.setLayoutData((Object)new GridData(16384, 1024, false, false, 1, 1));
        managedForm.getToolkit().paintBordersFor(composite_4);
        composite_4.setLayout((Layout)new FillLayout(512));
        Button btnSplashAdd = managedForm.getToolkit().createButton(composite_4, "Add...", 0);
        btnSplashAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String src = IconsPage.this.getImageSrc();
                Splash splash = ((ConfigEditor)IconsPage.this.getEditor()).getWidgetModel().createSplash(IconsPage.this.getWidget());
                splash.setSrc(src);
                IconsPage.this.getWidget().addSplash(splash);
            }
        });
        Button btnSplashRemove = managedForm.getToolkit().createButton(composite_4, "Remove", 0);
        Group splashDetailGrp = new Group(composite_1, 0);
        splashDetailGrp.setText("Splash Image Details");
        managedForm.getToolkit().adapt((Composite)splashDetailGrp);
        managedForm.getToolkit().paintBordersFor((Composite)splashDetailGrp);
        splashDetailGrp.setLayout((Layout)new GridLayout(1, false));
        Composite splashDetailComposite = managedForm.getToolkit().createComposite((Composite)splashDetailGrp, 0);
        managedForm.getToolkit().paintBordersFor(splashDetailComposite);
        splashDetailComposite.setLayout((Layout)new GridLayout(2, false));
        managedForm.getToolkit().createLabel(splashDetailComposite, "Width:", 0);
        this.txtSplshWidth = managedForm.getToolkit().createText(splashDetailComposite, "New Text", 0);
        this.txtSplshWidth.setText("");
        this.txtSplshWidth.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        managedForm.getToolkit().createLabel(splashDetailComposite, "Height:", 0);
        this.txtSplshHeight = managedForm.getToolkit().createText(splashDetailComposite, "New Text", 0);
        this.txtSplshHeight.setText("");
        this.txtSplshHeight.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        managedForm.getToolkit().createLabel(splashDetailComposite, "Platform:", 0);
        this.txtSplshPlatform = managedForm.getToolkit().createText(splashDetailComposite, "New Text", 0);
        this.txtSplshPlatform.setText("");
        this.txtSplshPlatform.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        managedForm.getToolkit().createLabel(splashDetailComposite, "Density:", 0);
        this.txtSplshDensity = managedForm.getToolkit().createText(splashDetailComposite, "New Text", 0);
        this.txtSplshDensity.setText("");
        this.txtSplshDensity.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        btnSplashRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)IconsPage.this.splashTableViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Splash splash = (Splash)selection.getFirstElement();
                IconsPage.this.getWidget().removeSplash(splash);
            }
        });
        this.m_bindingContext = this.initDataBindings();
    }

    private String getImageSrc() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getSite().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle("Choose image");
        IProject currentProject = this.getProject();
        dialog.setInput((Object)currentProject.getFolder("www"));
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IResource resource = (IResource)element;
                return resource.getType() == 2 || Arrays.binarySearch(WidgetModel.ICON_EXTENSIONS, resource.getFileExtension()) >= 0;
            }
        });
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0 || selection.length > 1) {
                    return new Status(4, "org.eclipse.thym.ui", "Must have selection");
                }
                IResource resource = (IResource)selection[0];
                if (resource.getType() == 2) {
                    return new Status(4, "org.eclipse.thym.ui", "Can not select folder");
                }
                return Status.OK_STATUS;
            }
        });
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            String src = resource.getProjectRelativePath().toString().substring("www".length() + 1);
            return src;
        }
        return null;
    }

    private IProject getProject() {
        IEditorPart editorPart = HybridUI.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart.getEditorInput() instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)editorPart.getEditorInput();
            IProject activeProject = input.getFile().getProject();
            return activeProject;
        }
        return null;
    }

    private Widget getWidget() {
        return ((ConfigEditor)this.getEditor()).getWidget();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = BeansObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), Icon.class, (String)"src");
        this.iconsTableViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.iconsTableViewer.setContentProvider((IContentProvider)listContentProvider);
        IObservableList iconsGetWidgetObserveList = BeanProperties.list((String)"icons").observe((Object)this.getWidget());
        this.iconsTableViewer.setInput((Object)iconsGetWidgetObserveList);
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap observeMap_1 = BeansObservables.observeMap((IObservableSet)listContentProvider_1.getKnownElements(), Splash.class, (String)"src");
        this.splashTableViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_1));
        this.splashTableViewer.setContentProvider((IContentProvider)listContentProvider_1);
        IObservableList splashesGetWidgetObserveList = BeanProperties.list((String)"splashes").observe((Object)this.getWidget());
        this.splashTableViewer.setInput((Object)splashesGetWidgetObserveList);
        IViewerObservableValue observeSingleSelectionIconsTableViewer = ViewerProperties.singleSelection().observe((Viewer)this.iconsTableViewer);
        IObservableValue iconsTableViewerWidthObserveDetailValue = BeanProperties.value(Icon.class, (String)"width", Integer.TYPE).observeDetail((IObservableValue)observeSingleSelectionIconsTableViewer);
        ISWTObservableValue observeTextTxtWidthObserveWidget = WidgetProperties.text((int)24).observe((org.eclipse.swt.widgets.Widget)this.txtWidth);
        bindingContext.bindValue(iconsTableViewerWidthObserveDetailValue, (IObservableValue)observeTextTxtWidthObserveWidget, null, null);
        IViewerObservableValue observeSingleSelectionIconsTableViewer_1 = ViewerProperties.singleSelection().observe((Viewer)this.iconsTableViewer);
        IObservableValue iconsTableViewerHeightObserveDetailValue = BeanProperties.value(Icon.class, (String)"height", Integer.TYPE).observeDetail((IObservableValue)observeSingleSelectionIconsTableViewer_1);
        ISWTObservableValue observeTextTxtHeightObserveWidget = WidgetProperties.text((int)24).observe((org.eclipse.swt.widgets.Widget)this.txtHeight);
        bindingContext.bindValue(iconsTableViewerHeightObserveDetailValue, (IObservableValue)observeTextTxtHeightObserveWidget, null, null);
        IViewerObservableValue observeSingleSelectionIconsTableViewer_2 = ViewerProperties.singleSelection().observe((Viewer)this.iconsTableViewer);
        IObservableValue iconsTableViewerPlatformObserveDetailValue = BeanProperties.value(Icon.class, (String)"platform", String.class).observeDetail((IObservableValue)observeSingleSelectionIconsTableViewer_2);
        ISWTObservableValue observeTextTxtPlatformObserveWidget = WidgetProperties.text((int)24).observe((org.eclipse.swt.widgets.Widget)this.txtPlatform);
        bindingContext.bindValue(iconsTableViewerPlatformObserveDetailValue, (IObservableValue)observeTextTxtPlatformObserveWidget, null, null);
        IViewerObservableValue observeSingleSelectionIconsTableViewer_3 = ViewerProperties.singleSelection().observe((Viewer)this.iconsTableViewer);
        IObservableValue iconsTableViewerDensityObserveDetailValue = BeanProperties.value(Icon.class, (String)"density", String.class).observeDetail((IObservableValue)observeSingleSelectionIconsTableViewer_3);
        ISWTObservableValue observeTextTxtDensityObserveWidget = WidgetProperties.text((int)24).observe((org.eclipse.swt.widgets.Widget)this.txtDensity);
        bindingContext.bindValue(iconsTableViewerDensityObserveDetailValue, (IObservableValue)observeTextTxtDensityObserveWidget, null, null);
        IViewerObservableValue observeSingleSelectionSplashTableViewer = ViewerProperties.singleSelection().observe((Viewer)this.splashTableViewer);
        IObservableValue splashTableViewerWidthObserveDetailValue = BeanProperties.value(Splash.class, (String)"width", Integer.TYPE).observeDetail((IObservableValue)observeSingleSelectionSplashTableViewer);
        ISWTObservableValue observeTextTxtSplshWidthObserveWidget = WidgetProperties.text((int)24).observe((org.eclipse.swt.widgets.Widget)this.txtSplshWidth);
        bindingContext.bindValue(splashTableViewerWidthObserveDetailValue, (IObservableValue)observeTextTxtSplshWidthObserveWidget, null, null);
        IViewerObservableValue observeSingleSelectionSplashTableViewer_1 = ViewerProperties.singleSelection().observe((Viewer)this.splashTableViewer);
        IObservableValue splashTableViewerHeightObserveDetailValue = BeanProperties.value(Splash.class, (String)"height", Integer.TYPE).observeDetail((IObservableValue)observeSingleSelectionSplashTableViewer_1);
        ISWTObservableValue observeTextTxtSplshHeightObserveWidget = WidgetProperties.text((int)24).observe((org.eclipse.swt.widgets.Widget)this.txtSplshHeight);
        bindingContext.bindValue(splashTableViewerHeightObserveDetailValue, (IObservableValue)observeTextTxtSplshHeightObserveWidget, null, null);
        IViewerObservableValue observeSingleSelectionSplashTableViewer_2 = ViewerProperties.singleSelection().observe((Viewer)this.splashTableViewer);
        IObservableValue splashTableViewerPlatformObserveDetailValue = BeanProperties.value(Splash.class, (String)"platform", String.class).observeDetail((IObservableValue)observeSingleSelectionSplashTableViewer_2);
        ISWTObservableValue observeTextTxtSplshPlatformObserveWidget = WidgetProperties.text((int)24).observe((org.eclipse.swt.widgets.Widget)this.txtSplshPlatform);
        bindingContext.bindValue(splashTableViewerPlatformObserveDetailValue, (IObservableValue)observeTextTxtSplshPlatformObserveWidget, null, null);
        IViewerObservableValue observeSingleSelectionSplashTableViewer_3 = ViewerProperties.singleSelection().observe((Viewer)this.splashTableViewer);
        IObservableValue splashTableViewerDensityObserveDetailValue = BeanProperties.value(Splash.class, (String)"density", String.class).observeDetail((IObservableValue)observeSingleSelectionSplashTableViewer_3);
        ISWTObservableValue observeTextTxtSplshDensityObserveWidget = WidgetProperties.text((int)24).observe((org.eclipse.swt.widgets.Widget)this.txtSplshDensity);
        bindingContext.bindValue(splashTableViewerDensityObserveDetailValue, (IObservableValue)observeTextTxtSplshDensityObserveWidget, null, null);
        return bindingContext;
    }
}

