/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.config.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.ui.config.internal.EssentialsPage;
import org.eclipse.thym.ui.config.internal.PropertiesPage;
import org.eclipse.thym.ui.config.internal.SourceEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;

public class ConfigEditor
extends FormEditor {
    public static final String ID = "org.eclipse.thym.ui.config.internal.ConfigEditor";
    private SourceEditor sourceEditor;
    private Widget widget;
    private WidgetModel model;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setTitle(input);
    }

    private void setTitle(IEditorInput input) {
        IResource res;
        String title = null;
        Widget w = this.getWidget();
        if (w != null) {
            title = this.getWidget().getName();
        }
        if ((title == null || title.isEmpty()) && (res = (IResource)input.getAdapter(IResource.class)) != null) {
            title = res.getProject().getName();
        }
        this.setPartName(title);
    }

    public Object getAdapter(Class adapter) {
        Object object = super.getAdapter(adapter);
        if (object != null) {
            return object;
        }
        return this.sourceEditor != null ? this.sourceEditor.getAdapter(adapter) : null;
    }

    public void doSave(IProgressMonitor monitor) {
        this.sourceEditor.doSave(monitor);
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void addPages() {
        this.sourceEditor = new SourceEditor();
        try {
            this.addPage((IFormPage)new EssentialsPage(this));
            this.addPage((IFormPage)new PropertiesPage(this));
            int sourcePageIndex = this.addPage((IEditorPart)this.sourceEditor, this.getEditorInput());
            this.setPageText(sourcePageIndex, "config.xml");
            this.firePropertyChange(1);
            IFile f = this.getFile();
            if (f != null && f.exists()) {
                new ResourceChangeListener(this, this.getContainer());
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public Widget getWidget() {
        IFile file;
        if (this.widget == null && (file = (IFile)this.getEditorInput().getAdapter(IFile.class)) != null) {
            HybridProject prj = HybridProject.getHybridProject((IProject)file.getProject());
            WidgetModel model = WidgetModel.getModel((HybridProject)prj);
            try {
                this.widget = model.getWidgetForEdit();
            }
            catch (CoreException e) {
                HybridCore.log((int)4, (String)"Error when retrieving the widget model", (Throwable)e);
            }
        }
        return this.widget;
    }

    public void dispose() {
        super.dispose();
        if (this.model != null) {
            this.model.dispose();
        }
    }

    public WidgetModel getWidgetModel() {
        IFile file;
        if (this.model == null && (file = (IFile)this.getEditorInput().getAdapter(IFile.class)) != null) {
            HybridProject prj = HybridProject.getHybridProject((IProject)file.getProject());
            this.model = WidgetModel.getModel((HybridProject)prj);
        }
        return this.model;
    }

    private IFile getFile() {
        IEditorInput input = this.getEditorInput();
        return input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
    }

    class ResourceChangeListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        ConfigEditor editorPart;

        ResourceChangeListener(ConfigEditor editorPart, Composite container) {
            this.editorPart = editorPart;
            final IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener((IResourceChangeListener)this);
            container.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    workspace.removeResourceChangeListener((IResourceChangeListener)ResourceChangeListener.this);
                }
            });
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException exception) {
                HybridCore.log((int)4, (String)"Error when retrieving IResourceDelta", (Throwable)exception);
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals((Object)((FileEditorInput)ConfigEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                if ((0x2000 & delta.getFlags()) == 0) {
                    if (!ConfigEditor.this.isDirty()) {
                        this.closeEditor();
                    }
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    Display display = ConfigEditor.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ResourceChangeListener.this.editorPart.setInput((IEditorInput)new FileEditorInput(newFile));
                        }
                    });
                }
            }
            return false;
        }

        private void closeEditor() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ResourceChangeListener.this.editorPart.getSite().getPage().closeEditor((IEditorPart)ResourceChangeListener.this.editorPart, false);
                }
            });
        }
    }
}

