/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.cheatsheet.internal.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.junit.launcher.JUnitLaunchShortcut;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.CompCSEditor;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.SimpleCSEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.cheatsheets.state.DefaultStateManager;
import org.eclipse.ui.internal.cheatsheets.state.ICheatSheetStateManager;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetView;
import org.eclipse.ui.internal.cheatsheets.views.ViewUtilities;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.actions.RunOnServerAction;
import org.jboss.ide.eclipse.as.core.modules.SingleDeployableFactory;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.tools.common.model.ui.editor.EditorPartWrapper;
import org.jboss.tools.project.examples.cheatsheet.Activator;
import org.jboss.tools.project.examples.cheatsheet.Messages;
import org.jboss.tools.project.examples.cheatsheet.internal.util.AutoResizeTableLayout;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.osgi.service.prefs.BackingStoreException;

public class CheatSheetUtil {
    private static final String ACTIVE_PROFILES = "activeProfiles";

    public static IProject getProject() {
        IFile file;
        IEditorInput input;
        IEditorPart activeEditor;
        IWorkbenchPage page;
        String href;
        CheatSheetView view = ViewUtilities.showCheatSheetView();
        if (view != null && view.getContent() != null && (href = view.getContent().getHref()) != null) {
            try {
                URL url = new URL(href);
                File file2 = null;
                if ("file".equals(url.getProtocol())) {
                    try {
                        file2 = new File(new URI(url.toExternalForm()));
                    }
                    catch (Exception exception) {
                        file2 = new File(url.getFile());
                    }
                }
                return CheatSheetUtil.getProject(file2);
            }
            catch (MalformedURLException e) {
                Activator.log(e);
            }
        }
        if ((page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null && ((activeEditor = page.getActiveEditor()) instanceof SimpleCSEditor || activeEditor instanceof CompCSEditor) && (input = activeEditor.getEditorInput()) instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null && file.exists()) {
            return file.getProject();
        }
        return null;
    }

    public static IProject getProject(File file) {
        if (file != null && file.exists()) {
            IFile iFile;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPath location = Path.fromOSString((String)file.getAbsolutePath());
            if (location != null && (iFile = workspace.getRoot().getFileForLocation(location)) != null) {
                return iFile.getProject();
            }
        }
        return null;
    }

    public static ITextEditor getTextEditor(IEditorPart editor) {
        if (editor instanceof ITextEditor) {
            return (ITextEditor)editor;
        }
        if (editor instanceof MultiPageEditorPart) {
            MultiPageEditorPart multiPageEditor = (MultiPageEditorPart)editor;
            IEditorPart[] editors = multiPageEditor.findEditors(editor.getEditorInput());
            int i = 0;
            while (i < editors.length) {
                ITextEditor textEditor;
                if (editors[i] instanceof ITextEditor && (textEditor = (ITextEditor)editors[i]).getDocumentProvider() != null) {
                    return (ITextEditor)editors[i];
                }
                ++i;
            }
        }
        if (editor instanceof EditorPartWrapper) {
            EditorPartWrapper wrapper = (EditorPartWrapper)editor;
            IEditorPart nestedEditor = wrapper.getEditor();
            return CheatSheetUtil.getTextEditor(nestedEditor);
        }
        return null;
    }

    private static void setStatusMessage(IWorkbenchPage page, String message) {
        IWorkbenchPart activePart = page.getActivePart();
        IWorkbenchPartSite site = activePart.getSite();
        IActionBars actionBar = null;
        if (site instanceof IViewSite) {
            IViewSite viewSite = (IViewSite)site;
            actionBar = viewSite.getActionBars();
        } else if (site instanceof IEditorSite) {
            IEditorSite editorSite = (IEditorSite)site;
            actionBar = editorSite.getActionBars();
        }
        if (actionBar == null) {
            return;
        }
        IStatusLineManager lineManager = actionBar.getStatusLineManager();
        if (lineManager == null) {
            return;
        }
        lineManager.setMessage(message);
    }

    public static void openFile(String pathName, String fromLine, String toLine, String editorID) {
        String fileName = pathName;
        Path path = new Path(fileName);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IFile file = workspaceRoot.getFile((IPath)path);
        if (!file.exists()) {
            CheatSheetUtil.setStatusMessage(page, NLS.bind((String)Messages.OpenFileInEditor_Cannot_open, (Object)path));
            return;
        }
        IEditorPart editor = null;
        try {
            if (editorID != null && editorID.trim().length() > 0) {
                try {
                    editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)editorID, (boolean)true);
                }
                catch (Exception exception) {}
            }
            if (editor == null) {
                editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
        }
        catch (PartInitException partInitException) {
            CheatSheetUtil.setStatusMessage(page, NLS.bind((String)Messages.OpenFileInEditor_Cannot_open, (Object)path));
            return;
        }
        ITextEditor textEditor = CheatSheetUtil.getTextEditor(editor);
        if (fromLine != null && textEditor != null) {
            try {
                int lineStart;
                int lineEnd = lineStart = Integer.parseInt(fromLine);
                if (toLine != null) {
                    lineEnd = Integer.parseInt(toLine);
                }
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                IRegion lineInfoStart = document.getLineInformation(lineStart - 1);
                IRegion lineInfoEnd = document.getLineInformation(lineEnd - 1);
                textEditor.selectAndReveal(lineInfoStart.getOffset(), lineInfoEnd.getOffset() - lineInfoStart.getOffset() + lineInfoEnd.getLength());
            }
            catch (Exception e) {
                CheatSheetUtil.setStatusMessage(page, e.getLocalizedMessage());
            }
        }
    }

    public static void runOnServer(String name, String path) {
        IFile file;
        String projectName;
        IWorkspaceRoot wRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wRoot.getProject(projectName = name);
        if (project == null || !project.isOpen()) {
            return;
        }
        if (path != null && (file = wRoot.getFile((IPath)new Path(path))) != null && file.exists()) {
            try {
                SingleDeployableFactory.makeDeployable((IPath)file.getFullPath());
                IServer[] deployableServersAsIServers = ServerConverter.getDeployableServersAsIServers();
                if (deployableServersAsIServers.length == 1) {
                    IServer server = deployableServersAsIServers[0];
                    IServerWorkingCopy copy = server.createWorkingCopy();
                    IModule[] modules = new IModule[]{SingleDeployableFactory.findModule((IPath)file.getFullPath())};
                    copy.modifyModules(modules, new IModule[0], (IProgressMonitor)new NullProgressMonitor());
                    IServer saved = copy.save(false, (IProgressMonitor)new NullProgressMonitor());
                    saved.publish(1, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                Status status = new Status(1, "org.jboss.tools.project.examples.cheatsheet", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        RunOnServerAction action = new RunOnServerAction((Object)project);
        action.run();
    }

    @Deprecated
    public static void launchJUnitTest(String projectName, String profile, String mode) {
        String activeProfiles;
        ProjectScope projectScope;
        IEclipsePreferences projectNode;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(projectName);
        if (project == null || !project.isOpen()) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            CheatSheetUtil.setStatusMessage(page, NLS.bind((String)Messages.LaunchJunitTest_The_project_does_not_exist, (Object)projectName));
            return;
        }
        if (profile != null && (projectNode = (projectScope = new ProjectScope(project)).getNode("org.eclipse.m2e.core")) != null && !profile.equals(activeProfiles = projectNode.get(ACTIVE_PROFILES, null))) {
            projectNode.put(ACTIVE_PROFILES, profile);
            try {
                projectNode.flush();
            }
            catch (BackingStoreException e) {
                Activator.log(e);
            }
        }
        StructuredSelection selection = new StructuredSelection((Object)project);
        JUnitLaunchShortcut launchShortcut = new JUnitLaunchShortcut();
        if (mode == null) {
            mode = "run";
        }
        if (!"run".equals(mode) && !"debug".equals(mode)) {
            mode = "run";
        }
        launchShortcut.launch((ISelection)selection, mode);
    }

    public static boolean showCheatsheet(IFile file) {
        block4: {
            CheatSheetView view;
            block5: {
                IContentDescription contentDescription = file.getContentDescription();
                IContentType contentType = contentDescription.getContentType();
                if (contentType == null || !"org.eclipse.pde.simpleCheatSheet".equals(contentType.getId())) break block4;
                view = ViewUtilities.showCheatSheetView();
                if (view != null) break block5;
                return false;
            }
            try {
                IPath filePath = file.getFullPath();
                String id = filePath.lastSegment();
                if (id == null) {
                    id = "";
                }
                URL url = file.getLocation().toFile().toURI().toURL();
                view.getCheatSheetViewer().setInput(id, id, url, (ICheatSheetStateManager)new DefaultStateManager(), false);
                return true;
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
        return false;
    }

    public static void showCheatsheet(final List<IFile> cheatsheets) {
        if (cheatsheets == null || cheatsheets.size() == 0) {
            return;
        }
        String value = ProjectExamplesActivator.getDefault().getShowCheatsheets();
        if ("never".equals(value)) {
            return;
        }
        final IFile[] file = new IFile[]{cheatsheets.get(0)};
        if ("prompt".equals(value) || cheatsheets.size() > 0) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    file[0] = CheatSheetUtil.promptToShowCheatsheets(cheatsheets);
                }
            });
        }
        if (file[0] != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CheatSheetUtil.showCheatsheet(file[0]);
                }
            });
        }
    }

    private static IFile promptToShowCheatsheets(List<IFile> cheatsheets) {
        String key;
        IPreferenceStore store = ProjectExamplesActivator.getDefault().getPreferenceStore();
        String value = store.getString(key = "showCheatsheets");
        if ("always".equals(value) && cheatsheets.size() == 1) {
            return cheatsheets.get(0);
        }
        if ("never".equals(value)) {
            return null;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (cheatsheets.size() == 1) {
            String title = "Found cheatsheet";
            String projectName = cheatsheets.get(0).getProject().getName();
            String message = "Do you wish to open the cheatsheet for the '" + projectName + "' project?";
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)title, (String)message, null, (boolean)false, (IPreferenceStore)store, (String)key);
            int result = dialog.getReturnCode();
            if (result == 1 || result == -1) {
                throw new OperationCanceledException();
            }
            if (dialog.getReturnCode() == 2) {
                return cheatsheets.get(0);
            }
        } else {
            int kind = 3;
            String[] buttonLabels = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
            String title = "Found cheatsheets";
            String message = "Please select the cheatsheet you want to show:";
            MyMessageDialogWithToggle dialog = new MyMessageDialogWithToggle(shell, title, null, message, kind, buttonLabels, 0, null, false, cheatsheets);
            dialog.setPrefStore(store);
            dialog.setPrefKey(key);
            dialog.open();
            int result = dialog.getReturnCode();
            if (result == 1 || result == -1) {
                throw new OperationCanceledException();
            }
            if (dialog.getReturnCode() == 0) {
                return dialog.getCheatsheet();
            }
        }
        return null;
    }

    private static TableViewer createCheatsheetViewer(Composite parent, final List<IFile> cheatsheets) {
        TableViewer viewer = new TableViewer(parent, 68356);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 100;
        viewer.getTable().setLayoutData((Object)gd);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return cheatsheets.toArray(new IFile[0]);
            }

            public void dispose() {
            }
        });
        String[] columnHeaders = new String[]{"Project", "Name"};
        int i = 0;
        while (i < columnHeaders.length) {
            TableViewerColumn column = new TableViewerColumn(viewer, 0);
            column.setLabelProvider((CellLabelProvider)new CheatsheetLabelProvider(i));
            column.getColumn().setText(columnHeaders[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            ++i;
        }
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnWeightData(100, 100), new ColumnWeightData(60, 60)};
        AutoResizeTableLayout layout = new AutoResizeTableLayout(table);
        int i2 = 0;
        while (i2 < layouts.length) {
            layout.addColumnData(layouts[i2]);
            ++i2;
        }
        viewer.getTable().setLayout((Layout)layout);
        CheatSheetUtil.configureViewer(viewer);
        viewer.setInput(cheatsheets);
        return viewer;
    }

    private static void configureViewer(final TableViewer viewer) {
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)viewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                ViewerCell cell = viewer.getColumnViewerEditor().getFocusCell();
                if (cell != null && cell.getColumnIndex() == 1) {
                    return super.isEditorActivationEvent(event);
                }
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)viewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
    }

    private static class CheatsheetLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        public CheatsheetLabelProvider(int i) {
            this.columnIndex = i;
        }

        public String getText(Object element) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                switch (this.columnIndex) {
                    case 0: {
                        return file.getProject().getName();
                    }
                    case 1: {
                        return file.getName();
                    }
                }
            }
            return null;
        }
    }

    private static class MyMessageDialogWithToggle
    extends MessageDialogWithToggle {
        private List<IFile> cheatsheets;
        private IFile selectedCheatsheet;

        public MyMessageDialogWithToggle(Shell parentShell, String dialogTitle, Image image, String message, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String toggleMessage, boolean toggleState, List<IFile> cheatsheets) {
            super(parentShell, dialogTitle, image, message, 0, dialogButtonLabels, defaultIndex, toggleMessage, toggleState);
            this.setShellStyle(this.getShellStyle() | 0x10000000);
            this.cheatsheets = cheatsheets;
            this.selectedCheatsheet = cheatsheets.get(0);
        }

        public IFile getCheatsheet() {
            return this.selectedCheatsheet;
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            data.horizontalSpan = 2;
            composite.setLayoutData((Object)data);
            TableViewer viewer = CheatSheetUtil.createCheatsheetViewer(composite, this.cheatsheets);
            viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object object;
                    MyMessageDialogWithToggle.this.getButton(0).setEnabled(false);
                    ISelection sel = event.getSelection();
                    if (sel instanceof IStructuredSelection && (object = ((IStructuredSelection)sel).getFirstElement()) instanceof IFile) {
                        MyMessageDialogWithToggle.this.selectedCheatsheet = (IFile)object;
                        MyMessageDialogWithToggle.this.getButton(0).setEnabled(true);
                    }
                }
            });
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.getButton(0).setEnabled(false);
        }
    }
}

