/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.wizard.service;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.common.ui.CommonUIPlugin;
import org.jboss.tools.common.ui.wizard.service.RegisterAsServiceDialog;
import org.jboss.tools.common.ui.wizard.service.RegisterServiceUtil;

public class RegisterAsServiceHandler
extends AbstractHandler {
    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(this.computeEnabled(evaluationContext));
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getSelectionService().getSelection();
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        RegisterAsServiceHandler.invokeWizard(selection, shell);
        return null;
    }

    private boolean computeEnabled(Object evaluationContext) {
        if (evaluationContext instanceof IEvaluationContext) {
            IEvaluationContext c = (IEvaluationContext)evaluationContext;
            ISelection selection = (ISelection)c.getVariable("selection");
            return RegisterAsServiceHandler.getSelectedType(selection) != null;
        }
        return false;
    }

    public static IType getSelectedType(ISelection selection) {
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            for (Object selected : ((IStructuredSelection)selection).toList()) {
                try {
                    IType type;
                    if (selected instanceof ICompilationUnit) {
                        ICompilationUnit u = (ICompilationUnit)selected;
                        IType[] iTypeArray = u.getTypes();
                        int n = iTypeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType type2 = iTypeArray[n2];
                            if (RegisterAsServiceHandler.accept(type2)) {
                                return type2;
                            }
                            ++n2;
                        }
                        continue;
                    }
                    if (!(selected instanceof IType) || !RegisterAsServiceHandler.accept(type = (IType)selected)) continue;
                    return type;
                }
                catch (CoreException e) {
                    CommonUIPlugin.getDefault().logError(e);
                }
            }
        }
        return null;
    }

    private static boolean accept(IType type) throws CoreException {
        return !type.isInterface() && !type.isAnnotation() && !Flags.isAbstract((int)type.getFlags());
    }

    public static void invokeWizard(ISelection selection, Shell shell) {
        IType type = RegisterAsServiceHandler.getSelectedType(selection);
        if (type == null) {
            return;
        }
        RegisterAsServiceDialog dialog = new RegisterAsServiceDialog(shell, type);
        try {
            if (dialog.open() == 0) {
                RegisterServiceUtil.registerService(type, dialog.getResult());
            }
        }
        catch (CoreException e) {
            CommonUIPlugin.getDefault().logError(e);
        }
    }
}

