/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.ui.CommonUIPlugin;
import org.jboss.tools.common.ui.JobResultFuture;
import org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor;

public class WizardUtils {
    private static final long THREAD_SLEEP = 1000L;
    private static final int NO_TIMEOUT = -1;

    private WizardUtils() {
    }

    public static IStatus runInWizard(Job job, IWizardContainer container) throws InvocationTargetException, InterruptedException {
        return WizardUtils.runInWizard(job, null, container);
    }

    public static IStatus runInWizard(Job job, DelegatingProgressMonitor delegatingMonitor, IWizardContainer container) throws InvocationTargetException, InterruptedException {
        return WizardUtils.runInWizard(job, delegatingMonitor, container, -1L);
    }

    public static IStatus runInWizard(final Job job, final DelegatingProgressMonitor delegatingMonitor, IWizardContainer container, final long timeout) throws InvocationTargetException, InterruptedException {
        final JobResultFuture future = new JobResultFuture(job);
        container.run(true, true, new IRunnableWithProgress(){

            /*
             * Exception decompiling
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
                 *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
                 *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        return WizardUtils.getStatus(job, future);
    }

    private static void waitForFuture(long timeout, JobResultFuture future, IProgressMonitor monitor) throws InterruptedException, ExecutionException, TimeoutException {
        long startTime = System.currentTimeMillis();
        while (!future.isDone()) {
            if (timeout > 0L && WizardUtils.isTimeouted(startTime, timeout) || monitor.isCanceled()) {
                future.cancel(true);
                break;
            }
            Thread.sleep(1000L);
        }
    }

    private static boolean isTimeouted(long startTime, long timeout) {
        return System.currentTimeMillis() - startTime > timeout;
    }

    private static IStatus getStatus(Job job, JobResultFuture future) {
        if (future.isCancelled()) {
            String message = NLS.bind((String)"The operation ''{0}'' was cancelled", (Object)job.getName());
            CommonUIPlugin.getDefault().logError(message);
            return new Status(8, "org.jboss.tools.common.ui", message);
        }
        if (future.isDone()) {
            return job.getResult();
        }
        String message = NLS.bind((String)"The operation ''{0}'' did not complete in a reasonnable amount of time", (Object)job.getName());
        CommonUIPlugin.getDefault().logError(message);
        return new Status(4, "org.jboss.tools.common.ui", message);
    }

    public static IStatus runInWizard(Job job, IWizardContainer container, DataBindingContext dbc) throws InvocationTargetException, InterruptedException {
        return WizardUtils.runInWizard(job, null, container, dbc);
    }

    public static IStatus runInWizard(Job job, DelegatingProgressMonitor monitor, IWizardContainer container, DataBindingContext dbc) throws InvocationTargetException, InterruptedException {
        IStatus status = WizardUtils.runInWizard(job, monitor, container);
        dbc.updateTargets();
        return status;
    }

    public static void nextPageOrFinish(IWizardPage wizardPage) {
        IWizard wizard = wizardPage.getWizard();
        if (wizardPage.canFlipToNextPage()) {
            IWizardPage nextPage = wizard.getNextPage(wizardPage);
            wizard.getContainer().showPage(nextPage);
        } else if (wizard.canFinish() && wizard.performFinish()) {
            wizard.getContainer().getShell().close();
        }
    }

    public static int openWizardDialog(IWizard wizard, Shell shell) {
        WizardDialog dialog = new WizardDialog(shell, wizard);
        dialog.create();
        return dialog.open();
    }

    public static void close(IWizard wizard) {
        IWizardContainer container = wizard.getContainer();
        if (container instanceof WizardDialog) {
            ((WizardDialog)container).close();
        }
    }

    public static boolean openWizardDialog(int width, int height, IWizard wizard, Shell shell) {
        WizardDialog dialog = WizardUtils.createWizardDialog(wizard, shell);
        dialog.setMinimumPageSize(width, height);
        return dialog.open() == 0;
    }

    private static WizardDialog createWizardDialog(IWizard wizard, Shell shell) {
        WizardDialog dialog = new WizardDialog(shell, wizard);
        dialog.create();
        return dialog;
    }

    public static boolean openWizardDialog(IWorkbenchWizard wizard, Shell shell) {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            return WizardUtils.openWizardDialog(wizard, shell, (IStructuredSelection)selection);
        }
        return WizardUtils.openWizardDialog(wizard, shell, null);
    }

    public static boolean openWizardDialog(IWorkbenchWizard wizard, Shell shell, IStructuredSelection selection) {
        WizardDialog wizardDialog = WizardUtils.createWizardDialog((IWizard)wizard, shell);
        wizard.init(PlatformUI.getWorkbench(), selection);
        return wizardDialog.open() == 0;
    }

    static /* synthetic */ void access$0(long l, JobResultFuture jobResultFuture, IProgressMonitor iProgressMonitor) throws InterruptedException, ExecutionException, TimeoutException {
        WizardUtils.waitForFuture(l, jobResultFuture, iProgressMonitor);
    }
}

