/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.playground.easymport.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.LifecycleMappingDiscoveryRequest;
import org.eclipse.m2e.core.internal.project.ProjectConfigurationManager;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.ui.internal.wizards.LifecycleMappingDiscoveryHelper;
import org.eclipse.m2e.core.ui.internal.wizards.MappingDiscoveryJob;
import org.eclipse.ui.internal.wizards.datatransfer.EasymportJob;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;
import org.jboss.tools.playground.easymport.maven.Activator;

public class MavenProjectConfigurator
implements ProjectConfigurator {
    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        LocalProjectScanner scanner = new LocalProjectScanner(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), root.getAbsolutePath(), false, MavenPlugin.getMavenModelManager());
        try {
            scanner.run(monitor);
        }
        catch (Exception ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.playground.easymport.maven", ex.getMessage(), (Throwable)ex));
            return null;
        }
        ArrayList projects = new ArrayList();
        projects.addAll(scanner.getProjects());
        HashSet<File> res = new HashSet<File>();
        int i = 0;
        while (i < projects.size()) {
            MavenProjectInfo projectInfo = (MavenProjectInfo)projects.get(i);
            res.add(projectInfo.getPomFile().getParentFile());
            projects.addAll(projectInfo.getProjects());
            ++i;
        }
        return res;
    }

    public boolean canConfigure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
        return this.shouldBeAnEclipseProject((IContainer)project, monitor);
    }

    public IWizard getConfigurationWizard() {
        return null;
    }

    public void configure(IProject project, Set<IPath> excludedDirectories, IProgressMonitor monitor) {
        ResolverConfiguration configuration = new ResolverConfiguration();
        configuration.setResolveWorkspaceProjects(true);
        MavenPlugin.getProjectConfigurationManager();
        try {
            if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                IProjectDescription description = project.getDescription();
                String[] prevNatures = description.getNatureIds();
                String[] newNatures = new String[prevNatures.length + 1];
                System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
                newNatures[0] = "org.eclipse.m2e.core.maven2Nature";
                description.setNatureIds(newNatures);
                project.setDescription(description, monitor);
            }
            UpdateMavenConfigurationJob.getInstance().addProjectToProcess(project);
            if (UpdateMavenConfigurationJob.getInstance().getState() == 0) {
                UpdateMavenConfigurationJob.getInstance().schedule();
            }
        }
        catch (Exception ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.playground.easymport.maven", ex.getMessage(), (Throwable)ex));
        }
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        IFile pomFile = container.getFile((IPath)new Path("pom.xml"));
        return pomFile.exists();
    }

    public Set<IFolder> getDirectoriesToIgnore(IProject project, IProgressMonitor monitor) {
        HashSet<IFolder> res = new HashSet<IFolder>();
        res.add(project.getFolder("src"));
        res.add(project.getFolder("target"));
        return res;
    }

    private static class CumulativeMappingDiscoveryJob
    extends MappingDiscoveryJob {
        private static CumulativeMappingDiscoveryJob INSTANCE;
        private Set<IProject> toProcess = Collections.synchronizedSet(new HashSet());
        private boolean started;

        public static synchronized CumulativeMappingDiscoveryJob getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new CumulativeMappingDiscoveryJob();
            }
            return INSTANCE;
        }

        private CumulativeMappingDiscoveryJob() {
            super(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            try {
                CumulativeMappingDiscoveryJob.getJobManager().join(EasymportJob.class, monitor);
            }
            catch (InterruptedException ex) {
                throw new CoreException((IStatus)new Status(2, Activator.getDefault().getBundle().getSymbolicName(), ex.getMessage(), (Throwable)ex));
            }
            Set<IProject> ex = this.toProcess;
            synchronized (ex) {
                this.started = true;
            }
            try {
                LifecycleMappingDiscoveryRequest discoveryRequest = LifecycleMappingDiscoveryHelper.createLifecycleMappingDiscoveryRequest(this.toProcess, (IProgressMonitor)monitor);
                if (discoveryRequest.isMappingComplete()) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                this.discoverProposals(discoveryRequest, monitor);
                this.openProposalWizard(this.toProcess, discoveryRequest);
                this.toProcess.clear();
            }
            finally {
                this.toProcess.clear();
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjects(Collection<IProject> projects) {
            Set<IProject> set = this.toProcess;
            synchronized (set) {
                if (this.started) {
                    throw new IllegalStateException("Cannot add projects when processing is started");
                }
                if (projects != null) {
                    this.toProcess.addAll(projects);
                }
            }
        }
    }

    private static class UpdateMavenConfigurationJob
    extends Job {
        private static UpdateMavenConfigurationJob INSTANCE;
        private Set<IProject> toProcess = new HashSet<IProject>();

        public static synchronized UpdateMavenConfigurationJob getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new UpdateMavenConfigurationJob();
            }
            return INSTANCE;
        }

        private UpdateMavenConfigurationJob() {
            super("Update Maven projects configuration");
            this.setUser(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectToProcess(IProject project) {
            Set<IProject> set = this.toProcess;
            synchronized (set) {
                this.toProcess.add(project);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            HashSet<IProject> toProcessNow = new HashSet<IProject>();
            while (!monitor.isCanceled()) {
                Set<IProject> set = this.toProcess;
                synchronized (set) {
                    if (this.toProcess.isEmpty()) {
                        CumulativeMappingDiscoveryJob.getInstance().schedule();
                        return Status.OK_STATUS;
                    }
                    for (IProject project : this.toProcess) {
                        toProcessNow.add(project);
                    }
                    this.toProcess.removeAll(toProcessNow);
                }
                if (toProcessNow.isEmpty()) continue;
                CumulativeMappingDiscoveryJob.getInstance().addProjects(toProcessNow);
                ProjectConfigurationManager configurationManager = (ProjectConfigurationManager)MavenPlugin.getProjectConfigurationManager();
                MavenUpdateRequest request = new MavenUpdateRequest(toProcessNow.toArray(new IProject[toProcessNow.size()]), false, false);
                configurationManager.updateProjectConfiguration(request, true, false, false, monitor);
            }
            return new Status(8, Activator.getDefault().getBundle().getSymbolicName(), "Cancelled by user");
        }
    }
}

