/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WorkingSetConfigurationBlock;
import org.eclipse.ui.internal.wizards.datatransfer.EasymportWizard;
import org.eclipse.ui.internal.wizards.datatransfer.Messages;
import org.eclipse.ui.internal.wizards.datatransfer.ProjectConfiguratorExtensionManager;

public class SelectImportRootWizardPage
extends WizardPage {
    public static final String ROOT_DIRECTORY = "rootDirectory";
    private File selection;
    private boolean detectNestedProjects = true;
    private boolean configureProjects = true;
    private Set<IWorkingSet> workingSets;
    private ControlDecoration rootDirectoryTextDecorator;
    private WorkingSetConfigurationBlock workingSetsBlock;
    private Text rootDirectoryText;

    public SelectImportRootWizardPage(IWizard wizard, File initialSelection, Set<IWorkingSet> initialWorkingSets) {
        super(EasymportWizard.class.getName());
        this.selection = initialSelection;
        this.workingSets = initialWorkingSets;
        if (this.workingSets == null) {
            this.workingSets = new HashSet<IWorkingSet>();
        }
        this.setWizard(wizard);
    }

    public void createControl(Composite parent) {
        String dialogSetting;
        this.setTitle(Messages.EasymportWizardPage_importProjectsInFolderTitle);
        this.setDescription(Messages.EasymportWizardPage_importProjectsInFolderDescription);
        Composite res = new Composite(parent, 0);
        res.setLayout((Layout)new GridLayout(3, false));
        Label rootDirectoryLabel = new Label(res, 0);
        rootDirectoryLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        rootDirectoryLabel.setText(Messages.EasymportWizardPage_selectRootDirectory);
        this.rootDirectoryText = new Text(res, 2048);
        this.rootDirectoryText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.rootDirectoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectImportRootWizardPage.this.selection = new File(((Text)e.widget).getText());
                SelectImportRootWizardPage.this.validatePage();
            }
        });
        this.rootDirectoryTextDecorator = new ControlDecoration((Control)this.rootDirectoryText, 16512);
        Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.rootDirectoryTextDecorator.setImage(errorImage);
        this.rootDirectoryTextDecorator.setDescriptionText(Messages.EasymportWizardPage_incorrectRootDirectory);
        this.rootDirectoryTextDecorator.hide();
        Button browseButton = new Button(res, 8);
        browseButton.setText(Messages.EasymportWizardPage_browse);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(SelectImportRootWizardPage.this.getShell());
                dialog.setText(Messages.selectFolderToImport);
                if (SelectImportRootWizardPage.this.rootDirectoryText.getText() != null && new File(SelectImportRootWizardPage.this.rootDirectoryText.getText()).isDirectory()) {
                    dialog.setFilterPath(SelectImportRootWizardPage.this.rootDirectoryText.getText());
                } else {
                    dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toString());
                }
                String res = dialog.open();
                if (res != null) {
                    SelectImportRootWizardPage.this.rootDirectoryText.setText(res);
                    SelectImportRootWizardPage.this.selection = new File(res);
                    SelectImportRootWizardPage.this.validatePage();
                }
            }
        });
        final Button importRawProjectRadio = new Button(res, 16);
        importRawProjectRadio.setText(Messages.EasymportWizardPage_importRawProject);
        importRawProjectRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        importRawProjectRadio.setSelection(!this.detectNestedProjects);
        importRawProjectRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = importRawProjectRadio.getSelection();
                if (selection) {
                    SelectImportRootWizardPage.this.detectNestedProjects = false;
                    SelectImportRootWizardPage.this.configureProjects = false;
                }
                SelectImportRootWizardPage.this.setPageComplete(SelectImportRootWizardPage.this.isPageComplete());
            }
        });
        final Button importAndConfigureProjectRadio = new Button(res, 16);
        importAndConfigureProjectRadio.setText(Messages.EasymportWizardPage_importAndConfigureProject);
        importAndConfigureProjectRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        importAndConfigureProjectRadio.setSelection(!this.detectNestedProjects);
        importAndConfigureProjectRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = importAndConfigureProjectRadio.getSelection();
                if (selection) {
                    SelectImportRootWizardPage.this.detectNestedProjects = false;
                    SelectImportRootWizardPage.this.configureProjects = true;
                }
                SelectImportRootWizardPage.this.setPageComplete(SelectImportRootWizardPage.this.isPageComplete());
            }
        });
        final Button detectNestedProjectCheckbox = new Button(res, 16);
        detectNestedProjectCheckbox.setText(Messages.EasymportWizardPage_detectNestedProjects);
        detectNestedProjectCheckbox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        detectNestedProjectCheckbox.setSelection(this.detectNestedProjects);
        detectNestedProjectCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = detectNestedProjectCheckbox.getSelection();
                if (selection) {
                    SelectImportRootWizardPage.this.detectNestedProjects = true;
                    SelectImportRootWizardPage.this.configureProjects = true;
                }
                SelectImportRootWizardPage.this.setPageComplete(SelectImportRootWizardPage.this.isPageComplete());
            }
        });
        Link showDetectorsLink = new Link(res, 0);
        showDetectorsLink.setText("<A>" + Messages.EasymportWizardPage_showAvailableDetectors + "</A>");
        showDetectorsLink.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        showDetectorsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringBuilder message = new StringBuilder();
                message.append(Messages.EasymportWizardPage_availableDetectors_description);
                message.append('\n');
                message.append('\n');
                ArrayList<String> extensionsLabels = new ArrayList<String>(ProjectConfiguratorExtensionManager.getAllExtensionLabels());
                Collections.sort(extensionsLabels);
                for (String extensionLabel : extensionsLabels) {
                    message.append("* ");
                    message.append(extensionLabel);
                    message.append('\n');
                }
                MessageDialog.openInformation((Shell)SelectImportRootWizardPage.this.getShell(), (String)Messages.EasymportWizardPage_availableDetectors_title, (String)message.toString());
            }
        });
        Group workingSetsGroup = new Group(res, 0);
        workingSetsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        workingSetsGroup.setLayout((Layout)new GridLayout(1, false));
        workingSetsGroup.setText(Messages.EasymportWizardPage_workingSets);
        this.workingSetsBlock = new WorkingSetConfigurationBlock(new String[]{"org.eclipse.ui.resourceWorkingSetPage"}, this.getDialogSettings());
        if (this.workingSets != null) {
            this.workingSetsBlock.setWorkingSets(this.workingSets.toArray(new IWorkingSet[this.workingSets.size()]));
        }
        this.workingSetsBlock.createContent((Composite)workingSetsGroup);
        if (this.selection == null && (dialogSetting = this.getDialogSettings().get(ROOT_DIRECTORY)) != null) {
            this.selection = new File(dialogSetting);
        }
        if (this.selection != null) {
            this.rootDirectoryText.setText(this.selection.getAbsolutePath());
            this.validatePage();
        }
        this.setControl((Control)res);
    }

    protected void validatePage() {
        if (this.selection == null || !this.selection.isDirectory()) {
            this.rootDirectoryTextDecorator.show();
            this.setErrorMessage(this.rootDirectoryTextDecorator.getDescriptionText());
        } else {
            this.rootDirectoryTextDecorator.hide();
            this.setErrorMessage(null);
        }
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        return this.selection != null && this.selection.isDirectory();
    }

    public File getSelectedRootDirectory() {
        return this.selection;
    }

    public void setInitialSelectedDirectory(File directory) {
        this.selection = directory;
        this.rootDirectoryText.setText(directory.getAbsolutePath());
    }

    public Set<IWorkingSet> getSelectedWorkingSets() {
        this.workingSets.clear();
        Runnable workingSetsRetriever = new Runnable(){

            @Override
            public void run() {
                IWorkingSet[] iWorkingSetArray = SelectImportRootWizardPage.this.workingSetsBlock.getSelectedWorkingSets();
                int n = iWorkingSetArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkingSet workingSet = iWorkingSetArray[n2];
                    SelectImportRootWizardPage.this.workingSets.add(workingSet);
                    ++n2;
                }
            }
        };
        if (Display.getCurrent() == null) {
            this.getContainer().getShell().getDisplay().syncExec(workingSetsRetriever);
        } else {
            workingSetsRetriever.run();
        }
        return this.workingSets;
    }

    public boolean isDetectNestedProject() {
        return this.detectNestedProjects;
    }

    public boolean isConfigureProjects() {
        return this.configureProjects;
    }

    @Deprecated
    public boolean isConfigureAndDetectNestedProject() {
        return this.isConfigureProjects();
    }
}

