/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.wizards.datatransfer.EasymportWizard;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class OpenFolderDropAdapterAssistant
extends CommonDropAdapterAssistant {
    public boolean isSupportedType(TransferData aTransferType) {
        return FileTransfer.getInstance().isSupportedType(aTransferType);
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        IAdaptable targetAdaptable;
        if (target instanceof IWorkingSet || target instanceof IWorkspaceRoot) {
            return Status.OK_STATUS;
        }
        if (target instanceof IAdaptable && ((targetAdaptable = (IAdaptable)target).getAdapter(IWorkspaceRoot.class) != null || targetAdaptable.getAdapter(IWorkingSet.class) != null)) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        String[] files = (String[])aDropTargetEvent.data;
        if (files.length != 1) {
            return Status.CANCEL_STATUS;
        }
        File directory = new File(files[0]);
        if (!directory.isDirectory()) {
            return Status.CANCEL_STATUS;
        }
        IWorkingSet targetWorkingSet = null;
        if (aTarget != null) {
            if (aTarget instanceof IWorkingSet) {
                targetWorkingSet = (IWorkingSet)aTarget;
            } else if (aTarget instanceof IAdaptable) {
                targetWorkingSet = (IWorkingSet)((IAdaptable)aTarget).getAdapter(IWorkingSet.class);
            }
        }
        HashSet<IWorkingSet> workingSets = new HashSet<IWorkingSet>();
        workingSets.add(targetWorkingSet);
        EasymportWizard wizard = new EasymportWizard();
        wizard.setInitialDirectory(directory);
        HashSet<IWorkingSet> initialWorkingSets = new HashSet<IWorkingSet>();
        if (targetWorkingSet != null) {
            initialWorkingSets.add(targetWorkingSet);
        } else {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Path asPath = new Path(directory.getAbsolutePath());
            IProject parentProject = null;
            IProject[] iProjectArray = workspaceRoot.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.getLocation().isPrefixOf((IPath)asPath) && (parentProject == null || parentProject.getLocation().isPrefixOf(project.getLocation()))) {
                    parentProject = project;
                }
                ++n2;
            }
            if (parentProject != null) {
                iProjectArray = workbench.getWorkingSetManager().getAllWorkingSets();
                n = iProjectArray.length;
                n2 = 0;
                while (n2 < n) {
                    IProject workingSet = iProjectArray[n2];
                    IAdaptable[] iAdaptableArray = workingSet.getElements();
                    int n3 = iAdaptableArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAdaptable element = iAdaptableArray[n4];
                        if (element.equals(parentProject)) {
                            initialWorkingSets.add((IWorkingSet)workingSet);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        wizard.setInitialWorkingSets(initialWorkingSets);
        WizardDialog wizardDialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        wizardDialog.setBlockOnOpen(false);
        wizardDialog.open();
        return Status.OK_STATUS;
    }
}

