/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.wizards.datatransfer.Activator;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.EasymportJob;
import org.eclipse.ui.internal.wizards.datatransfer.EasymportWizard;
import org.eclipse.ui.internal.wizards.datatransfer.Messages;
import org.eclipse.ui.internal.wizards.datatransfer.ProjectConfiguratorExtensionManager;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class ImportProposalsWizardPage
extends WizardPage
implements IPageChangedListener {
    private CheckboxTreeViewer tree;
    private Set<File> alreadyExistingProjects;
    private Set<File> notAlreadyExistingProjects;
    private Button recurseInSelectedProjectsCheckbox;
    private EasymportJob currentJob;
    private Label selectionSummary;
    protected Map<File, List<ProjectConfigurator>> potentialProjects;

    public ImportProposalsWizardPage(EasymportWizard wizard) {
        super(ImportProposalsWizardPage.class.getName());
        this.setWizard((IWizard)wizard);
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.preliminaryDetection_Title);
        this.setDescription(Messages.preliminaryDetection_Description);
        if (this.getContainer() instanceof IPageChangeProvider) {
            ((IPageChangeProvider)this.getContainer()).addPageChangedListener((IPageChangedListener)this);
        }
        Composite res = new Composite(parent, 0);
        res.setLayout((Layout)new GridLayout(2, false));
        this.selectionSummary = new Label(res, 0);
        this.selectionSummary.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.tree = new CheckboxTreeViewer(res, 2048);
        this.tree.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                Map potentialProjects = (Map)inputElement;
                return potentialProjects.keySet().toArray(new File[potentialProjects.size()]);
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        });
        this.tree.setComparator(new ViewerComparator(){

            public int compare(Viewer v, Object o1, Object o2) {
                return ((File)o1).getAbsolutePath().compareTo(((File)o2).getAbsolutePath());
            }
        });
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (ImportProposalsWizardPage.this.alreadyExistingProjects.contains(event.getElement())) {
                    ImportProposalsWizardPage.this.tree.setChecked(event.getElement(), false);
                } else {
                    ImportProposalsWizardPage.this.selectionChanged();
                }
            }
        });
        this.tree.getTree().setHeaderVisible(true);
        TreeViewerColumn pathColumn = new TreeViewerColumn((TreeViewer)this.tree, 0);
        pathColumn.setLabelProvider((CellLabelProvider)new FolderForProjectsLabelProvider());
        this.tree.getTree().getColumn(0).setText(Messages.folder);
        this.tree.getTree().getColumn(0).setWidth(400);
        TreeViewerColumn projectTypeColumn = new TreeViewerColumn((TreeViewer)this.tree, 0);
        projectTypeColumn.setLabelProvider((CellLabelProvider)new ProjectConfiguratorLabelProvider());
        this.tree.getTree().getColumn(1).setText(Messages.importAs);
        this.tree.getTree().getColumn(1).setWidth(250);
        Composite selectionButtonsGroup = new Composite(res, 0);
        selectionButtonsGroup.setLayout((Layout)new GridLayout(1, false));
        selectionButtonsGroup.setLayoutData((Object)new GridData(4, 128, false, false));
        Button selectAllButton = new Button(selectionButtonsGroup, 8);
        selectAllButton.setLayoutData((Object)new GridData(4, -1, false, false));
        selectAllButton.setText(DataTransferMessages.DataTransfer_selectAll);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProposalsWizardPage.this.tree.setCheckedElements(ImportProposalsWizardPage.this.notAlreadyExistingProjects.toArray());
                ImportProposalsWizardPage.this.selectionChanged();
            }
        });
        Button deselectAllButton = new Button(selectionButtonsGroup, 8);
        deselectAllButton.setLayoutData((Object)new GridData(4, -1, false, false));
        deselectAllButton.setText(DataTransferMessages.DataTransfer_deselectAll);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProposalsWizardPage.this.tree.setCheckedElements(new Object[0]);
                ImportProposalsWizardPage.this.selectionChanged();
            }
        });
        this.recurseInSelectedProjectsCheckbox = new Button(res, 32);
        this.recurseInSelectedProjectsCheckbox.setText("Use additional analysis after import to detect nested project under selected projects\n(BEWARE: this may create new projects in your workspace without ability to review it first!)");
        this.recurseInSelectedProjectsCheckbox.setLayoutData((Object)new GridData(4, -1, false, false, 2, 1));
        this.recurseInSelectedProjectsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProposalsWizardPage.this.getWizard().getImportJob().setDetectNestedProjects(ImportProposalsWizardPage.this.recurseInSelectedProjectsCheckbox.getSelection());
            }
        });
        this.setPageComplete(true);
        this.setControl((Control)res);
    }

    public boolean isPageComplete() {
        return this.getWizard().getImportJob() != null && this.getWizard().getImportJob().getDirectoriesToImport() != null && !this.getWizard().getImportJob().getDirectoriesToImport().isEmpty();
    }

    public void setWizard(IWizard easymportWizard) {
        Assert.isTrue((boolean)(easymportWizard instanceof EasymportWizard));
        super.setWizard(easymportWizard);
    }

    public EasymportWizard getWizard() {
        return (EasymportWizard)super.getWizard();
    }

    private void updateTreeContent() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ImportProposalsWizardPage.this.potentialProjects = ImportProposalsWizardPage.this.getWizard().getImportJob().getImportProposals(monitor);
                    if (ImportProposalsWizardPage.this.potentialProjects.size() == 0) {
                        MessageDialog.openInformation((Shell)ImportProposalsWizardPage.this.getShell(), (String)Messages.didntFindImportProposals_title, (String)NLS.bind((String)Messages.didntFindImportProposals_message, (Object)ImportProposalsWizardPage.this.recurseInSelectedProjectsCheckbox.getText()));
                    } else {
                        ImportProposalsWizardPage.this.getWizard().getImportJob().setDetectNestedProjects(false);
                    }
                    ImportProposalsWizardPage.this.recurseInSelectedProjectsCheckbox.setSelection(ImportProposalsWizardPage.this.getWizard().getImportJob().isDetectNestedProjects());
                    if (!ImportProposalsWizardPage.this.potentialProjects.containsKey(ImportProposalsWizardPage.this.getWizard().getImportJob().getRoot())) {
                        ImportProposalsWizardPage.this.potentialProjects.put(ImportProposalsWizardPage.this.getWizard().getImportJob().getRoot(), Collections.EMPTY_LIST);
                        ImportProposalsWizardPage.this.getWizard().getImportJob().setDetectNestedProjects(true);
                    }
                    ImportProposalsWizardPage.this.notAlreadyExistingProjects = new HashSet<File>(ImportProposalsWizardPage.this.potentialProjects.keySet());
                    ImportProposalsWizardPage.this.alreadyExistingProjects = new HashSet();
                    IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int n = iProjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        ImportProposalsWizardPage.this.notAlreadyExistingProjects.remove(project.getLocation().toFile());
                        ImportProposalsWizardPage.this.alreadyExistingProjects.add(project.getLocation().toFile());
                        ++n2;
                    }
                    ImportProposalsWizardPage.this.tree.setInput(ImportProposalsWizardPage.this.potentialProjects);
                    ImportProposalsWizardPage.this.tree.setCheckedElements(ImportProposalsWizardPage.this.notAlreadyExistingProjects.toArray());
                }
            });
            this.selectionChanged();
        }
        catch (InterruptedException interruptedException) {
            this.tree.setInput((Object)Collections.EMPTY_MAP);
            this.getWizard().getImportJob().resetProposals();
        }
        catch (InvocationTargetException ex) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Sorry...", (String)"An internal error occured. Please see log file for details.");
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), ex.getMessage(), (Throwable)ex));
        }
    }

    public void pageChanged(PageChangedEvent event) {
        EasymportJob newJob;
        if (event.getSelectedPage() == this && (newJob = this.getWizard().getImportJob()) != this.currentJob) {
            this.currentJob = newJob;
            this.recurseInSelectedProjectsCheckbox.setSelection(this.getWizard().getImportJob().isDetectNestedProjects());
            this.updateTreeContent();
        }
    }

    public void dispose() {
        if (this.getContainer() instanceof IPageChangeProvider) {
            ((IPageChangeProvider)this.getContainer()).removePageChangedListener((IPageChangedListener)this);
        }
        super.dispose();
    }

    private void selectionChanged() {
        Object[] selected = this.tree.getCheckedElements();
        EasymportJob importJob = this.getWizard().getImportJob();
        HashSet<File> excludedDirectories = new HashSet<File>(((Map)this.tree.getInput()).keySet());
        HashSet<File> selectedProjects = new HashSet<File>();
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            File directory = (File)item;
            excludedDirectories.remove(directory);
            selectedProjects.add(directory);
            ++n2;
        }
        importJob.setDirectoriesToImport(selectedProjects);
        importJob.setExcludedDirectories(excludedDirectories);
        this.selectionSummary.setText(NLS.bind((String)Messages.selectionSummary, (Object)importJob.getImportProposals(null).size(), (Object)importJob.getDirectoriesToImport().size()));
        this.setPageComplete(this.isPageComplete());
    }

    private class FolderForProjectsLabelProvider
    extends CellLabelProvider
    implements IColorProvider {
        private FolderForProjectsLabelProvider() {
        }

        public String getText(Object o) {
            File file = (File)o;
            String label = file.getAbsolutePath();
            if (label.startsWith(ImportProposalsWizardPage.this.currentJob.getRoot().getAbsolutePath())) {
                label = label.substring(ImportProposalsWizardPage.this.currentJob.getRoot().getParentFile().getAbsolutePath().length() + 1);
            }
            return label;
        }

        public Color getBackground(Object o) {
            return null;
        }

        public Color getForeground(Object o) {
            if (ImportProposalsWizardPage.this.alreadyExistingProjects.contains(o)) {
                return Display.getDefault().getSystemColor(15);
            }
            return null;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            Color color = this.getForeground(cell.getElement());
            if (color != null) {
                cell.setForeground(color);
            }
        }
    }

    private class ProjectConfiguratorLabelProvider
    extends CellLabelProvider
    implements IColorProvider {
        private ProjectConfiguratorLabelProvider() {
        }

        public String getText(Object o) {
            File file = (File)o;
            if (ImportProposalsWizardPage.this.alreadyExistingProjects.contains(file)) {
                return Messages.alreadyImportedAsProject_title;
            }
            List<ProjectConfigurator> configurators = ImportProposalsWizardPage.this.potentialProjects.get(file);
            if (configurators.isEmpty()) {
                return "";
            }
            return ProjectConfiguratorExtensionManager.getLabel(configurators.get(0));
        }

        public Color getBackground(Object o) {
            return null;
        }

        public Color getForeground(Object o) {
            if (ImportProposalsWizardPage.this.alreadyExistingProjects.contains(o)) {
                return Display.getDefault().getSystemColor(15);
            }
            return null;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            Color color = this.getForeground(cell.getElement());
            if (color != null) {
                cell.setForeground(color);
            }
        }
    }
}

