/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.Activator;
import org.eclipse.ui.internal.wizards.datatransfer.EasymportJob;
import org.eclipse.ui.internal.wizards.datatransfer.EasymportJobReportDialog;
import org.eclipse.ui.internal.wizards.datatransfer.ImportProposalsWizardPage;
import org.eclipse.ui.internal.wizards.datatransfer.SelectImportRootWizardPage;

public class EasymportWizard
extends Wizard
implements IImportWizard {
    private File initialSelection;
    private Set<IWorkingSet> initialWorkingSets = new HashSet<IWorkingSet>();
    private SelectImportRootWizardPage projectRootPage;
    private EasymportJob easymportJob;

    public EasymportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings == null) {
            dialogSettings = Activator.getDefault().getDialogSettings();
            this.setDialogSettings(dialogSettings);
        }
        this.setDefaultPageImageDescriptor(IDEWorkbenchPlugin.getIDEImageDescriptor((String)"wizban/newprj_wiz.png"));
    }

    public void setInitialDirectory(File directory) {
        this.initialSelection = directory;
    }

    public void setInitialWorkingSets(Set<IWorkingSet> workingSets) {
        this.initialWorkingSets = workingSets;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection != null) {
            for (Object item : selection.toList()) {
                File asFile = EasymportWizard.toFile(item);
                if (asFile != null && this.initialSelection == null) {
                    this.initialSelection = asFile;
                    continue;
                }
                IWorkingSet asWorkingSet = this.toWorkingSet(item);
                if (asWorkingSet == null) continue;
                this.initialWorkingSets.add(asWorkingSet);
            }
        }
    }

    public static File toFile(Object o) {
        IResource resource;
        if (o instanceof File) {
            return (File)o;
        }
        if (o instanceof IResource) {
            return ((IResource)o).getLocation().toFile();
        }
        if (o instanceof IAdaptable && (resource = (IResource)((IAdaptable)o).getAdapter(IResource.class)) != null) {
            return resource.getLocation().toFile();
        }
        return null;
    }

    private IWorkingSet toWorkingSet(Object o) {
        if (o instanceof IWorkingSet) {
            return (IWorkingSet)o;
        }
        if (o instanceof IAdaptable) {
            return (IWorkingSet)((IAdaptable)o).getAdapter(IWorkingSet.class);
        }
        return null;
    }

    public void addPages() {
        this.projectRootPage = new SelectImportRootWizardPage((IWizard)this, this.initialSelection, this.initialWorkingSets);
        this.addPage((IWizardPage)this.projectRootPage);
        this.addPage((IWizardPage)new ImportProposalsWizardPage(this));
    }

    public boolean performFinish() {
        this.getDialogSettings().put("rootDirectory", this.projectRootPage.getSelectedRootDirectory().getAbsolutePath());
        EasymportJob job = this.getImportJob();
        EasymportJobReportDialog dialog = new EasymportJobReportDialog(this.getShell(), job);
        job.schedule();
        if (this.projectRootPage.isDetectNestedProject() || this.projectRootPage.isConfigureProjects()) {
            dialog.open();
        }
        return true;
    }

    public EasymportJob getImportJob() {
        if (this.projectRootPage.getSelectedRootDirectory() == null) {
            this.easymportJob = null;
        } else if (this.easymportJob == null || !this.easymportJob.getRoot().equals(this.projectRootPage.getSelectedRootDirectory())) {
            this.easymportJob = new EasymportJob(this.projectRootPage.getSelectedRootDirectory(), this.projectRootPage.getSelectedWorkingSets(), this.projectRootPage.isConfigureProjects(), this.projectRootPage.isDetectNestedProject());
        }
        return this.easymportJob;
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.projectRootPage) {
            return this.projectRootPage.isPageComplete() && !this.projectRootPage.isDetectNestedProject();
        }
        return super.canFinish();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.projectRootPage && !this.projectRootPage.isDetectNestedProject()) {
            return null;
        }
        return super.getNextPage(page);
    }
}

