/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ltk.core.refactoring.Change;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.refactoring.SeamProjectChange;
import org.osgi.service.prefs.BackingStoreException;

public class SeamFolderRenameChange
extends SeamProjectChange {
    private IPath oldPath;
    private IPath newPath;
    private List<String> relevantProperties = new ArrayList<String>();

    public SeamFolderRenameChange(IProject project, String newName, IPath oldPath) {
        super(project);
        this.oldPath = oldPath;
        this.newPath = oldPath.removeLastSegments(1).append(newName);
        IEclipsePreferences ps = this.getSeamPreferences();
        int i = 0;
        while (i < FOLDER_PROPERTIES.length) {
            String oldPathString;
            String propertyValue = ps.get(FOLDER_PROPERTIES[i], null);
            if (propertyValue != null && (propertyValue.equals(oldPathString = oldPath.toString()) || propertyValue.startsWith(String.valueOf(oldPathString) + "/"))) {
                this.relevantProperties.add(FOLDER_PROPERTIES[i]);
            }
            ++i;
        }
        this.findPreferences(ps);
    }

    private void findPreferences(IEclipsePreferences ps) {
        for (String propertyName : this.relevantProperties) {
            String oldPathString;
            String propertyValue = ps.get(propertyName, "");
            if (propertyValue.equals(oldPathString = this.oldPath.toString())) {
                this.preferences.put(propertyName, this.newPath.toString());
                continue;
            }
            if (!propertyValue.startsWith(String.valueOf(oldPathString) + "/")) continue;
            String newPathString = String.valueOf(this.newPath.toString()) + propertyValue.substring(oldPathString.length());
            this.preferences.put(propertyName, newPathString);
        }
    }

    @Override
    public boolean isRelevant() {
        return !this.relevantProperties.isEmpty();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (!this.isRelevant()) {
            return null;
        }
        try {
            pm.beginTask(this.getName(), 1);
            IEclipsePreferences ps = this.getSeamPreferences();
            for (String key : this.preferences.keySet()) {
                ps.put(key, (String)this.preferences.get(key));
            }
            try {
                ps.flush();
            }
            catch (BackingStoreException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
            SeamFolderRenameChange seamFolderRenameChange = new SeamFolderRenameChange(this.project, this.oldPath.lastSegment(), this.newPath);
            return seamFolderRenameChange;
        }
        finally {
            pm.done();
        }
    }
}

