/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.jst.web.context.ImportWebDirProjectContext;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.w3c.dom.Element;

public class ImportWebProjectWizardPage
extends WizardPage {
    private ImportWebDirProjectContext context;
    private XAttributeSupport support;
    private IModelPropertyEditorAdapter projectNameAdapter;
    private IModelPropertyEditorAdapter webXmlLocationAdapter;
    private IModelPropertyEditorAdapter linkAdapter;
    private PropertyChangeListener updateDataListener;
    private IPropertyEditor projectNameEditor;
    private IPropertyEditor linkEditor;
    private static String REDHAT_NAME = "RedHat";

    public ImportWebProjectWizardPage(ImportWebDirProjectContext context) {
        super("Wizard Page");
        this.context = context;
        XEntityDataImpl entityData = context.isInitialized() ? XEntityDataImpl.create((String[][])new String[][]{{"WebPrjAdoptStepName", ""}, {"name", "yes"}, {"web.xml location", "yes"}}) : XEntityDataImpl.create((String[][])new String[][]{{"WebPrjAdoptStepName", ""}, {"name", "yes"}, {"web.xml location", "yes"}, {"link", "no"}});
        this.support = new XAttributeSupport(ModelUtilities.getPreferenceModel().getRoot(), (XEntityData)entityData);
        this.support.setLayout(this.getLayoutForSupport());
        this.projectNameAdapter = this.support.getPropertyEditorAdapterByName("name");
        this.projectNameAdapter.setValue((Object)"");
        this.webXmlLocationAdapter = this.support.getPropertyEditorAdapterByName("web.xml location");
        this.webXmlLocationAdapter.setValue((Object)"");
        if (context.isInitialized()) {
            this.projectNameAdapter.setValue((Object)context.getProjectName());
            if (this.getWebXmlFile(context.getInitialLocation()) != null) {
                this.webXmlLocationAdapter.setValue((Object)context.getInitialLocation());
            }
        } else {
            this.linkAdapter = this.support.getPropertyEditorAdapterByName("link");
            this.linkAdapter.setValue((Object)"false");
        }
    }

    public void dispose() {
        super.dispose();
        if (this.support != null) {
            this.support.dispose();
        }
        this.support = null;
        if (this.projectNameAdapter != null) {
            this.projectNameAdapter.dispose();
        }
        this.projectNameAdapter = null;
        if (this.webXmlLocationAdapter != null) {
            this.webXmlLocationAdapter.dispose();
        }
        this.webXmlLocationAdapter = null;
        if (this.projectNameEditor != null) {
            this.projectNameEditor.dispose();
        }
        if (this.linkAdapter != null) {
            this.linkAdapter.dispose();
        }
        this.linkAdapter = null;
        this.projectNameEditor = null;
        this.updateDataListener = null;
    }

    public void createControl(Composite parent) {
        this.createControlImpl(parent);
    }

    private void createControlImpl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite control = this.support.createControl(parent);
        this.setControl((Control)control);
        this.projectNameEditor = this.support.getPropertyEditorByName("name");
        this.projectNameEditor.getFieldEditor((Composite)this.getControl()).setEnabled(false, (Composite)this.getControl());
        if (this.linkAdapter != null) {
            this.linkEditor = this.support.getPropertyEditorByName("link");
        }
        this.initListeners();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(this.validatePage());
    }

    public void setVisible(boolean visible) {
        this.context.rollbackSupportDelta();
        super.setVisible(visible);
    }

    public void setDialogSize(int width, int height) {
        Shell shell = this.getShell();
        shell.pack();
        this.setShellSize(width, height);
        Rectangle displayArea = shell.getDisplay().getClientArea();
        int x = (displayArea.width - this.getShell().getSize().x) / 2;
        int y = (displayArea.height - this.getShell().getSize().y) / 2;
        shell.setLocation(x, y);
    }

    private void setShellSize(int width, int height) {
        Shell shell = this.getShell();
        if (width == -1) {
            width = shell.getSize().x;
        }
        if (height == -1) {
            height = shell.getSize().y;
        }
        shell.setSize(width, height);
    }

    private Layout getLayoutForSupport() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 4;
        gridLayout.marginWidth = 4;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        return gridLayout;
    }

    private void initListeners() {
        this.updateDataListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ImportWebProjectWizardPage.this.updateContext(true, false);
                ImportWebProjectWizardPage.this.setPageComplete(ImportWebProjectWizardPage.this.validatePage());
                ImportWebProjectWizardPage.this.getContainer().updateButtons();
                if (ImportWebProjectWizardPage.this.linkAdapter != null) {
                    boolean requiresLink = !ImportWebProjectWizardPage.this.isProjectFolderPresentInWorkspace() && ImportWebProjectWizardPage.this.isLocationInsideWorkspace();
                    ImportWebProjectWizardPage.this.support.getFieldEditorByName("link").setEnabled(ImportWebProjectWizardPage.this.mayNeedLink() && !requiresLink, (Composite)ImportWebProjectWizardPage.this.getControl());
                    if (!ImportWebProjectWizardPage.this.mayNeedLink() && ImportWebProjectWizardPage.this.linkAdapter != null) {
                        ImportWebProjectWizardPage.this.linkAdapter.setValue((Object)"false");
                    } else if (requiresLink) {
                        ImportWebProjectWizardPage.this.linkAdapter.setValue((Object)"true");
                    }
                }
            }
        };
        this.projectNameAdapter.addValueChangeListener(this.updateDataListener);
        this.webXmlLocationAdapter.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean requiresLink;
                ImportWebProjectWizardPage.this.updateContext(false, true);
                ImportWebProjectWizardPage.this.setPageComplete(ImportWebProjectWizardPage.this.validatePage());
                ImportWebProjectWizardPage.this.getContainer().updateButtons();
                boolean bl = requiresLink = !ImportWebProjectWizardPage.this.isProjectFolderPresentInWorkspace() && ImportWebProjectWizardPage.this.isLocationInsideWorkspace();
                if (ImportWebProjectWizardPage.this.linkAdapter != null) {
                    ImportWebProjectWizardPage.this.support.getFieldEditorByName("link").setEnabled(ImportWebProjectWizardPage.this.mayNeedLink() && !requiresLink, (Composite)ImportWebProjectWizardPage.this.getControl());
                    if (!ImportWebProjectWizardPage.this.mayNeedLink()) {
                        ImportWebProjectWizardPage.this.linkAdapter.setValue((Object)"false");
                    } else if (requiresLink) {
                        ImportWebProjectWizardPage.this.linkAdapter.setValue((Object)"true");
                    }
                }
            }
        });
        if (this.linkAdapter != null) {
            this.linkAdapter.addValueChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String v = ImportWebProjectWizardPage.this.linkAdapter.getStringValue(false);
                    ImportWebProjectWizardPage.this.context.setLinkingToProjectOutsideWorkspace(!"false".equals(v) && ImportWebProjectWizardPage.this.mayNeedLink());
                }
            });
        }
    }

    private String getProjectNameValue() {
        return this.projectNameAdapter.getStringValue(true).trim();
    }

    private String getWebXmlLocationValue() {
        return this.webXmlLocationAdapter.getStringValue(true).trim();
    }

    private void setProjectNameValue(String value) {
        this.projectNameAdapter.removeValueChangeListener(this.updateDataListener);
        this.projectNameAdapter.setValue((Object)value);
        this.projectNameAdapter.addValueChangeListener(this.updateDataListener);
    }

    private boolean mayNeedLink() {
        String location = this.getWebXmlLocationValue();
        if (location == null || location.trim().length() == 0) {
            return false;
        }
        return !this.isProjectFolderPresentInWorkspace() || !this.isLocationInsideWorkspace();
    }

    private boolean isProjectFolderPresentInWorkspace() {
        File workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        return new File(workspaceFile, this.getProjectNameValue()).exists();
    }

    private boolean isLocationInsideWorkspace() {
        String location = this.getWebXmlLocationValue();
        if (location == null || location.trim().length() == 0) {
            return false;
        }
        String workspace = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString().replace('\\', '/')) + '/';
        location = location.replace('\\', '/');
        File webxmlFile = new File(location);
        File workspaceFile = new File(workspace);
        if (webxmlFile.exists() && workspaceFile.exists()) {
            try {
                return webxmlFile.getCanonicalPath().startsWith(workspaceFile.getCanonicalPath());
            }
            catch (IOException e) {
                WebUiPlugin.getDefault().logError(e);
            }
        }
        return location.startsWith(workspace);
    }

    private void updateProjectNameValue(boolean onProjectNameEdit, boolean onProjectLocationEdit) {
        String sgName;
        if (this.context.isInitialized()) {
            return;
        }
        File projectFile = null;
        this.projectNameEditor.getFieldEditor((Composite)this.getControl()).setEnabled(projectFile == null, (Composite)this.getControl());
        if (onProjectNameEdit) {
            String an = this.context.getApplicationName();
            String pn = this.context.getProjectName();
            String npn = this.getProjectNameValue();
            if (an == null || an.equals(pn)) {
                this.context.setApplicationName(npn);
            }
        }
        if (!onProjectLocationEdit) {
            return;
        }
        IProject project = this.findExistingProject();
        Path webXmlPath = new Path(this.getWebXmlLocationValue());
        String appName = sgName = this.getSuggestedProjectName((IPath)webXmlPath);
        if (sgName != null && this.context.getInitialLocation() == null && project != null && !project.getName().equals(sgName)) {
            project = null;
        }
        if (project != null) {
            appName = project.getName();
            this.setProjectNameValue(appName);
            this.projectNameEditor.getFieldEditor((Composite)this.getControl()).setEnabled(false, (Composite)this.getControl());
            this.context.setApplicationName(appName);
        } else {
            this.setProjectNameValue(appName);
            this.context.setApplicationName(appName);
        }
        if (projectFile != null) {
            Element element = XMLUtil.getElement(projectFile);
            if (element.hasAttribute("APPLICATION_NAME")) {
                appName = element.getAttribute("APPLICATION_NAME");
            } else if (element.hasAttribute("application-name")) {
                appName = element.getAttribute("application-name");
            }
            this.context.setApplicationName(appName);
        }
    }

    private String getSuggestedProjectName(IPath webXmlPath) {
        IPath p = webXmlPath.removeLastSegments(3);
        IPath q = ModelPlugin.getWorkspace().getRoot().getLocation();
        if (!q.equals((Object)p) && !p.isPrefixOf(q)) {
            return webXmlPath.segment(webXmlPath.segmentCount() - 4);
        }
        return null;
    }

    private IProject findExistingProject() {
        Path webXmlPath = new Path(this.getWebXmlLocationValue());
        IProject[] ps = ModelUIPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < ps.length) {
            IPath location = ps[i].getLocation();
            if (location != null && location.isPrefixOf((IPath)webXmlPath)) {
                return ps[i];
            }
            ++i;
        }
        return null;
    }

    private File getWebXmlFile() {
        return this.getWebXmlFile(this.getWebXmlLocationValue());
    }

    private File getWebXmlFile(String path) {
        File tmp = path == null ? null : new File(path);
        return tmp != null && tmp.exists() && tmp.isFile() && "web.xml".equals(tmp.getName()) ? tmp : null;
    }

    private boolean validatePage() {
        IProjectFacet f;
        IProject p1;
        this.setErrorMessage(null);
        this.setMessage(null);
        String webXmlLocation = this.getWebXmlLocationValue();
        if ("".equals(webXmlLocation)) {
            return false;
        }
        if (!new Path("").isValidPath(webXmlLocation)) {
            this.setErrorMessage(WizardKeys.getString((String)"WebPrjAdoptStepName_locationError"));
            return false;
        }
        if (this.getWebXmlFile() == null) {
            String message = this.context.getWebXMLErrorMessage();
            if (message == null) {
                message = WizardKeys.getString((String)"WebPrjAdoptStepName_notAProject");
            }
            this.setErrorMessage(message);
            return false;
        }
        if (this.context.getInitialLocationErrorMessage() != null) {
            this.setErrorMessage(this.context.getInitialLocationErrorMessage());
            return false;
        }
        if (this.context.getWebXMLErrorMessage() != null) {
            this.setErrorMessage(this.context.getWebXMLErrorMessage());
            return false;
        }
        String projectName = this.getProjectNameValue();
        if ("".equals(projectName)) {
            return false;
        }
        IWorkspace workspace = ModelUIPlugin.getWorkspace();
        IStatus nameStatus = workspace.validateName(projectName, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project != null && project.exists() && !project.isOpen()) {
            this.setErrorMessage(NLS.bind((String)WebUIMessages.PROJECT_EXISTS_IN_WORKSPACE, (Object)this.getProjectNameValue()));
            return false;
        }
        if (!(project != null && project.exists() || (p1 = EclipseResourceUtil.findProjectIgnoreCase((String)projectName)) == null)) {
            String message = NLS.bind((String)WebUIMessages.PROJECT_ALREADY_EXISTS_IN_THE_WORKSPACE, (Object)p1.getName());
            this.setErrorMessage(message);
            return false;
        }
        if (project != null && project.exists() && (f = ProjectFacetsManager.getProjectFacet((String)"jst.web")) != null) {
            IFacetedProject fp = null;
            try {
                fp = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (fp != null) {
                boolean hasJSTWebFacet = false;
                Set vs = fp.getProjectFacets();
                if (vs != null) {
                    for (IProjectFacetVersion v : vs) {
                        String id = v.getProjectFacet().getId();
                        if (!"jst.web".equals(id)) continue;
                        hasJSTWebFacet = true;
                    }
                }
                if (!hasJSTWebFacet) {
                    Set fvs = f.getVersions();
                    boolean ok = false;
                    for (IProjectFacetVersion v : fvs) {
                        IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, v, null);
                        HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
                        actions.add(action);
                        IStatus status = ProjectFacetsManager.check((Set)vs, actions);
                        if (status == null || !status.isOK()) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) {
                        String message = "This project cannot be converted to Web Dynamic project required for JSF capabilities.";
                        this.setErrorMessage(message);
                        return false;
                    }
                }
            }
        }
        if (this.context.isInitialized()) {
            return true;
        }
        boolean hasNature = false;
        boolean hasJavaNature = false;
        try {
            project.refreshLocal(2, null);
            hasJavaNature = project.exists() && project.hasNature("org.eclipse.jdt.core.javanature");
            hasNature = project.exists() && project.hasNature(this.context.getNatureID());
        }
        catch (CoreException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
            hasNature = project.exists();
        }
        if (project.exists() && !hasNature && hasJavaNature) {
            this.setMessage(NLS.bind((String)WebUIMessages.JAVA_PROJECT_EXISTS, (Object)this.getProjectNameValue(), (Object)REDHAT_NAME));
        } else if (project.exists() && !hasNature && !hasJavaNature) {
            this.setMessage(NLS.bind((String)WebUIMessages.PROJECT_EXISTS, (Object)this.getProjectNameValue(), (Object)REDHAT_NAME));
        } else {
            this.setMessage(null);
        }
        if (project.exists() && (hasNature || !hasJavaNature)) {
            this.setErrorMessage(WizardKeys.getString((String)"WebPrjAdoptStepName_existsInWorkspace"));
            return false;
        }
        return true;
    }

    private void updateContext(boolean onProjectNameEdit, boolean onProjectLocationEdit) {
        if (this.getWebXmlFile() != null) {
            this.updateProjectNameValue(onProjectNameEdit, onProjectLocationEdit);
        }
        this.context.setProjectName(this.getProjectNameValue());
        this.context.setWebXmlLocation(this.getWebXmlLocationValue());
    }
}

