/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.newfile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.StringResource;
import org.apache.tools.ant.util.ResourceUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.ui.IValidator;
import org.jboss.tools.common.ui.ValidatorFactory;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.Messages;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.wizards.newfile.DSDataModelProvider;
import org.jboss.tools.jst.web.ui.wizards.newfile.FilterSetFactory;
import org.jboss.tools.jst.web.ui.wizards.newfile.NewDSXMLWizardFactory;

public class NewDSXMLWizard
extends BasicNewResourceWizard {
    public static final String WIZARD_ID = "org.jboss.tools.seam.ui.wizard.SeamDSXMLWizard";
    WizardNewDSXMLFileCreationPage mainPage;
    private boolean fOpenEditorOnFinish = true;

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(Messages.NewDSXMLWizard_TITLE);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewDSXMLFileCreationPage("newFilePage1", this.getSelection());
        this.mainPage.setTitle(Messages.NewDSXMLWizard_SUBTITLE);
        this.mainPage.setDescription(Messages.NewDSXMLWizard_DESCRIPTION);
        this.mainPage.setFileName("ds.xml");
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        IFile file = this.mainPage.createNewFile();
        if (file == null) {
            return false;
        }
        this.selectAndReveal((IResource)file);
        if (this.fOpenEditorOnFinish) {
            IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
            try {
                IWorkbenchPage page;
                if (dw != null && (page = dw.getActivePage()) != null) {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
            }
            catch (PartInitException e) {
                DialogUtil.openError((Shell)dw.getShell(), (String)ResourceMessages.FileResource_errorMessage, (String)e.getMessage(), (PartInitException)e);
            }
        }
        return true;
    }

    static String toDatasourceName(String connectionProfile) {
        connectionProfile = connectionProfile.trim();
        StringBuilder result = new StringBuilder();
        StringBuilder special = new StringBuilder();
        int i = 0;
        while (i < connectionProfile.length()) {
            char c = connectionProfile.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                special.append('_');
            } else {
                if (special.length() > 0) {
                    result.append(special.toString());
                    special.setLength(0);
                }
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    IContainer getInitialContainer() {
        IStructuredSelection s = this.getSelection();
        if (s instanceof IStructuredSelection) {
            Object o = s.getFirstElement();
            IResource r = null;
            if (o instanceof IResource) {
                r = (IResource)o;
            } else if (o instanceof IAdaptable) {
                r = (IResource)((IAdaptable)o).getAdapter(IResource.class);
            }
            if (r instanceof IFile) {
                return r.getParent();
            }
            if (r instanceof IContainer) {
                return (IContainer)r;
            }
        }
        return null;
    }

    private String getOldPersistenceContent(IFile persistenceFile) throws IOException, CoreException {
        int i;
        String content = "";
        if (!persistenceFile.exists()) {
            return content;
        }
        String start = "<persistence-unit";
        String end = "</persistence-unit>";
        String cc = FileUtil.readStream((IFile)persistenceFile);
        int b = cc.indexOf(start);
        int e = cc.lastIndexOf(end);
        if (b > 0 && e > b) {
            while (b > 0 && Character.isWhitespace(cc.charAt(b - 1))) {
                --b;
            }
            content = cc.substring(b, e + end.length());
        }
        if ((i = content.indexOf("\"primary\"")) > 0) {
            int k = 1;
            while (content.indexOf("\"primary_" + k + "\"") > 0) {
                ++k;
            }
            content = String.valueOf(content.substring(0, i + 8)) + "_" + k + content.substring(i + 8);
        }
        return content;
    }

    private Object getConnectionProfileDefaultValue() {
        String defaultDs;
        List<String> values = NewDSXMLWizard.getConnectionProfileNameList();
        return values.contains(defaultDs = NewDSXMLWizardFactory.EMPTY_PROFILE) ? defaultDs : (!values.isEmpty() ? values.get(0) : NewDSXMLWizardFactory.EMPTY_PROFILE);
    }

    private static List<String> getConnectionProfileNameList() {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
        ArrayList<String> names = new ArrayList<String>();
        IConnectionProfile[] iConnectionProfileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile connectionProfile = iConnectionProfileArray[n2];
            names.add(connectionProfile.getName());
            ++n2;
        }
        return names;
    }

    class WizardNewDSXMLFileCreationPage
    extends WizardPage {
        private IFieldEditor connProfileSelEditor;
        private IFieldEditor templateSelEditor;
        private IFieldEditor folderEditor;
        private String initialFileName;
        private IFieldEditor fileNameEditor;
        private IFieldEditor registerEditor;
        IDataModel model;
        FilterSetCollection viewFilterSetCollection;
        IFile newFile;
        static final String PERSISTENCE_XML_PATH = "META-INF/persistence.xml";

        public WizardNewDSXMLFileCreationPage(String pageName, IStructuredSelection selection) {
            super(pageName);
            this.initialFileName = "";
            this.newFile = null;
            this.setPageComplete(false);
            NewDSXMLWizard.this.setDefaultPageImageDescriptor(JSTWebUIImages.getInstance().getOrCreateImageDescriptor(JSTWebUIImages.DATASOURCE_IMAGE));
        }

        public IPath getContainerFullPath() {
            String path = this.folderEditor.getValueAsString();
            return new Path(path).makeAbsolute();
        }

        public void setFileName(String value) {
            if (this.fileNameEditor == null) {
                this.initialFileName = value;
            } else {
                this.fileNameEditor.setValue((Object)value);
            }
        }

        protected InputStream getInitialContents() {
            File dataSourceDsFile;
            IProject currentProject;
            block3: {
                String connection = this.connProfileSelEditor.getValueAsString();
                String templateName = this.templateSelEditor.getValueAsString();
                try {
                    IPath containerPath = this.getContainerFullPath();
                    currentProject = containerPath.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(containerPath.segment(0)) : ResourcesPlugin.getWorkspace().getRoot().getFolder(containerPath).getProject();
                    File homePath = DSDataModelProvider.getTemplatesFolder();
                    String templatePath = NewDSXMLWizardFactory.AS_7_TEMPLATE.equals(templateName) ? "/Datasource/datasource-ds-as7.xml" : "/Datasource/datasource-ds-default.xml";
                    dataSourceDsFile = new File(homePath, templatePath);
                    this.viewFilterSetCollection = new FilterSetCollection();
                    this.model = DataModelFactory.createDataModel((IDataModelProvider)new DSDataModelProvider());
                    this.model.setProperty("project.name", (Object)currentProject.getName());
                    this.model.setProperty("connection.profile", (Object)connection);
                    this.model.setProperty("datasource.name", (Object)NewDSXMLWizard.toDatasourceName(connection));
                    IConnectionProfile connProfile = ProfileManager.getInstance().getProfileByName(connection.toString());
                    if (connProfile != null) break block3;
                    return null;
                }
                catch (IOException e) {
                    WebUiPlugin.getDefault().logError(e);
                    return null;
                }
            }
            DSDataModelProvider.applyConnectionProfile(currentProject, this.model);
            FilterSet jdbcFilterSet = FilterSetFactory.createJdbcFilterSet(this.model);
            FilterSet projectFilterSet = FilterSetFactory.createProjectFilterSet(this.model);
            this.viewFilterSetCollection.addFilterSet(jdbcFilterSet);
            this.viewFilterSetCollection.addFilterSet(projectFilterSet);
            StringResource sr = new StringResource();
            ResourceUtils.copyResource((Resource)new FileResource(dataSourceDsFile), (Resource)sr, (FilterSetCollection)this.viewFilterSetCollection, null, (boolean)true, (boolean)false, (boolean)false, null, null, null, (boolean)false);
            return sr.getInputStream();
        }

        IFile getJarTarget() {
            if (!NewDSXMLWizardFactory.AS_7_TEMPLATE.equals(this.templateSelEditor.getValueAsString())) {
                return null;
            }
            String jarname = (String)this.model.getProperty("driver.jar.name");
            if (jarname != null) {
                IPath container = this.getContainerFullPath();
                IPath target = container.append(jarname);
                IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(target);
                if (!targetFile.exists()) {
                    return targetFile;
                }
            }
            return null;
        }

        InputStream getJarContents() {
            File jarSource;
            String[] jars = (String[])this.model.getProperty("driver.file");
            String jarname = (String)this.model.getProperty("driver.jar.name");
            if (jars != null && jarname != null && (jarSource = new File(jars[0])).isFile()) {
                IPath container = this.getContainerFullPath();
                IPath target = container.append(jarname);
                IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(target);
                if (!targetFile.exists()) {
                    try {
                        return new BufferedInputStream(new FileInputStream(jarSource));
                    }
                    catch (IOException e) {
                        WebUiPlugin.getDefault().logError(e);
                    }
                }
            }
            return null;
        }

        CreateFileOperation getJarFileOperation(IFile targetFile, InputStream jarContents) {
            return new CreateFileOperation(targetFile, null, jarContents, "Copy driver jar file.");
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite topLevel = new Composite(parent, 0);
            topLevel.setLayout((Layout)new GridLayout());
            topLevel.setLayoutData((Object)new GridData(784));
            topLevel.setFont(parent.getFont());
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)topLevel, "org.eclipse.ui.ide.new_file_wizard_page_context");
            this.connProfileSelEditor = NewDSXMLWizardFactory.createConnectionProfileSelectionFieldEditor(NewDSXMLWizard.this.getConnectionProfileDefaultValue(), new IValidator(){

                public Map<String, IStatus> validate(Object value, Object context) {
                    WizardNewDSXMLFileCreationPage.this.setPageComplete(WizardNewDSXMLFileCreationPage.this.validatePage());
                    return ValidatorFactory.NO_ERRORS;
                }
            }, false);
            this.templateSelEditor = NewDSXMLWizardFactory.createTemplateFieldEditor(NewDSXMLWizardFactory.TEMPLATE_LIST[0]);
            Composite q = new Composite(topLevel, 0);
            q.setLayoutData((Object)new GridData(784));
            GridLayout l = new GridLayout(4, false);
            q.setLayout((Layout)l);
            this.connProfileSelEditor.doFillIntoGrid((Object)q);
            this.templateSelEditor.doFillIntoGrid((Object)q);
            this.connProfileSelEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String prefix = NewDSXMLWizard.toDatasourceName(WizardNewDSXMLFileCreationPage.this.connProfileSelEditor.getValueAsString());
                    WizardNewDSXMLFileCreationPage.this.setFileName(String.valueOf(prefix) + "-ds.xml");
                    WizardNewDSXMLFileCreationPage.this.setPageComplete(WizardNewDSXMLFileCreationPage.this.validatePage());
                }
            });
            String defaultFolder = "";
            IContainer c = NewDSXMLWizard.this.getInitialContainer();
            if (c != null) {
                defaultFolder = c.getFullPath().toString();
            }
            this.folderEditor = IFieldEditorFactory.INSTANCE.createBrowseWorkspaceFolderEditor("folder", Messages.NewDSXMLWizard_PARENT_FOLDER_LABEL, defaultFolder);
            this.folderEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    WizardNewDSXMLFileCreationPage.this.setPageComplete(WizardNewDSXMLFileCreationPage.this.validatePage());
                }
            });
            this.folderEditor.doFillIntoGrid((Object)q);
            String prefix = NewDSXMLWizard.toDatasourceName(this.connProfileSelEditor.getValueAsString());
            String defaultFileName = String.valueOf(prefix) + "-ds.xml";
            this.fileNameEditor = IFieldEditorFactory.INSTANCE.createTextEditor("name", Messages.NewDSXMLWizard_FILE_NAME_LABEL, defaultFileName);
            this.fileNameEditor.doFillIntoGrid((Object)q);
            this.fileNameEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    WizardNewDSXMLFileCreationPage.this.setPageComplete(WizardNewDSXMLFileCreationPage.this.validatePage());
                }
            });
            this.registerEditor = IFieldEditorFactory.INSTANCE.createCheckboxEditor("register", Messages.NewDSXMLWizard_REGISTER_FILE_LABEL, false);
            this.registerEditor.doFillIntoGrid((Object)q);
            this.setControl((Control)topLevel);
            this.setPageComplete(this.validatePage());
        }

        protected boolean validatePage() {
            IPath path = this.getContainerFullPath();
            if (path.segmentCount() == 0) {
                this.setErrorMessage(Messages.NewDSXMLWizard_FOLDER_NOT_SET);
                return false;
            }
            String fileName = this.fileNameEditor.getValueAsString();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus result = workspace.validateName(fileName, 1);
            if (!result.isOK()) {
                this.setErrorMessage(result.getMessage());
                return false;
            }
            int i = 0;
            while (i < path.segmentCount()) {
                String s = path.segment(i);
                result = workspace.validateName(s, 2);
                if (!result.isOK()) {
                    this.setErrorMessage(result.getMessage());
                    return false;
                }
                ++i;
            }
            IPath filePath = path.append(fileName);
            if (workspace.getRoot().getFile(filePath).exists()) {
                this.setErrorMessage(NLS.bind((String)Messages.NewDSXMLWizard_FILE_EXISTS, (Object)fileName));
                return false;
            }
            IProject selectedProject = workspace.getRoot().getProject(path.segment(0));
            if (!selectedProject.exists()) {
                this.setErrorMessage(Messages.NewDSXMLWizard_PROJECT_NOT_EXISTS);
                return false;
            }
            if (!selectedProject.isAccessible()) {
                this.setErrorMessage(Messages.NewDSXMLWizard_PROJECT_NOT_ACCESSIBLE);
                return false;
            }
            if (this.connProfileSelEditor != null) {
                String p = this.connProfileSelEditor.getValueAsString();
                if (p == null || p.trim().length() == 0) {
                    this.setErrorMessage(Messages.NewDSXMLWizard_PROFILE_NOT_SET);
                    return false;
                }
                String profileName = p.trim();
                IConnectionProfile connProfile = ProfileManager.getInstance().getProfileByName(profileName);
                if (connProfile == null) {
                    this.setErrorMessage(Messages.NewDSXMLWizard_PROFILE_NOT_FOUND);
                    return false;
                }
                Properties props = connProfile.getBaseProperties();
                Object q = props.get("org.eclipse.datatools.connectivity.driverDefinitionID");
                if (q == null || DriverManager.getInstance().getDriverInstanceByID(q.toString()) == null) {
                    this.setMessage(Messages.NewDSXMLWizard_DRIVER_NOT_FOUND, 2);
                    this.setErrorMessage(null);
                    return true;
                }
                String jarList = props.getProperty("jarList");
                if (jarList == null) {
                    this.setMessage(Messages.NewDSXMLWizard_JAR_LIST_NOT_SET, 2);
                    this.setErrorMessage(null);
                    return true;
                }
            }
            this.setMessage(null, 2);
            this.setErrorMessage(null);
            return true;
        }

        protected IFile createFileHandle(IPath filePath) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        }

        public IFile createNewFile() {
            IFile persistenceFile;
            if (this.newFile != null) {
                return this.newFile;
            }
            IPath containerPath = this.getContainerFullPath();
            IPath newFilePath = containerPath.append(this.fileNameEditor.getValueAsString());
            final IFile newFileHandle = this.createFileHandle(newFilePath);
            final InputStream initialContents = this.getInitialContents();
            final IFile jarTarget = this.getJarTarget();
            final InputStream jarContents = jarTarget == null ? null : this.getJarContents();
            Object op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    CreateFileOperation op = new CreateFileOperation(newFileHandle, null, initialContents, IDEWorkbenchMessages.WizardNewFileCreationPage_title);
                    try {
                        op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)WizardNewDSXMLFileCreationPage.this.getShell()));
                        if (jarContents != null) {
                            CreateFileOperation jar = WizardNewDSXMLFileCreationPage.this.getJarFileOperation(jarTarget, jarContents);
                            jar.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)WizardNewDSXMLFileCreationPage.this.getShell()));
                        }
                    }
                    catch (ExecutionException e) {
                        WizardNewDSXMLFileCreationPage.this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (e.getCause() instanceof CoreException) {
                                    ErrorDialog.openError((Shell)WizardNewDSXMLFileCreationPage.this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_errorTitle, null, (IStatus)((CoreException)e.getCause()).getStatus());
                                } else {
                                    IDEWorkbenchPlugin.log(this.getClass(), (String)"createNewFile()", (Throwable)e.getCause());
                                    MessageDialog.openError((Shell)WizardNewDSXMLFileCreationPage.this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)e.getCause().getMessage()));
                                }
                            }
                        });
                    }
                }
            };
            try {
                this.getContainer().run(true, true, op);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (InvocationTargetException e) {
                IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), (String)"createNewFile()", (Throwable)e.getTargetException());
                MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)e.getTargetException().getMessage()), (int)0x10000000);
                return null;
            }
            this.newFile = newFileHandle;
            if ("true".equals(this.registerEditor.getValueAsString()) && (persistenceFile = this.findPersistenceXMLHandle()) != null) {
                final InputStream content = this.getPersistanceXMLContent(persistenceFile, this.newFile);
                op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        if (!persistenceFile.exists()) {
                            CreateFileOperation op = new CreateFileOperation(persistenceFile, null, content, IDEWorkbenchMessages.WizardNewFileCreationPage_title);
                            try {
                                op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)WizardNewDSXMLFileCreationPage.this.getShell()));
                            }
                            catch (ExecutionException e) {
                                WizardNewDSXMLFileCreationPage.this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (e.getCause() instanceof CoreException) {
                                            ErrorDialog.openError((Shell)WizardNewDSXMLFileCreationPage.this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_errorTitle, null, (IStatus)((CoreException)e.getCause()).getStatus());
                                        } else {
                                            IDEWorkbenchPlugin.log(this.getClass(), (String)"createNewFile()", (Throwable)e.getCause());
                                            MessageDialog.openError((Shell)WizardNewDSXMLFileCreationPage.this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)e.getCause().getMessage()));
                                        }
                                    }
                                });
                            }
                        } else {
                            try {
                                persistenceFile.setContents(content, 1, monitor);
                            }
                            catch (CoreException e) {
                                WebUiPlugin.getDefault().logError(e);
                            }
                        }
                    }
                };
                try {
                    this.getContainer().run(true, true, op);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
                catch (InvocationTargetException e) {
                    IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), (String)"createNewFile()", (Throwable)e.getTargetException());
                    MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)e.getTargetException().getMessage()), (int)0x10000000);
                }
            }
            return this.newFile;
        }

        private IFile findPersistenceXMLHandle() {
            IProject project = this.findJavaProject();
            if (project == null) {
                return null;
            }
            Set srcs = EclipseResourceUtil.getSourceFolders((IProject)project);
            IFolder src = (IFolder)EclipseResourceUtil.getJavaSourceRoot((IProject)project);
            if (src != null) {
                IFile result = src.getFile(PERSISTENCE_XML_PATH);
                if (!result.exists()) {
                    for (IFolder f : srcs) {
                        IFile r = f.getFile(PERSISTENCE_XML_PATH);
                        if (!r.exists()) continue;
                        return r;
                    }
                }
                return result;
            }
            return null;
        }

        private IProject findJavaProject() {
            IVirtualComponent comp;
            IPath containerPath = this.getContainerFullPath();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(containerPath.segment(0));
            if (EclipseResourceUtil.getJavaProject((IProject)project) != null) {
                return project;
            }
            if (JavaEEProjectUtilities.isEARProject((IProject)project) && (comp = ComponentCore.createComponent((IProject)project)) != null) {
                IVirtualReference[] refComponents;
                IVirtualReference[] iVirtualReferenceArray = refComponents = comp.getReferences();
                int n = refComponents.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject p;
                    IVirtualReference virtualReference = iVirtualReferenceArray[n2];
                    IVirtualComponent component = virtualReference.getReferencedComponent();
                    if (component != null && !component.isBinary() && !WebUtilities.isDynamicWebComponent((IVirtualComponent)component) && JavaEEProjectUtilities.isEJBProject((IProject)(p = component.getProject()))) {
                        return p;
                    }
                    ++n2;
                }
            }
            return null;
        }

        private InputStream getPersistanceXMLContent(IFile persistenceFile, IFile newFile) {
            try {
                FilterSet contentFilter = new FilterSet();
                contentFilter.addFilter("content", NewDSXMLWizard.this.getOldPersistenceContent(persistenceFile));
                contentFilter.addFilter("dsSourceLocation", newFile.getFullPath().removeFirstSegments(1).toString());
                this.viewFilterSetCollection.addFilterSet(contentFilter);
                File homePath = DSDataModelProvider.getTemplatesFolder();
                String templatePath = NewDSXMLWizardFactory.AS_7_TEMPLATE.equals(this.templateSelEditor.getValueAsString()) ? "/Datasource/persistence-xml-as7.xml" : "/Datasource/persistence-xml-default.xml";
                File persistenceFileTemplate = new File(homePath, templatePath);
                StringResource sr = new StringResource();
                ResourceUtils.copyResource((Resource)new FileResource(persistenceFileTemplate), (Resource)sr, (FilterSetCollection)this.viewFilterSetCollection, null, (boolean)true, (boolean)false, (boolean)false, null, null, null, (boolean)false);
                return sr.getInputStream();
            }
            catch (IOException e) {
                WebUiPlugin.getDefault().logError(e);
            }
            catch (CoreException e) {
                WebUiPlugin.getDefault().logError(e);
            }
            return null;
        }
    }
}

