/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jboss.tools.common.model.ui.internal.editors.PaletteItemResult;
import org.jboss.tools.common.text.IExecutableTextProposal;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.IHTMLLibraryVersion;
import org.jboss.tools.jst.web.kb.taglib.ITagLibRecognizer;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPTextEditor;
import org.jboss.tools.jst.web.ui.palette.internal.PaletteManager;
import org.jboss.tools.jst.web.ui.palette.internal.RunnablePaletteItem;

public abstract class PaletteTagLibrary
extends CustomTagLibrary {
    protected static final int HTML_GROUP_RELEVANCE = 92;
    protected static final int DEFAULT_GROUP_RELEVANCE = 93;
    private static int relevance = 93;
    private ImageDescriptor image = null;
    private IHTMLLibraryVersion paletteLibraryVersion;

    public PaletteTagLibrary(String name, String uri, String version, String defaultPrefix, Boolean ignoreCase) {
        this.setURI(uri);
        this.setVersion(version);
        this.setRecognizer(this.getTagLibRecognizer());
        this.name = name;
        this.defaultPrefix = defaultPrefix;
        this.ignoreCase = ignoreCase;
    }

    public TextProposal[] getProposals(KbQuery query, IPageContext context) {
        JSPTextEditor editor;
        ArrayList<TextProposal> proposals = new ArrayList<TextProposal>();
        if ((query.getType() == KbQuery.Type.TAG_NAME || query.getType() == KbQuery.Type.TEXT) && (editor = WebUiPlugin.getActiveEditor()) != null) {
            Collection<RunnablePaletteItem> items = this.getItems();
            for (RunnablePaletteItem item : items) {
                String startText;
                PaletteItemResult result = item.getResult(editor);
                if (result == null || (startText = result.getStartText()) == null || !this.startWith(startText, query)) continue;
                proposals.add(this.getProposal(item, result, editor));
            }
        }
        return proposals.toArray(new TextProposal[proposals.size()]);
    }

    protected void setPaletteLibraryVersion(IHTMLLibraryVersion paletteLibraryVersion) {
        this.paletteLibraryVersion = paletteLibraryVersion;
    }

    protected IHTMLLibraryVersion getPaletteLibraryVersion() {
        return this.paletteLibraryVersion;
    }

    private boolean startWith(String text, KbQuery query) {
        String startText = text.trim();
        return startText.startsWith(query.getValue()) || startText.length() > 1 && this.trim(startText).startsWith(query.getValue());
    }

    private String trim(String text) {
        if (text.length() > 1) {
            return text.substring(1);
        }
        return text;
    }

    protected TextProposal getProposal(RunnablePaletteItem item, PaletteItemResult result, JSPTextEditor editor) {
        TextProposal proposal = new TextProposal();
        String startText = result.getStartText();
        String endText = result.getEndText();
        String fullText = String.valueOf(startText) + "\n" + endText;
        proposal.setContextInfo(fullText.replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<br/>").replace(" ", "&nbsp;").replace("\t", "&nbsp;&nbsp;&nbsp;"));
        proposal.setLabel(PaletteTagLibrary.getLabel(item));
        proposal.setReplacementString(fullText);
        proposal.setImageDescriptor(this.getImage());
        proposal.setRelevance(this.getRelevance());
        proposal.setAlternateMatch(this.trim(startText));
        if (!item.getAlternatives().isEmpty()) {
            proposal.getAlternativeMatches().addAll(item.getAlternatives());
        }
        proposal.setFilterable(false);
        proposal.setExecutable((IExecutableTextProposal)item);
        return proposal;
    }

    public static String getLabel(RunnablePaletteItem item) {
        return String.valueOf(item.getName()) + " - " + item.getCategory() + " " + item.getVersion();
    }

    protected int getRelevance() {
        return 93;
    }

    protected static synchronized int generateUniqueRelevance() {
        return ++relevance;
    }

    public synchronized ImageDescriptor getImage() {
        if (this.image == null) {
            this.image = PaletteManager.getInstance().getImageDescriptor(this.getCategory());
        }
        return this.image;
    }

    public Collection<RunnablePaletteItem> getItems() {
        return PaletteManager.getInstance().getItems(this.getCategory(), this.getPaletteLibraryVersion());
    }

    protected abstract String getCategory();

    public abstract ITagLibRecognizer getTagLibRecognizer();
}

