/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.FocusListener;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteSeparator;
import org.jboss.tools.jst.web.ui.palette.CustomDrawerEditPart;
import org.jboss.tools.jst.web.ui.palette.MobileDrawerFigure;
import org.jboss.tools.jst.web.ui.palette.PaletteUIMessages;
import org.jboss.tools.jst.web.ui.palette.internal.HTML5DynamicDrawerFigure;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.HTML5DynamicPaletteGroup;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteDrawerImpl;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteTool;

public class MobileDrawerEditPart
extends CustomDrawerEditPart {
    private FlowPage messageLabel;
    private LayoutManager storedLayout;

    public MobileDrawerEditPart(PaletteDrawer drawer) {
        super(drawer);
    }

    protected int getLayoutSetting() {
        return 1;
    }

    @Override
    public IFigure createFigure() {
        PaletteDrawerImpl category = (PaletteDrawerImpl)((Object)this.getModel());
        if (category.getPaletteGroup() instanceof HTML5DynamicPaletteGroup) {
            HTML5DynamicDrawerFigure fig = new HTML5DynamicDrawerFigure(category, this.getViewer().getControl()){

                public IFigure getToolTip() {
                    return MobileDrawerEditPart.this.createToolTip();
                }
            };
            fig.setExpanded(this.getDrawer().isInitiallyOpen());
            fig.setPinned(this.getDrawer().isInitiallyPinned());
            fig.getCollapseToggle().setRequestFocusEnabled(true);
            fig.getCollapseToggle().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent fe) {
                    MobileDrawerEditPart.this.getViewer().select((EditPart)MobileDrawerEditPart.this);
                }

                public void focusLost(FocusEvent fe) {
                }
            });
            return fig;
        }
        MobileDrawerFigure fig = new MobileDrawerFigure(category, this.getViewer().getControl()){

            public IFigure getToolTip() {
                return MobileDrawerEditPart.this.createToolTip();
            }
        };
        fig.setExpanded(this.getDrawer().isInitiallyOpen());
        fig.setPinned(this.getDrawer().isInitiallyPinned());
        fig.getCollapseToggle().setRequestFocusEnabled(true);
        fig.getCollapseToggle().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent fe) {
                MobileDrawerEditPart.this.getViewer().select((EditPart)MobileDrawerEditPart.this);
            }

            public void focusLost(FocusEvent fe) {
            }
        });
        return fig;
    }

    public void refresh() {
        super.refresh();
        this.updateMessage();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        this.updateMessage();
    }

    private void updateMessage() {
        if (this.isNoVisibleItems()) {
            if (this.messageLabel == null) {
                String message = PaletteUIMessages.NO_LAST_USED_OR_MOST_POPULAR_YET;
                if (!this.isEmpty()) {
                    message = PaletteUIMessages.NO_ITEMS_FOUND;
                }
                this.messageLabel = new FlowPage();
                TextFlow tf = new TextFlow();
                tf.setForegroundColor(ColorConstants.gray);
                tf.setText(message);
                this.messageLabel.add((IFigure)tf);
                this.storedLayout = this.getDrawerFigure().getScrollpane().getContents().getLayoutManager();
                GridLayout layout = new GridLayout(1, false);
                layout.setConstraint((IFigure)this.messageLabel, (Object)new GridData(768));
                this.getDrawerFigure().getScrollpane().getContents().setLayoutManager((LayoutManager)layout);
            }
            this.getDrawerFigure().getScrollpane().getContents().add((IFigure)this.messageLabel);
        } else if (this.messageLabel != null) {
            this.getDrawerFigure().getScrollpane().getContents().remove((IFigure)this.messageLabel);
            this.getDrawerFigure().getScrollpane().getContents().setLayoutManager(this.storedLayout);
            this.messageLabel = null;
        }
    }

    private boolean isNoVisibleItems() {
        for (Object child : this.getDrawer().getChildren()) {
            if (child instanceof PaletteSeparator || !((PaletteTool)((Object)child)).isVisible()) continue;
            return false;
        }
        return true;
    }

    private boolean isEmpty() {
        for (Object child : this.getDrawer().getChildren()) {
            if (child instanceof PaletteSeparator) continue;
            return false;
        }
        return true;
    }
}

