/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.operation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.context.IImportWebProjectContext;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.operation.Messages;
import org.jboss.tools.jst.web.ui.operation.WebNatureOperation;
import org.w3c.dom.Element;

public abstract class WebProjectAdoptOperation
extends WebNatureOperation {
    protected IImportWebProjectContext context;

    public WebProjectAdoptOperation(IImportWebProjectContext context) {
        super(context.getProjectHandle(), (IPath)new Path(context.getSuggestedProjectLocation()), context.getRegisterServerContext(), new Properties());
        this.setProperty("WebNatureOperation.ANT_BUILD_XML_ID", context.getBuildXmlLocation().replace('\\', '/'));
        this.setProperty("WebNatureOperation.JAVA_CLASSES_LOCATION_ID", context.getClassesLocation().replace('\\', '/'));
        this.setProperty("WebNatureOperation.JAVA_SOURCES_LOCATION_ID", context.getJavaSources());
        this.setProperty("WebNatureOperation.JAVA_CREATE_SOURCE_FOLDERS_ID", Boolean.FALSE);
        this.setProperty("WebNatureOperation.WEB_INF_LIBRARY_LOCATION_ID", context.getLibLocation().replace('\\', '/'));
        this.setProperty("WebNatureOperation.PROJECT_NAME_ID", context.getProjectName());
        this.setProperty("WebNatureOperation.PROJECT_LOCATION_ID", context.getSuggestedProjectLocation().replace('\\', '/'));
        this.setProperty("WebNatureOperation.SERVLET_VERSION_ID", context.getServletVersion());
        this.setProperty("WebNatureOperation.WEB_INF_LOCATION_ID", context.getWebInfLocation().replace('\\', '/'));
        this.setProperty("WebNatureOperation.WEB_CONTENT_LOCATION_ID", context.getWebRootPath().replace('\\', '/'));
        this.setProperty("WebNatureOperation.WEB_XML_ID", context.getWebXmlLocation().replace('\\', '/'));
        this.setProperty("WebNatureOperation.RUNTIME_NAME", context.getRegisterServerContext().getRuntimeName());
        this.context = context;
    }

    @Override
    protected boolean isLinkingToProjectOutsideWorkspace() {
        return this.context.isLinkingToProjectOutsideWorkspace();
    }

    @Override
    protected boolean hasJavaSource() {
        String[] s = this.context.getJavaSources();
        if (s.length == 0) {
            return false;
        }
        int i = 0;
        while (i < s.length) {
            if (s[i] != null && s[i].length() > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected void preCreateWebNature() throws CoreException {
        this.setWorkspaceHome(this.getProperty("WebNatureOperation.WEB_INF_LOCATION_ID"));
        this.copyLibraries();
    }

    @Override
    protected void createWebNature() throws CoreException {
        EclipseResourceUtil.addNatureToProject((IProject)this.getProject(), (String)this.getNatureID());
        IModelNature nature = (IModelNature)this.getProject().getNature(this.getNatureID());
        this.model = nature.getModel();
        try {
            this.execute();
            String sv = this.context.getServletVersion();
            if (sv == null || sv.length() == 0) {
                sv = this.getDefaultServletVersion();
            }
            this.model.changeObjectAttribute(this.model.getByPath("Web"), "servlet version", sv);
        }
        catch (XModelException ex) {
            WebUiPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    @Override
    protected void postCreateWebNature() {
    }

    protected void copyLibraries() {
    }

    protected String getDefaultServletVersion() {
        return "";
    }

    protected abstract void execute() throws XModelException;

    void setWorkspaceHome(String path) {
        String relativePath = FileUtil.getRelativePath((String)this.getProject().getLocation().toString(), (String)path);
        if (relativePath != null) {
            path = "." + relativePath;
        }
        Element element = XMLUtil.createDocumentElement((String)"struts");
        element = XMLUtil.createElement((Element)element, (String)"workspace_home");
        element.appendChild(element.getOwnerDocument().createTextNode(path));
        OutputFormat format = new OutputFormat("xml", "UTF-8", true);
        format.setLineSeparator("\n");
        format.setIndent(2);
        OutputStreamWriter fileWriter = null;
        try {
            try {
                fileWriter = new FileWriter(String.valueOf(this.getProject().getLocation().toString()) + "/" + "org.jboss.tools.common.model.temp");
                XMLSerializer ser = new XMLSerializer((Writer)fileWriter, format);
                ser.asDOMSerializer();
                ser.serialize(element);
            }
            catch (IOException ex) {
                WebUiPlugin.getPluginLog().logError((Throwable)ex);
                try {
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                }
                catch (IOException ex2) {
                    WebUiPlugin.getPluginLog().logError((Throwable)ex2);
                }
            }
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException ex) {
                WebUiPlugin.getPluginLog().logError((Throwable)ex);
            }
        }
    }

    @Override
    protected boolean checkOverwrite() {
        String message;
        IProject project = this.getProject();
        if (project == null) {
            return false;
        }
        if (project.exists()) {
            return true;
        }
        String projectLocation = this.getProperty("WebNatureOperation.PROJECT_LOCATION_ID");
        if (this.isLinkingToProjectOutsideWorkspace()) {
            String root = ModelPlugin.getWorkspace().getRoot().getLocation().toString().replace('\\', '/');
            if (!projectLocation.replace('\\', '/').startsWith(String.valueOf(root) + "/")) {
                projectLocation = String.valueOf(root) + "/" + project.getName();
            }
        }
        Path path = new Path(projectLocation);
        String dots = null;
        int i = 0;
        while (i < this.dotFilesList.length && dots == null) {
            File file = path.append(this.dotFilesList[i]).toFile();
            if (file.exists()) {
                dots = this.dotFilesList[i];
            }
            ++i;
        }
        if (dots == null) {
            return true;
        }
        ServiceDialog d = PreferenceModelUtilities.getPreferenceModel().getService();
        int q = d.showDialog(Messages.WebProjectAdoptOperation_Warning, message = MessageFormat.format(Messages.ADOPT_WILL_OVERWRITE_DOT_FILES_MESSAGE, dots), new String[]{Messages.WebProjectAdoptOperation_Continue, Messages.WebProjectAdoptOperation_Cancel}, null, 2);
        if (q != 0) {
            return false;
        }
        return this.checkClearWorkspace();
    }

    protected boolean checkClearWorkspace() {
        String message;
        if (this.getProject().exists()) {
            return true;
        }
        String location = this.getProperty("WebNatureOperation.PROJECT_LOCATION_ID").replace('\\', '/');
        if (this.isDefaultLocation(location, false)) {
            return true;
        }
        String root = ModelPlugin.getWorkspace().getRoot().getLocation().toString().replace('\\', '/');
        String wsProjectLocation = (String.valueOf(root) + "/" + this.getProject().getName()).replace('\\', '/');
        File wsf = new File(wsProjectLocation);
        if (!wsf.isDirectory()) {
            return true;
        }
        File[] cs = wsf.listFiles();
        if (cs == null || cs.length == 0) {
            return true;
        }
        ServiceDialog d = PreferenceModelUtilities.getPreferenceModel().getService();
        int q = d.showDialog(Messages.WebProjectAdoptOperation_Warning, message = MessageFormat.format(Messages.ADOPT_WILL_CLEAR_WORKSPACE_MESSAGE, this.getProject().getName()), new String[]{Messages.WebProjectAdoptOperation_Continue, Messages.WebProjectAdoptOperation_Cancel}, null, 2);
        if (q != 0) {
            return false;
        }
        int i = 0;
        while (i < cs.length) {
            FileUtil.remove((File)cs[i]);
            ++i;
        }
        return true;
    }

    @Override
    protected void removeDotFiles(IPath projectLocation) {
        if (this.isLinkingToProjectOutsideWorkspace()) {
            return;
        }
        super.removeDotFiles(projectLocation);
    }
}

