/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.internal;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.text.ext.hyperlink.xml.XMLJumpToHyperlink;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatalistHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ArrayList<XMLJumpToHyperlink> links;
        block9: {
            links = new ArrayList<XMLJumpToHyperlink>();
            StructuredModelWrapper smw = new StructuredModelWrapper();
            smw.init(textViewer.getDocument());
            try {
                String attrValue;
                IndexedRegion node;
                Document xmlDocument = smw.getDocument();
                if (xmlDocument == null) {
                    return null;
                }
                Utils.AttrNodePair pair = Utils.findAttrNodePairForOffset((Node)xmlDocument, (int)region.getOffset());
                if (pair == null || pair.getNode() == null || pair.getAttribute() == null || !"input".equalsIgnoreCase(pair.getNode().getNodeName()) || !"list".equalsIgnoreCase(pair.getAttribute().getNodeName())) break block9;
                IRegion sourceRegion = null;
                try {
                    sourceRegion = Utils.getAttributeValueRegion((IDocument)textViewer.getDocument(), (Attr)pair.getAttribute());
                }
                catch (BadLocationException e) {
                    WebUiPlugin.getDefault().logError(e);
                }
                if (sourceRegion != null && region.getOffset() >= sourceRegion.getOffset() && region.getOffset() <= sourceRegion.getOffset() + sourceRegion.getLength() && (node = this.findNodeWithId(xmlDocument, "datalist", attrValue = pair.getAttribute().getNodeValue())) != null) {
                    Region targetRegion = new Region(node.getStartOffset(), ((IDOMElement)node).getStartEndOffset() - node.getStartOffset());
                    links.add(new XMLJumpToHyperlink(NLS.bind((String)WebUIMessages.ShowDatalist, (Object)attrValue), textViewer.getDocument(), sourceRegion, (IRegion)targetRegion));
                }
            }
            finally {
                smw.dispose();
            }
        }
        if (links.size() == 0) {
            return null;
        }
        return links.toArray(new IHyperlink[links.size()]);
    }

    private IndexedRegion findNodeWithId(Node node, String nodeName, String id) {
        NamedNodeMap attributes;
        Node attr;
        if (node instanceof IndexedRegion && nodeName.equalsIgnoreCase(node.getNodeName()) && node.hasAttributes() && (attr = (attributes = node.getAttributes()).getNamedItem("id")) != null && id.equalsIgnoreCase(attr.getNodeValue())) {
            return (IndexedRegion)node;
        }
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            IndexedRegion result = this.findNodeWithId(child, nodeName, id);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }
}

