/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.outline.IFormCategoryDescriptor;
import org.jboss.tools.jst.web.ui.internal.editor.outline.IFormPropertySource;
import org.jboss.tools.jst.web.ui.internal.properties.AbstractPropertySetViewer;
import org.jboss.tools.jst.web.ui.internal.properties.DefaultPropertySetViewer;
import org.jboss.tools.jst.web.ui.internal.properties.EditedDescriptor;
import org.jboss.tools.jst.web.ui.internal.properties.IEditedDescriptor;
import org.jboss.tools.jst.web.ui.internal.properties.IPropertySetViewer;
import org.jboss.tools.jst.web.ui.internal.properties.IPropertySheetModel;

public class FormPropertySheetViewer
extends Viewer
implements SelectionListener {
    public static final String ALL_CATEGORY = "All";
    IPropertySheetModel model;
    private Object[] input;
    protected TabFolder tab = null;
    protected Composite control = null;
    EditedDescriptor editedDescriptor = new EditedDescriptor(this);
    IPropertySetViewer selectedViewer;
    Map<String, Class<? extends IPropertySetViewer>> setViewerClassesByCategory = new HashMap<String, Class<? extends IPropertySetViewer>>();
    Map<String, IPropertySetViewer> setViewersByCategory = new HashMap<String, IPropertySetViewer>();

    public FormPropertySheetViewer(Composite parent) {
        this.control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        this.control.setLayout((Layout)layout);
        this.tab = new TabFolder(this.control, 0);
        GridData d = new GridData(1808);
        this.tab.setLayoutData((Object)d);
        this.tab.addSelectionListener((SelectionListener)this);
    }

    public IPropertySheetModel getModel() {
        return this.model;
    }

    public void setModel(IPropertySheetModel model) {
        this.model = model;
        this.setInput(this.input);
    }

    public Control getControl() {
        return this.control;
    }

    public Object getInput() {
        return this.input;
    }

    public ISelection getSelection() {
        IPropertyDescriptor d = this.editedDescriptor.getPropertyDescriptor();
        return d == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)d);
    }

    public IEditedDescriptor getEditedDecriptor() {
        return this.editedDescriptor;
    }

    public void refresh() {
        IPropertySetViewer v;
        List<IPropertyDescriptor> descriptors = this.model.getPropertyDescriptors();
        List<String> categories = this.getCategories(descriptors);
        String defaultCategory = ALL_CATEGORY;
        boolean changed = false;
        Iterator<String> it = this.setViewersByCategory.keySet().iterator();
        while (it.hasNext()) {
            String c = it.next();
            if (categories.contains(c)) continue;
            IPropertySetViewer v2 = this.setViewersByCategory.get(c);
            v2.dispose();
            it.remove();
            changed = true;
        }
        for (String c : categories) {
            if (this.setViewersByCategory.containsKey(c)) continue;
            changed = true;
        }
        if (changed) {
            for (IPropertySetViewer v3 : this.setViewersByCategory.values()) {
                v3.dispose();
            }
            this.setViewersByCategory.clear();
        }
        for (String c : categories) {
            if (!this.setViewersByCategory.containsKey(c)) {
                changed = true;
                v = this.createSetViewer(c);
                v.setModel(this.model);
                v.setEditedDescriptorService(this.editedDescriptor);
                this.setViewersByCategory.put(c, v);
                Composite all = v.createControl((Composite)this.tab);
                all.setLayoutData((Object)new GridData(768));
                continue;
            }
            if (this.selectedViewer == null || this.selectedViewer != this.setViewersByCategory.get(c)) continue;
            defaultCategory = c;
        }
        if (changed) {
            TabItem selection = null;
            TabItem[] is = this.tab.getItems();
            int i = is.length - 1;
            while (i >= 0) {
                is[i].dispose();
                --i;
            }
            for (String c : categories) {
                IPropertySetViewer v4 = this.setViewersByCategory.get(c);
                TabItem b1 = new TabItem(this.tab, 0);
                b1.setData((Object)c);
                b1.setText(v4.getCategoryDisplayName());
                b1.setControl(v4.getControl());
                if (defaultCategory.equals(c)) {
                    selection = b1;
                }
                this.tab.setSelection(b1);
            }
            if (selection != null) {
                this.tab.setSelection(selection);
            }
        }
        for (String c : categories) {
            v = this.setViewersByCategory.get(c);
            v.refresh(descriptors);
        }
        this.fireSelectedDescriptorChanged();
    }

    protected IPropertySetViewer createSetViewer(String category) {
        IPropertySetViewer result = null;
        if (category != null && this.setViewerClassesByCategory.containsKey(category)) {
            try {
                result = this.setViewerClassesByCategory.get(category).newInstance();
            }
            catch (InstantiationException e) {
                WebUiPlugin.getDefault().logError(e);
            }
            catch (IllegalAccessException e) {
                WebUiPlugin.getDefault().logError(e);
            }
            if (result == null) {
                result = new DefaultPropertySetViewer();
                this.setViewerClassesByCategory.put(category, DefaultPropertySetViewer.class);
            }
        } else {
            result = new DefaultPropertySetViewer();
        }
        result.setCategory(category);
        return result;
    }

    private List<String> getCategories(List<IPropertyDescriptor> descriptors) {
        ArrayList<String> result = new ArrayList<String>();
        IPropertySource s = this.model.getPropertySource();
        if (s instanceof IFormPropertySource) {
            IFormCategoryDescriptor[] ds = ((IFormPropertySource)s).getCategoryDescriptors();
            int i = 0;
            while (i < ds.length) {
                if (!this.setViewerClassesByCategory.containsKey(ds[i])) {
                    this.setViewerClassesByCategory.put(ds[i].getName(), ds[i].getUIClass());
                }
                result.add(ds[i].getName());
                ++i;
            }
        } else {
            TreeSet<String> categories = new TreeSet<String>();
            for (IPropertyDescriptor d : descriptors) {
                String c = d.getCategory();
                if (c == null) continue;
                categories.add(c);
            }
            categories.remove(ALL_CATEGORY);
            result.addAll(categories);
        }
        result.add(ALL_CATEGORY);
        return result;
    }

    public void setInput(Object input) {
        IPropertyDescriptor d;
        if (this.selectedViewer != null) {
            this.selectedViewer.applyEditorValue();
            this.deactivateCellEditor();
        }
        Object[] newInput = (Object[])input;
        if (this.input == null || newInput == null || this.input.length != newInput.length || newInput.length == 0 || this.input[0] != newInput[0]) {
            this.editedDescriptor.setDescriptor(null);
        }
        this.input = (Object[])input;
        if (input == null) {
            this.input = new Object[0];
        }
        this.model.setInput(this.input);
        IPropertyDescriptor selected = this.editedDescriptor.getPropertyDescriptor();
        if (selected != null && (d = this.model.getDescriptor(selected.getId().toString())) != selected) {
            this.editedDescriptor.setDescriptor(d);
        }
        this.refresh();
    }

    void deactivateCellEditor() {
        if (this.selectedViewer != null) {
            this.selectedViewer.stopEditing();
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void setFocus() {
        if (this.tab != null) {
            this.tab.setFocus();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        TabItem item;
        int i;
        if (this.selectedViewer != null) {
            this.selectedViewer.applyEditorValue();
            this.editedDescriptor.setDescriptor(null);
            this.deactivateCellEditor();
            this.selectedViewer = null;
        }
        if ((i = this.tab.getSelectionIndex()) >= 0 && (item = this.tab.getItem(i)) != null && item.getData() != null) {
            String category = item.getData().toString();
            this.selectedViewer = this.setViewersByCategory.get(category);
            if (this.selectedViewer instanceof AbstractPropertySetViewer) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (FormPropertySheetViewer.this.selectedViewer instanceof AbstractPropertySetViewer) {
                            ((AbstractPropertySetViewer)FormPropertySheetViewer.this.selectedViewer).updateUI();
                        }
                    }
                });
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void fireSelectedDescriptorChanged() {
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    public List<String> getCategories() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.tab != null && !this.tab.isDisposed()) {
            TabItem[] tabItemArray = this.tab.getItems();
            int n = tabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TabItem i = tabItemArray[n2];
                result.add(i.getData().toString());
                ++n2;
            }
        }
        return result;
    }

    public IPropertySetViewer getViewer(String category) {
        return this.setViewersByCategory.get(category);
    }
}

