/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.outline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.views.properties.IPropertySourceExtension;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.properties.EnumeratedStringPropertyDescriptor;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.PageProcessor;
import org.jboss.tools.jst.web.kb.taglib.IAttribute;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.contentassist.computers.FaceletsELCompletionProposalComputer;
import org.jboss.tools.jst.web.ui.internal.editor.contentassist.computers.JspELCompletionProposalComputer;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualController;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.editor.outline.AttributeSorter;
import org.jboss.tools.jst.web.ui.internal.editor.outline.CategoryDescriptor;
import org.jboss.tools.jst.web.ui.internal.editor.outline.CategoryProviderFactory;
import org.jboss.tools.jst.web.ui.internal.editor.outline.IFormCategoryDescriptor;
import org.jboss.tools.jst.web.ui.internal.editor.outline.IFormPropertySource;
import org.jboss.tools.jst.web.ui.internal.editor.outline.JSPDialogCellEditor;
import org.jboss.tools.jst.web.ui.internal.editor.outline.JSPPropertyDescriptor;
import org.jboss.tools.jst.web.ui.internal.editor.outline.ValueHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JSPPropertySourceAdapter
implements INodeAdapter,
IPropertySource,
IPropertySourceExtension,
IPropertySource2,
IFormPropertySource {
    protected static final String CATEGORY_ATTRIBUTES = XMLUIMessages.XMLPropertySourceAdapter_0;
    private static final boolean SET_EXPERT_FILTER = false;
    QueryFactory queryFactory = new QueryFactory();
    private AttributeSorter sorter = null;
    private Node fNode = null;
    private boolean fCaseSensitive = true;
    private IPropertyDescriptor[] fDescriptors = null;
    private ValueHelper valueHelper = new ValueHelper();
    IPageContext pageContext;
    JspELCompletionProposalComputer processor;
    int offset = 0;
    KbQuery kbQuery;
    KbQuery kbQueryAttr;
    private Set<String> attributeNames = new HashSet<String>();
    private Set<String> structuralAttributeNames = new HashSet<String>();
    private Map<String, String> structuralAttributes = new HashMap<String, String>();
    IFormCategoryDescriptor[] categoryDescriptors = new IFormCategoryDescriptor[0];
    ICategoryFilter[] categoryFilters = new ICategoryFilter[0];
    private Stack<Object> fValuesBeingSet = new Stack();

    public JSPPropertySourceAdapter(INodeNotifier target) {
        this.setTarget(target);
    }

    Map<String, Integer> getWeights() {
        return this.sorter == null ? new HashMap() : this.sorter.weights;
    }

    public void setTarget(INodeNotifier target) {
        Node node = this.fNode = target instanceof Node ? (Node)target : null;
        if (this.fNode instanceof IDOMNode) {
            DocumentTypeAdapter adapter;
            Document ownerDocument = this.fNode.getOwnerDocument();
            if (ownerDocument == null && this.fNode instanceof Document) {
                ownerDocument = (Document)this.fNode;
            }
            DocumentTypeAdapter documentTypeAdapter = adapter = ownerDocument == null ? null : (DocumentTypeAdapter)((INodeNotifier)ownerDocument).getAdapterFor(DocumentTypeAdapter.class);
            if (adapter != null) {
                this.fCaseSensitive = adapter.getTagNameCase() == 0;
            }
            this.offset = ((IDOMNode)this.fNode).getStartOffset() + this.fNode.getNodeName().length();
        }
        this.categoryFilters = new ICategoryFilter[0];
        if (!(this.fNode instanceof Comment) && this.fNode instanceof Node) {
            this.updateCategoryDescriptors();
        }
    }

    private void updateCategoryDescriptors() {
        if (this.fNode instanceof Node && this.getTextViewer() != null) {
            ITextViewer viewer = this.getTextViewer();
            if (viewer != null && this.hasFile()) {
                this.processor = this.valueHelper.isFacetets() ? new FaceletsELCompletionProposalComputer() : new JspELCompletionProposalComputer();
                this.processor.setKeepState(true);
                this.processor.computeCompletionProposals(new CompletionProposalInvocationContext(viewer, this.offset), (IProgressMonitor)new NullProgressMonitor());
                this.pageContext = this.processor.getContext();
                this.kbQuery = this.createKbQuery(this.processor);
                this.kbQuery.setMask(true);
                this.kbQueryAttr = this.createKbQuery(this.processor);
            }
            CategoryDescriptor[] ds = this.pageContext == null ? new CategoryDescriptor[]{} : CategoryProviderFactory.getInstance().getCategoryDescriptors(this.pageContext);
            ArrayList<CategoryDescriptor> ds1 = new ArrayList<CategoryDescriptor>();
            ArrayList<ICategoryFilter> fs1 = new ArrayList<ICategoryFilter>();
            IAttribute[] attrs = null;
            attrs = this.kbQuery != null && this.pageContext != null ? PageProcessor.getInstance().getAttributes(this.kbQuery, this.pageContext) : new IAttribute[]{};
            Object[] objectArray = ds;
            int n = ds.length;
            int n2 = 0;
            while (n2 < n) {
                CategoryDescriptor c = objectArray[n2];
                ds1.add(c);
                ICategoryFilter f = c.createCategoryFilter();
                if (f != null) {
                    f.setAttributes(attrs);
                    fs1.add(f);
                }
                ++n2;
            }
            this.categoryDescriptors = ds1.toArray(new IFormCategoryDescriptor[0]);
            this.categoryFilters = fs1.toArray(new ICategoryFilter[0]);
            this.structuralAttributeNames.clear();
            objectArray = this.categoryFilters;
            n = this.categoryFilters.length;
            n2 = 0;
            while (n2 < n) {
                Object f = objectArray[n2];
                this.structuralAttributeNames.addAll(f.getStructuralAttributes(this.fNode.getNodeName()));
                ++n2;
            }
        }
    }

    @Override
    public IFormCategoryDescriptor[] getCategoryDescriptors() {
        return this.categoryDescriptors;
    }

    protected ITextViewer getTextViewer() {
        IEditorPart editor = ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor == null) {
            return null;
        }
        if (editor instanceof JSPMultiPageEditor) {
            JSPMultiPageEditor jsp = (JSPMultiPageEditor)editor;
            return jsp.getSourceEditor().getTextViewer();
        }
        return null;
    }

    protected boolean hasFile() {
        IEditorPart editor = ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor == null) {
            return false;
        }
        if (editor instanceof JSPMultiPageEditor) {
            JSPMultiPageEditor jsp = (JSPMultiPageEditor)editor;
            IEditorInput input = jsp.getEditorInput();
            IFile f = (IFile)input.getAdapter(IFile.class);
            return f != null && f.exists();
        }
        return false;
    }

    public void setSorter(AttributeSorter sorter) {
        this.sorter = sorter;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.fNode == null) {
            if (this.fDescriptors == null || this.fDescriptors.length > 0) {
                this.fDescriptors = new IPropertyDescriptor[0];
            }
        } else if (this.fDescriptors == null || this.fDescriptors.length == 0) {
            this.attributeNamesChanged();
            this.fDescriptors = this.createPropertyDescriptors();
        } else if (this.attributeNamesChanged()) {
            this.updatePropertyDescriptors();
        }
        return this.fDescriptors;
    }

    private KbQuery getQuery(String attributeName) {
        this.kbQueryAttr.setValue(attributeName);
        this.kbQueryAttr.setStringQuery(attributeName);
        return this.kbQueryAttr;
    }

    private IPropertyDescriptor[] createPropertyDescriptors() {
        CMAttributeDeclaration attrDecl;
        if (this.sorter != null) {
            this.sorter.clear();
        }
        CMNamedNodeMap attrMap = null;
        CMElementDeclaration ed = this.getDeclaration();
        if (ed != null) {
            attrMap = ed.getAttributes();
        }
        ArrayList<IPropertyDescriptor> descriptorList = new ArrayList<IPropertyDescriptor>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> namesLow = new ArrayList<String>();
        IPropertyDescriptor descriptor = null;
        Map<String, IAttribute> as = this.getAttributes();
        for (IAttribute d : as.values()) {
            descriptor = null;
            String attrName = d.getName();
            if (!this.fCaseSensitive ? namesLow.contains(attrName.toLowerCase()) : names.contains(attrName)) continue;
            if (attrName.indexOf(42) >= 0 || (descriptor = this.createJSPPropertyDescriptor(d, attrName, false)) == null) continue;
            names.add(attrName);
            namesLow.add(attrName.toLowerCase());
            descriptorList.add(descriptor);
        }
        NamedNodeMap attributes = this.fNode.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                attrDecl = null;
                Attr attr = (Attr)attributes.item(i);
                String attrName = attr.getName();
                if (!(names.contains(attrName) || !this.fCaseSensitive && namesLow.contains(attrName.toLowerCase()))) {
                    if (attrMap != null) {
                        if (this.fCaseSensitive) {
                            attrDecl = (CMAttributeDeclaration)attrMap.getNamedItem(attrName);
                        } else {
                            int j = 0;
                            while (j < attrMap.getLength()) {
                                if (!this.fCaseSensitive && attrMap.item(j).getNodeName().equalsIgnoreCase(attrName)) {
                                    attrDecl = (CMAttributeDeclaration)attrMap.item(j);
                                    break;
                                }
                                ++j;
                            }
                        }
                    }
                    if (attrDecl != null) {
                        IAttribute a;
                        descriptor = this.createPropertyDescriptor(attrDecl);
                        if (descriptor instanceof TextPropertyDescriptor && (a = as.get(attrName)) != null) {
                            descriptor = this.createJSPPropertyDescriptor(a, attr.getName(), false);
                        }
                        if (descriptor != null) {
                            names.add(attrDecl.getNodeName());
                            namesLow.add(attrDecl.getNodeName().toLowerCase());
                        }
                    } else {
                        IAttribute a;
                        String an = attrName;
                        if (an.startsWith("xmlns:")) {
                            an = "xmlns:*";
                        }
                        if ((descriptor = (a = as.get(an)) != null ? this.createJSPPropertyDescriptor(a, attr.getName(), false) : this.createDefaultPropertyDescriptor(attr.getName(), false)) != null) {
                            names.add(attr.getName());
                        }
                        namesLow.add(attr.getName().toLowerCase());
                    }
                    if (descriptor != null) {
                        descriptorList.add(descriptor);
                    }
                }
                ++i;
            }
        }
        if (attrMap != null) {
            int i = 0;
            while (i < attrMap.getLength()) {
                attrDecl = null;
                attrDecl = (CMAttributeDeclaration)attrMap.item(i);
                if (!(names.contains(attrDecl.getAttrName()) || !this.fCaseSensitive && namesLow.contains(attrDecl.getAttrName().toLowerCase()))) {
                    IAttribute a;
                    IPropertyDescriptor holdDescriptor = this.createPropertyDescriptor(attrDecl);
                    if (holdDescriptor instanceof TextPropertyDescriptor && (a = as.get(attrDecl.getAttrName())) != null) {
                        holdDescriptor = this.createJSPPropertyDescriptor(a, attrDecl.getAttrName(), false);
                    }
                    if (holdDescriptor != null) {
                        descriptorList.add(holdDescriptor);
                    }
                }
                ++i;
            }
        }
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[descriptorList.size()];
        int i = 0;
        while (i < descriptors.length) {
            descriptors[i] = (IPropertyDescriptor)descriptorList.get(i);
            ++i;
        }
        return descriptors;
    }

    protected KbQuery createKbQuery(JspELCompletionProposalComputer processor) {
        KbQuery kbQuery = new KbQuery();
        KbQuery.Tag[] parentTags = processor.getParentTagsWithAttributes(true);
        kbQuery.setPrefix(this.getPrefix());
        kbQuery.setUri(processor.getUri(this.getPrefix()));
        kbQuery.setParentTagsWithAttributes(parentTags);
        kbQuery.setParent(this.fNode.getNodeName());
        kbQuery.setMask(false);
        kbQuery.setType(KbQuery.Type.ATTRIBUTE_NAME);
        kbQuery.setOffset(this.offset);
        kbQuery.setValue("");
        kbQuery.setStringQuery("");
        if (parentTags.length > 0) {
            kbQuery.setAttributes(parentTags[parentTags.length - 1].getAttributes());
        }
        return kbQuery;
    }

    private String getPrefix() {
        int i = this.fNode.getNodeName().indexOf(58);
        return i < 0 ? null : this.fNode.getNodeName().substring(0, i);
    }

    private String getCategory(String attrName, CMAttributeDeclaration attrDecl) {
        String result = this.getCategoryByName(attrName);
        if (result != null) {
            return result;
        }
        if (attrDecl != null && attrDecl.supports("category")) {
            return (String)attrDecl.getProperty("category");
        }
        return CATEGORY_ATTRIBUTES;
    }

    private String getCategoryByName(String attrName) {
        String category = null;
        if (this.categoryFilters.length > 0 && this.kbQuery != null && this.kbQuery.getParentTagsWithAttributes().length > 0) {
            ICategoryFilter[] iCategoryFilterArray = this.categoryFilters;
            int n = this.categoryFilters.length;
            int n2 = 0;
            while (n2 < n) {
                ICategoryFilter f = iCategoryFilterArray[n2];
                String c = f.getCategory(attrName);
                if (c != null) {
                    return c;
                }
                if (category == null) {
                    category = c;
                }
                ++n2;
            }
        }
        return category;
    }

    private CMElementDeclaration getDeclaration() {
        ModelQuery modelQuery;
        if (this.fNode == null || this.fNode.getNodeType() != 1) {
            return null;
        }
        Document document = this.fNode.getOwnerDocument();
        ModelQuery modelQuery2 = modelQuery = document == null ? null : ModelQueryUtil.getModelQuery((Document)document);
        if (modelQuery != null) {
            return modelQuery.getCMElementDeclaration((Element)this.fNode);
        }
        return null;
    }

    private IPropertyDescriptor createJSPPropertyDescriptor(IAttribute d, String attributeName, boolean hideOnFilter) {
        if (d != null && this.sorter != null) {
            if (d.isRequired()) {
                this.sorter.setWeight(attributeName, 2);
            } else if (d.isPreferable()) {
                this.sorter.setWeight(attributeName, 1);
            } else {
                this.sorter.setWeight(attributeName, 0);
            }
        }
        Properties context = new Properties();
        context.put("node", this.fNode);
        context.setProperty("nodeName", this.fNode.getNodeName());
        context.setProperty("attributeName", attributeName);
        context.put("valueHelper", this.valueHelper);
        context.put("pageContext", this.pageContext);
        context.put("processor", (Object)this.processor);
        context.put("queryFactory", this.queryFactory);
        JSPPropertyDescriptor descriptor = new JSPPropertyDescriptor(context, attributeName, attributeName);
        this.setCategory(descriptor, attributeName, null);
        if (d.getDescription() != null && d.getDescription().length() > 0) {
            descriptor.setDescription(d.getDescription());
        } else {
            descriptor.setDescription(attributeName);
        }
        return descriptor;
    }

    private void setCategory(PropertyDescriptor descriptor, String attributeName, CMAttributeDeclaration attrDecl) {
        String category = this.getCategory(attributeName, attrDecl);
        descriptor.setCategory(category);
    }

    private IPropertyDescriptor createDefaultPropertyDescriptor(String attributeName, boolean hideOnFilter) {
        TextPropertyDescriptor descriptor = new TextPropertyDescriptor((Object)attributeName, attributeName);
        this.setCategory((PropertyDescriptor)descriptor, attributeName, null);
        descriptor.setDescription(attributeName);
        return descriptor;
    }

    boolean attributeNamesChanged() {
        HashSet<String> as = new HashSet<String>();
        NamedNodeMap attributes = this.fNode.getAttributes();
        boolean changed = false;
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Attr attr = (Attr)attributes.item(i);
                String attrName = attr.getName();
                as.add(attrName);
                if (!this.attributeNames.contains(attrName)) {
                    changed = true;
                }
                ++i;
            }
        }
        if (!changed && this.attributeNames.size() != as.size()) {
            changed = true;
        }
        if (changed) {
            this.attributeNames = as;
        }
        boolean changed2 = false;
        HashMap<String, String> sas = new HashMap<String, String>();
        if (attributes != null) {
            for (String a : this.structuralAttributeNames) {
                Node n = attributes.getNamedItem(a);
                if (!(n instanceof Attr)) continue;
                String v = ((Attr)n).getValue();
                sas.put(a, v);
                if (this.structuralAttributes.containsKey(a) && this.structuralAttributes.get(a).equals(v)) continue;
                changed2 = true;
            }
        }
        if (!changed2 && this.structuralAttributes.size() != sas.size()) {
            changed2 = true;
        }
        if (changed2) {
            this.structuralAttributes = sas;
        }
        return changed || changed2;
    }

    protected void updatePropertyDescriptors() {
        IAttribute a;
        int i;
        if (this.fDescriptors == null || this.fDescriptors.length == 0) {
            return;
        }
        this.updateCategoryDescriptors();
        Map<String, IAttribute> as = this.getAttributes();
        ArrayList<String> declaredNames = new ArrayList<String>();
        ArrayList<IPropertyDescriptor> descriptors = new ArrayList<IPropertyDescriptor>();
        HashSet<String> descriptorNames = new HashSet<String>();
        HashSet<String> descriptorNamesLow = new HashSet<String>();
        CMElementDeclaration ed = this.getDeclaration();
        CMNamedNodeMap attrMap = null;
        if (ed != null) {
            attrMap = ed.getAttributes();
        }
        if (attrMap != null) {
            CMAttributeDeclaration attrDecl = null;
            i = 0;
            while (i < attrMap.getLength()) {
                attrDecl = (CMAttributeDeclaration)attrMap.item(i);
                String attrName = attrDecl.getAttrName();
                if (!declaredNames.contains(attrName)) {
                    declaredNames.add(attrName);
                }
                int j = 0;
                while (j < this.fDescriptors.length) {
                    boolean sameName;
                    boolean bl = sameName = this.fCaseSensitive && this.fDescriptors[j].getId().equals(attrDecl.getNodeName()) || !this.fCaseSensitive && attrDecl.getNodeName().equals(this.fDescriptors[j].getId().toString());
                    if (sameName) {
                        String[] validValues = this.getValidValues(attrDecl);
                        if (this.fDescriptors[j] instanceof EnumeratedStringPropertyDescriptor) {
                            ((EnumeratedStringPropertyDescriptor)this.fDescriptors[j]).updateValues(validValues);
                        } else if (validValues != null && validValues.length > 0) {
                            this.fDescriptors[j] = this.createPropertyDescriptor(attrDecl);
                            if (this.fDescriptors[j] instanceof TextPropertyDescriptor && (a = as.get(attrName)) != null) {
                                this.fDescriptors[j] = this.createJSPPropertyDescriptor(a, attrDecl.getAttrName(), false);
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int j = 0;
            while (j < this.fDescriptors.length) {
                if (!(this.fDescriptors[j] instanceof TextPropertyDescriptor)) {
                    this.fDescriptors[j] = this.createDefaultPropertyDescriptor((String)this.fDescriptors[j].getId(), false);
                }
                ++j;
            }
        }
        NamedNodeMap attributes = this.fNode.getAttributes();
        if (attributes != null) {
            i = 0;
            while (i < this.fDescriptors.length) {
                String descriptorName;
                if (this.fDescriptors[i] != null && (declaredNames.contains(descriptorName = this.fDescriptors[i].getId().toString()) || attributes.getNamedItem(descriptorName) != null) && !descriptorNames.contains(descriptorName)) {
                    descriptorNames.add(descriptorName);
                    descriptorNamesLow.add(descriptorName.toLowerCase());
                    descriptors.add(this.fDescriptors[i]);
                }
                ++i;
            }
        }
        if (attrMap != null) {
            CMAttributeDeclaration attrDecl = null;
            int i2 = 0;
            while (i2 < attrMap.getLength()) {
                attrDecl = (CMAttributeDeclaration)attrMap.item(i2);
                String attrName = attrDecl.getAttrName();
                if (this.fCaseSensitive) {
                    if (!descriptorNames.contains(attrName)) {
                        IAttribute a2;
                        IPropertyDescriptor descriptor = this.createPropertyDescriptor(attrDecl);
                        if (descriptor instanceof TextPropertyDescriptor && (a2 = as.get(attrName)) != null) {
                            descriptor = this.createJSPPropertyDescriptor(a2, attrDecl.getAttrName(), false);
                        }
                        if (descriptor != null) {
                            descriptorNames.add(attrName);
                            descriptorNamesLow.add(attrName.toLowerCase());
                            descriptors.add(descriptor);
                        }
                    }
                } else {
                    boolean exists = descriptorNamesLow.contains(attrName.toLowerCase());
                    if (!exists) {
                        descriptorNames.add(attrName);
                        descriptorNamesLow.add(attrName.toLowerCase());
                        IPropertyDescriptor descriptor = this.createPropertyDescriptor(attrDecl);
                        if (descriptor instanceof TextPropertyDescriptor && (a = as.get(attrName)) != null) {
                            descriptor = this.createJSPPropertyDescriptor(a, attrDecl.getAttrName(), false);
                        }
                        if (descriptor != null) {
                            descriptorNames.add(attrName);
                            descriptorNamesLow.add(attrName.toLowerCase());
                            descriptors.add(descriptor);
                        }
                    }
                }
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < this.fDescriptors.length) {
            String descriptorName;
            if (this.fDescriptors[i3] != null && as.get(descriptorName = this.fDescriptors[i3].getId().toString()) != null && !descriptorNames.contains(descriptorName)) {
                descriptorNames.add(descriptorName);
                descriptorNamesLow.add(descriptorName.toLowerCase());
                descriptors.add(this.fDescriptors[i3]);
            }
            ++i3;
        }
        for (IAttribute d : as.values()) {
            boolean exists;
            String attrName = d.getName();
            if (this.fCaseSensitive ? descriptorNames.contains(attrName) : (exists = descriptorNamesLow.contains(attrName.toLowerCase()))) continue;
            descriptorNames.add(attrName);
            descriptorNamesLow.add(attrName.toLowerCase());
            IPropertyDescriptor descriptor = null;
            descriptor = this.createJSPPropertyDescriptor(d, attrName, false);
            descriptors.add(descriptor);
        }
        if (attributes != null) {
            i = 0;
            while (i < attributes.getLength()) {
                Attr attr = (Attr)attributes.item(i);
                String attrName = attr.getName();
                if (this.fCaseSensitive) {
                    if (!descriptorNames.contains(attrName)) {
                        descriptorNames.add(attrName);
                        descriptorNamesLow.add(attrName.toLowerCase());
                        descriptors.add(this.createDefaultPropertyDescriptor(attrName, false));
                    }
                } else {
                    boolean exists = descriptorNamesLow.contains(attrName.toLowerCase());
                    if (!exists) {
                        descriptorNames.add(attrName);
                        descriptorNamesLow.add(attrName.toLowerCase());
                        descriptors.add(this.createDefaultPropertyDescriptor(attrName, false));
                    }
                }
                ++i;
            }
        }
        IPropertyDescriptor[] newDescriptors = new IPropertyDescriptor[descriptors.size()];
        int i4 = 0;
        while (i4 < newDescriptors.length) {
            newDescriptors[i4] = (IPropertyDescriptor)descriptors.get(i4);
            ++i4;
        }
        this.fDescriptors = newDescriptors;
    }

    public void setPropertyValue(Object nameObject, Object value) {
        if (!this.fValuesBeingSet.isEmpty() && this.fValuesBeingSet.peek() == nameObject) {
            return;
        }
        this.fValuesBeingSet.push(nameObject);
        String name = nameObject.toString();
        String valueString = null;
        if (value != null) {
            valueString = value.toString();
        }
        NamedNodeMap attrMap = this.fNode.getAttributes();
        try {
            if (attrMap != null) {
                Attr attr = (Attr)attrMap.getNamedItem(name);
                if (attr != null) {
                    if (attr.getValue() == null || !attr.getValue().equals(valueString)) {
                        if (valueString == null || valueString.length() == 0 && !this.isRequiredAttribute(attr.getName())) {
                            this.fNode.getAttributes().removeNamedItem(attr.getName());
                        } else if (attr instanceof IDOMNode) {
                            ((IDOMNode)attr).setValueSource(valueString);
                            IVisualController controller = this.valueHelper.getController();
                            if (controller != null) {
                                controller.visualRefresh();
                            }
                        } else {
                            attr.setValue(valueString);
                        }
                    }
                } else if (value != null && this.fNode.getOwnerDocument() != null) {
                    Attr newAttr = this.fNode.getOwnerDocument().createAttribute(name);
                    if (newAttr instanceof IDOMNode) {
                        ((IDOMNode)newAttr).setValueSource(valueString);
                    } else {
                        newAttr.setValue(valueString);
                    }
                    attrMap.setNamedItem(newAttr);
                }
            } else if (this.fNode instanceof Element) {
                ((Element)this.fNode).setAttribute(name, valueString);
            }
        }
        catch (DOMException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
        this.fValuesBeingSet.pop();
    }

    boolean isRequiredAttribute(String attributeName) {
        Map<String, IAttribute> as = this.getAttributes();
        IAttribute d = as.get(attributeName);
        if (d == null) {
            return false;
        }
        return d.isRequired();
    }

    private Map<String, IAttribute> getAttributes() {
        return this.kbQuery == null || this.pageContext == null ? new HashMap<String, IAttribute>() : PageProcessor.getInstance().getAttributesAsMap(this.kbQuery, this.pageContext);
    }

    public boolean isAdapterForType(Object type) {
        return type == IPropertySource.class;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    public Object getEditableValue() {
        return null;
    }

    public Object getPropertyValue(Object nameObject) {
        Node attribute;
        String name = nameObject.toString();
        String returnedValue = null;
        NamedNodeMap attrMap = this.fNode.getAttributes();
        if (attrMap != null && (attribute = attrMap.getNamedItem(name)) != null) {
            returnedValue = attribute instanceof IDOMNode ? ((IDOMNode)attribute).getValueSource() : attribute.getNodeValue();
        }
        if (returnedValue == null) {
            returnedValue = "";
        }
        return returnedValue;
    }

    public boolean isPropertySet(Object propertyObject) {
        String property = propertyObject.toString();
        NamedNodeMap attrMap = this.fNode.getAttributes();
        if (attrMap != null) {
            return attrMap.getNamedItem(property) != null;
        }
        return false;
    }

    public void resetPropertyValue(Object propertyObject) {
        String property = propertyObject.toString();
        CMNamedNodeMap attrDecls = null;
        CMElementDeclaration ed = this.getDeclaration();
        if (ed != null) {
            attrDecls = ed.getAttributes();
        }
        NamedNodeMap attrMap = this.fNode.getAttributes();
        if (attrDecls != null) {
            CMDataType helper;
            CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)attrDecls.getNamedItem(property);
            String defValue = null;
            if (attrDecl != null && attrDecl.getAttrType() != null && (helper = attrDecl.getAttrType()).getImpliedValueKind() != 1 && helper.getImpliedValue() != null) {
                defValue = helper.getImpliedValue();
            }
            if (defValue != null && defValue.length() > 0) {
                ((Attr)attrMap.getNamedItem(property)).setValue(defValue);
            } else {
                attrMap.removeNamedItem(property);
            }
        } else {
            attrMap.removeNamedItem(property);
        }
    }

    public boolean isPropertyRemovable(Object id) {
        return true;
    }

    public void removeProperty(Object propertyObject) {
        Node attribute;
        NamedNodeMap attrMap = this.fNode.getAttributes();
        if (attrMap != null && (attribute = attrMap.getNamedItem(propertyObject.toString())) != null) {
            try {
                attrMap.removeNamedItem(propertyObject.toString());
            }
            catch (DOMException e) {
                WebUiPlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    public boolean isPropertyResettable(Object id) {
        CMDataType helper;
        CMAttributeDeclaration attrDecl;
        boolean resettable = false;
        String property = id.toString();
        CMNamedNodeMap attrDecls = null;
        CMElementDeclaration ed = this.getDeclaration();
        if (ed != null) {
            attrDecls = ed.getAttributes();
        }
        if (attrDecls != null && (attrDecl = (CMAttributeDeclaration)attrDecls.getNamedItem(property)) != null && attrDecl.getAttrType() != null && (helper = attrDecl.getAttrType()).getImpliedValueKind() != 1 && helper.getImpliedValue() != null) {
            resettable = true;
        }
        return resettable;
    }

    protected IPropertyDescriptor createPropertyDescriptor(CMAttributeDeclaration attrDecl) {
        IPropertyDescriptor descriptor = null;
        CMDataType attrType = attrDecl.getAttrType();
        descriptor = attrType != null ? (attrType.getEnumeratedValues() != null && attrType.getEnumeratedValues().length > 0 ? this.createEnumeratedPropertyDescriptor(attrDecl, attrType) : ((attrDecl.getUsage() == 3 || attrType.getImpliedValueKind() == 2) && attrType.getImpliedValue() != null ? this.createFixedPropertyDescriptor(attrDecl, attrType) : this.createTextPropertyDescriptor(attrDecl))) : this.createTextPropertyDescriptor(attrDecl);
        return descriptor;
    }

    private IPropertyDescriptor createTextPropertyDescriptor(CMAttributeDeclaration attrDecl) {
        String name = attrDecl.getAttrName();
        TextPropertyDescriptor descriptor = new TextPropertyDescriptor((Object)name, name);
        this.setCategory((PropertyDescriptor)descriptor, name, attrDecl);
        descriptor.setDescription(name);
        return descriptor;
    }

    private IPropertyDescriptor createEnumeratedPropertyDescriptor(CMAttributeDeclaration attrDecl, CMDataType valuesHelper) {
        EnumeratedStringPropertyDescriptor descriptor = new EnumeratedStringPropertyDescriptor((Object)attrDecl.getAttrName(), attrDecl.getAttrName(), this._getValidStrings(attrDecl, valuesHelper));
        String name = attrDecl.getAttrName();
        this.setCategory((PropertyDescriptor)descriptor, name, attrDecl);
        descriptor.setDescription(name);
        return descriptor;
    }

    private IPropertyDescriptor createFixedPropertyDescriptor(CMAttributeDeclaration attrDecl, CMDataType helper) {
        EnumeratedStringPropertyDescriptor descriptor = new EnumeratedStringPropertyDescriptor((Object)attrDecl.getNodeName(), attrDecl.getNodeName(), this._getValidFixedStrings(attrDecl, helper));
        String name = attrDecl.getAttrName();
        this.setCategory((PropertyDescriptor)descriptor, name, attrDecl);
        descriptor.setDescription(name);
        return descriptor;
    }

    private String[] getValidValues(CMAttributeDeclaration attrDecl) {
        if (attrDecl == null) {
            return new String[0];
        }
        String[] validValues = null;
        CMDataType attrType = attrDecl.getAttrType();
        if (attrType != null) {
            validValues = this._getValidStrings(attrDecl, attrType);
        }
        if (validValues == null) {
            validValues = new String[]{};
        }
        return validValues;
    }

    private String[] _getValidStrings(CMAttributeDeclaration attrDecl, CMDataType valuesHelper) {
        String attributeName = attrDecl.getAttrName();
        ArrayList<String> values = new ArrayList<String>(1);
        boolean currentValueKnown = false;
        boolean checkIfCurrentValueIsKnown = this.fNode.getAttributes() != null && this.fNode.getAttributes().getNamedItem(attributeName) != null && this.fNode.getAttributes().getNamedItem(attributeName).getNodeValue() != null;
        String currentValue = null;
        if (checkIfCurrentValueIsKnown) {
            currentValue = this.fNode.getAttributes().getNamedItem(attributeName).getNodeValue();
        }
        if (valuesHelper.getImpliedValueKind() == 2 && valuesHelper.getImpliedValue() != null) {
            currentValueKnown = currentValue != null && valuesHelper.getImpliedValue().equals(currentValue);
            values.add(valuesHelper.getImpliedValue());
        } else {
            String[] valueStrings = null;
            Document document = this.fNode.getOwnerDocument();
            ModelQuery modelQuery = document == null ? null : ModelQueryUtil.getModelQuery((Document)document);
            valueStrings = modelQuery != null && this.fNode.getNodeType() == 1 ? modelQuery.getPossibleDataTypeValues((Element)this.fNode, (CMNode)attrDecl) : attrDecl.getAttrType().getEnumeratedValues();
            if (valueStrings != null) {
                int i = 0;
                while (i < valueStrings.length) {
                    if (checkIfCurrentValueIsKnown && valueStrings[i].equals(currentValue)) {
                        currentValueKnown = true;
                    }
                    values.add(valueStrings[i]);
                    ++i;
                }
            }
        }
        if (valuesHelper.getImpliedValueKind() != 1 && valuesHelper.getImpliedValue() != null && !values.contains(valuesHelper.getImpliedValue())) {
            values.add(valuesHelper.getImpliedValue());
        }
        if (checkIfCurrentValueIsKnown && !currentValueKnown && currentValue != null && currentValue.length() > 0) {
            values.add(currentValue);
        }
        String[] validStrings = new String[values.size()];
        validStrings = values.toArray(validStrings);
        return validStrings;
    }

    private String[] _getValidFixedStrings(CMAttributeDeclaration attrDecl, CMDataType helper) {
        boolean checkIfCurrentValueIsIncluded;
        String attributeName = attrDecl.getAttrName();
        ArrayList<String> values = new ArrayList<String>(1);
        String impliedValue = helper.getImpliedValue();
        if (impliedValue != null) {
            values.add(impliedValue);
        }
        boolean bl = checkIfCurrentValueIsIncluded = this.fNode.getAttributes() != null && this.fNode.getAttributes().getNamedItem(attributeName) != null && this.fNode.getAttributes().getNamedItem(attributeName).getNodeValue() != null;
        if (checkIfCurrentValueIsIncluded) {
            String currentValue = null;
            currentValue = this.fNode.getAttributes().getNamedItem(attributeName).getNodeValue();
            if (!currentValue.equals(impliedValue)) {
                values.add(currentValue);
            }
        }
        String[] validStrings = new String[values.size()];
        validStrings = values.toArray(validStrings);
        return validStrings;
    }

    @Override
    public void addContentAssist(Text text, IPropertyDescriptor d) {
        if (d instanceof JSPPropertyDescriptor) {
            JSPPropertyDescriptor d1 = (JSPPropertyDescriptor)d;
            JSPDialogCellEditor.addContentAssist(text, d1.context, null);
        }
    }

    public static interface ICategoryFilter {
        public void setAttributes(IAttribute[] var1);

        public String getCategory(String var1);

        public Collection<String> getStructuralAttributes(String var1);
    }

    public static interface IQueryFactory {
        public boolean isAvailable(String var1);
    }

    class QueryFactory
    implements IQueryFactory {
        QueryFactory() {
        }

        @Override
        public boolean isAvailable(String attributeName) {
            if (attributeName.equals("style") || attributeName.equals("class")) {
                return true;
            }
            KbQuery query = JSPPropertySourceAdapter.this.getQuery(attributeName);
            return JSPPropertySourceAdapter.this.valueHelper.isAvailable(JSPPropertySourceAdapter.this.pageContext, query);
        }
    }
}

