/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd;

import java.util.Properties;
import org.jboss.tools.common.model.ui.editors.dnd.IDropCommand;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizard;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizardModel;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.common.model.ui.editors.dnd.PaletteDropWizardModel;
import org.jboss.tools.common.model.ui.views.palette.IPositionCorrector;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.FileDropCommand;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.MobilePaletteInsertHelper;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteItem;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteItemWizard;

public class PaletteItemDropCommand
extends FileDropCommand {
    private String newLine;
    private Properties properties = new Properties();
    private IPaletteItem paletteItem;
    private boolean doNotShowWizard = false;
    private IPositionCorrector corrector;
    static String[] PROPERTIES_FOR_RUN = new String[]{"palettePath", "insert jquery mobile js css", "preferred-js-lib-versions"};

    public PaletteItemDropCommand(IPaletteItem paletteItem, boolean doNotShowWizard) {
        this.paletteItem = paletteItem;
        this.doNotShowWizard = doNotShowWizard;
        this.corrector = paletteItem.createPositionCorrector();
    }

    public IPositionCorrector getPositionCorrector() {
        return this.corrector;
    }

    public void setDoNotShowDialog(boolean doNotShowWizard) {
        this.doNotShowWizard = doNotShowWizard;
    }

    protected boolean doNotShowDialog() {
        return this.doNotShowWizard;
    }

    @Override
    protected IDropWizardModel createSpecificModel() {
        return new PaletteDropWizardModel(this.tagProposalFactory);
    }

    public IPaletteItem getPaletteItem() {
        return this.paletteItem;
    }

    @Override
    protected void addCustomProperties(Properties runningProperties) {
        this.newLine = this.properties.getProperty("new line");
        if (this.newLine == null) {
            this.newLine = "true";
        }
        runningProperties.setProperty("new line", this.newLine);
        String addTaglib = this.properties.getProperty("add taglib");
        if (addTaglib == null) {
            addTaglib = "true";
        }
        runningProperties.setProperty("add taglib", addTaglib);
    }

    public void execute() {
        if (this.paletteItem.hasWizard()) {
            IElementGenerator generator = this.getDefaultModel().getElementGenerator();
            this.properties.put("start text", generator.generateStartTag());
            this.properties.put("end text", generator.generateEndTag());
        } else {
            this.properties.put("start text", this.paletteItem.getStartText());
            this.properties.put("end text", this.paletteItem.getEndText());
        }
        this.properties.setProperty("automatically reformat tag body", this.getReformatBodyProperty());
        this.properties.setProperty("palettePath", "/Mobile/");
        if (this.newLine != null) {
            this.properties.setProperty("new line", this.newLine);
        }
        MobilePaletteInsertHelper.getInstance().insertIntoEditor(this.getDefaultModel().getDropData().getSourceViewer(), this.properties, this);
        this.paletteItem.called();
    }

    @Override
    protected void fillPropertiesForRun(Properties properties) {
        String[] stringArray = PROPERTIES_FOR_RUN;
        int n = PROPERTIES_FOR_RUN.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (this.properties.containsKey(name)) {
                properties.put(name, this.properties.get(name));
            }
            ++n2;
        }
    }

    public void initialize() {
        boolean isWizardEnabled;
        boolean bl = isWizardEnabled = this.getCustomWizardName() != null;
        if (this.getDefaultModel() instanceof PaletteDropWizardModel) {
            ((PaletteDropWizardModel)this.getDefaultModel()).setWizardEnabled(isWizardEnabled);
        }
        this.getDefaultModel().setTagProposal(IDropWizardModel.UNDEFINED_TAG_PROPOSAL);
    }

    @Override
    protected String getReformatBodyProperty() {
        if (this.paletteItem.isReformat()) {
            return "yes";
        }
        return "no";
    }

    protected String getCustomWizardName() {
        if (this.paletteItem.hasWizard()) {
            return "";
        }
        return null;
    }

    protected IDropWizard createDropWizard() {
        IPaletteItemWizard wizard = this.paletteItem.createWizard();
        wizard.setCommand((IDropCommand)this);
        return wizard;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

