/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.format;

import java.util.ArrayList;
import org.eclipse.wst.html.core.internal.format.HTMLElementFormatter;
import org.eclipse.wst.html.core.internal.provisional.HTMLFormatContraints;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLExtendedElementFormatter
extends HTMLElementFormatter {
    protected void formatNode(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        IDOMElement element = (IDOMElement)node;
        String oldStyleValue = null;
        Attr style = element.getAttributeNode("style");
        if (style != null) {
            oldStyleValue = style.getValue();
        }
        super.formatNode(node, contraints);
        if (oldStyleValue != null && oldStyleValue.indexOf("#{") > -1) {
            style.setValue(oldStyleValue);
        }
    }

    protected void formatChildNodes(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null || !node.hasChildNodes()) {
            return;
        }
        ArrayList<Attr> styles = new ArrayList<Attr>();
        ArrayList<String> oldValues = new ArrayList<String>();
        this.collectAllStyleAttributesOfNodeChildren((Node)node, styles, oldValues);
        super.formatChildNodes(node, contraints);
        int i = 0;
        while (i < styles.size()) {
            Attr style = styles.get(i);
            String oldValue = oldValues.get(i);
            style.setNodeValue(oldValue);
            ++i;
        }
    }

    private void collectAllStyleAttributesOfNodeChildren(Node node, ArrayList<Attr> styles, ArrayList<String> oldValues) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String value;
            Attr style;
            Node child = children.item(i);
            if (child instanceof Element && (style = ((Element)child).getAttributeNode("style")) != null && (value = style.getValue()).indexOf("#{") > -1) {
                styles.add(style);
                oldValues.add(value);
            }
            this.collectAllStyleAttributesOfNodeChildren(child, styles, oldValues);
            ++i;
        }
    }
}

