/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.contentassist.computers;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLCMDocument;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.jst.web.kb.IFaceletPageContext;
import org.jboss.tools.jst.web.ui.internal.editor.contentassist.ELPrefixUtils;
import org.jboss.tools.jst.web.ui.internal.editor.contentassist.computers.JspTagCompletionProposalComputer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FaceletsTagCompletionProposalComputer
extends JspTagCompletionProposalComputer {
    private static final String JSFC_ATTRIBUTE_NAME = "jsfc";
    private boolean replaceJsfcTags;
    protected boolean isXHTML = false;

    @Override
    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        try {
            IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)context.getViewer(), (int)context.getInvocationOffset());
            IDOMNode node = (IDOMNode)treeNode;
            boolean isXHTMLNode = FaceletsTagCompletionProposalComputer.isXHTMLNode((Node)node);
            if (this.isXHTML != isXHTMLNode) {
                this.isXHTML = isXHTMLNode;
            }
            List list = super.computeCompletionProposals(context, monitor);
            return list;
        }
        finally {
            this.fCurrentContext = null;
        }
    }

    private static boolean isXHTMLNode(Node node) {
        DocumentType docType;
        if (node == null) {
            return false;
        }
        Document doc = null;
        doc = node.getNodeType() != 9 ? node.getOwnerDocument() : (Document)node;
        if (doc instanceof IDOMDocument) {
            return ((IDOMDocument)doc).isXMLType();
        }
        if (doc instanceof INodeNotifier) {
            ModelQueryAdapter adapter = (ModelQueryAdapter)((INodeNotifier)doc).getAdapterFor(ModelQueryAdapter.class);
            CMDocument cmdoc = null;
            if (adapter != null && adapter.getModelQuery() != null) {
                cmdoc = adapter.getModelQuery().getCorrespondingCMDocument((Node)doc);
            }
            if (cmdoc != null) {
                if (cmdoc instanceof HTMLCMDocument) {
                    return false;
                }
                if (cmdoc.supports("isXHTML")) {
                    return Boolean.TRUE.equals(cmdoc.getProperty("isXHTML"));
                }
            }
        }
        return (docType = doc.getDoctype()) != null && docType.getPublicId() != null && docType.getPublicId().indexOf("-//W3C//DTD XHTML ") == 0;
    }

    @Override
    protected ELContext createContext() {
        return this.createContext("FACELETS_PAGE_CONTEXT_TYPE");
    }

    public IFaceletPageContext getContext() {
        return (IFaceletPageContext)super.getContext();
    }

    @Override
    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition, CompletionProposalInvocationContext context) {
        ELPrefixUtils.ELTextRegion prefix = this.getELPrefix(contentAssistRequest);
        if (prefix != null && prefix.isELStarted()) {
            return;
        }
        ITextViewer textViewer = context.getViewer();
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)context.getInvocationOffset());
        Node node = (Node)treeNode;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode xmlnode = (IDOMNode)node;
        ITextRegion completionRegion = this.getCompletionRegion(context.getInvocationOffset(), node);
        String regionType = completionRegion.getType();
        if (regionType == "XML_END_TAG_OPEN" && xmlnode != null && xmlnode.getNodeName() != null && xmlnode.getNodeName().equalsIgnoreCase("style")) {
            return;
        }
        this.addTagNameProposals(contentAssistRequest, childPosition, true, context);
    }

    @Override
    protected void addTextELProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
    }

    @Override
    protected void addAttributeNameProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        if (!(contentAssistRequest.getNode() instanceof Element)) {
            return;
        }
        super.addAttributeNameProposals(contentAssistRequest, context);
        if (this.isExistingAttribute(JSFC_ATTRIBUTE_NAME)) {
            this.replaceJsfcTags = true;
            super.addAttributeNameProposals(contentAssistRequest, context);
            this.replaceJsfcTags = false;
        }
    }

    @Override
    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        super.addAttributeValueProposals(contentAssistRequest, context);
        if (this.isExistingAttribute(JSFC_ATTRIBUTE_NAME)) {
            this.replaceJsfcTags = true;
            super.addAttributeValueProposals(contentAssistRequest, context);
            this.replaceJsfcTags = false;
        }
    }

    @Override
    protected String getTagName(Node tag) {
        String tagName = tag.getNodeName();
        if (this.replaceJsfcTags) {
            if (tagName.indexOf(58) > 0) {
                return tagName;
            }
            if (!(tag instanceof Element)) {
                return tagName;
            }
            Element element = (Element)tag;
            NamedNodeMap attributes = element.getAttributes();
            Node jsfC = attributes.getNamedItem(JSFC_ATTRIBUTE_NAME);
            if (jsfC == null || !(jsfC instanceof Attr)) {
                return tagName;
            }
            Attr jsfCAttribute = (Attr)jsfC;
            String jsfTagName = jsfCAttribute.getValue();
            if (jsfTagName == null || jsfTagName.indexOf(58) < 1) {
                return tagName;
            }
            tagName = jsfTagName;
        }
        return tagName;
    }
}

