/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog.selector;

import java.util.ArrayList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.css.core.internal.modelhandler.CSSModelLoader;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.css.ui.StructuredTextViewerConfigurationCSS;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSRuleContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.selection.CSSClassSelectionChangedEvent;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.selection.ICSSClassSelectionChangedListener;
import org.w3c.dom.css.CSSRuleList;

public class CSSSelectorPreview
extends Composite
implements ICSSClassSelectionChangedListener,
IElementComparer {
    private ISelection prevSelection;
    private StructuredTextViewer viewer;
    private ICSSModel model;
    private ICSSStyleSheet styleSheet;

    public CSSSelectorPreview(Composite parent) {
        super(parent, 2048);
        this.setLayout((Layout)new FillLayout());
        this.initPreview();
    }

    private void initPreview() {
        StructuredTextViewerConfigurationCSS baseConfiguration = new StructuredTextViewerConfigurationCSS();
        this.viewer = new StructuredTextViewer((Composite)this, null, null, false, 2816);
        this.viewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
        this.viewer.configure((SourceViewerConfiguration)baseConfiguration);
        CSSModelLoader cssModelLoader = new CSSModelLoader();
        IStructuredModel model = cssModelLoader.createModel();
        this.model = (ICSSModel)model;
        this.styleSheet = (ICSSStyleSheet)this.model.getDocument();
        this.viewer.setDocument((IDocument)model.getStructuredDocument());
        this.viewer.setEditable(false);
    }

    @Override
    public void classSelectionChanged(CSSClassSelectionChangedEvent event) {
        CSSRuleContainer[] containers = event.getSelectedRuleContainers();
        if (containers.length != 0) {
            int i;
            ArrayList<CSSRuleContainer> ruleContainerList = new ArrayList<CSSRuleContainer>(0);
            int i2 = 0;
            while (i2 < containers.length) {
                ruleContainerList.add(containers[i2]);
                ++i2;
            }
            StructuredSelection newSelection = new StructuredSelection(ruleContainerList, (IElementComparer)this);
            if (this.prevSelection == null) {
                this.prevSelection = new StructuredSelection(ruleContainerList, (IElementComparer)this);
                this.clearPreview();
                i = 0;
                while (i < containers.length) {
                    this.appendRuleFromContainer(containers[i]);
                    ++i;
                }
            }
            if (!this.prevSelection.equals(newSelection)) {
                this.clearPreview();
                i = 0;
                while (i < containers.length) {
                    this.appendRuleFromContainer(containers[i]);
                    ++i;
                }
                this.prevSelection = newSelection;
            }
        }
    }

    private void appendRuleFromContainer(CSSRuleContainer container) {
        StringBuilder builder = new StringBuilder("");
        ICSSStyleRule rule = (ICSSStyleRule)container.getRule();
        String text = rule.getCssText();
        String styleDef = text.substring(text.indexOf(123));
        builder.append("." + container.getSelectorName() + styleDef);
        this.styleSheet.appendRule(this.styleSheet.createCSSRule(builder.toString()));
    }

    private void clearPreview() {
        CSSRuleList ruleList = this.styleSheet.getCssRules();
        int i = 0;
        while (i < ruleList.getLength()) {
            this.styleSheet.removeRule(ruleList.item(i));
            ++i;
        }
    }

    public boolean equals(Object a, Object b) {
        return a.equals(b);
    }

    public int hashCode(Object element) {
        return 0;
    }
}

