/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.handlers;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jboss.tools.runtime.core.JBossRuntimeLocator;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.internal.RuntimeDetector;
import org.jboss.tools.runtime.core.model.AbstractRuntimeDetectorDelegate;
import org.jboss.tools.runtime.core.model.IRuntimeDetector;
import org.jboss.tools.runtime.core.model.IRuntimeDetectorDelegate;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.util.RuntimeJarUtil;
import org.jboss.tools.seam.core.SeamUtil;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.core.project.facet.SeamVersion;

public class SeamHandler
extends AbstractRuntimeDetectorDelegate {
    private static final String seamJarName = "jboss-seam.jar";
    private static final String seamVersionAttributeName = "Seam-Version";
    private static final String SEAM = "SEAM";

    private static File getSeamRoot(RuntimeDefinition runtimeDefinition) {
        String type = runtimeDefinition.getType();
        if (SEAM.equals(type)) {
            return runtimeDefinition.getLocation();
        }
        return null;
    }

    public void initializeRuntimes(List<RuntimeDefinition> runtimeDefinitions) {
        HashMap<String, SeamRuntime> map = new HashMap<String, SeamRuntime>();
        for (RuntimeDefinition runtimeDefinition : runtimeDefinitions) {
            String type;
            if (runtimeDefinition.isEnabled() && SEAM.equals(type = runtimeDefinition.getType())) {
                SeamHandler.addSeam(map, runtimeDefinition, runtimeDefinition.getLocation());
            }
            this.initializeRuntimes(runtimeDefinition.getIncludedRuntimeDefinitions());
        }
        SeamRuntimeManager.getInstance().save();
    }

    private static void addSeam(Map<String, SeamRuntime> map, RuntimeDefinition runtimeDefinition, File seamFile) {
        SeamVersion seamVersion;
        if (seamFile.exists() && seamFile.canRead() && seamFile.isDirectory() && (seamVersion = SeamHandler.getSeamVersion(seamFile.getAbsolutePath())) != null) {
            String name = "Seam " + runtimeDefinition.getName() + " " + seamVersion;
            List names = SeamRuntimeManager.getInstance().getAllRuntimeNames();
            if (names != null && names.size() > 0) {
                int i = 2;
                String baseName = "Seam " + runtimeDefinition.getName();
                while (names.contains(name)) {
                    name = String.valueOf(baseName) + " (" + i++ + ") " + seamVersion;
                }
            }
            SeamHandler.addSeam(map, seamFile.getAbsolutePath(), seamVersion, name);
        }
    }

    private static void addSeam(Map<String, SeamRuntime> map, String seamPath, SeamVersion seamVersion, String name) {
        File seamFolder;
        if (!SeamHandler.seamExists(seamPath) && (seamFolder = new File(seamPath)).exists() && seamFolder.isDirectory()) {
            SeamRuntime rt = new SeamRuntime();
            rt.setHomeDir(seamPath);
            rt.setName(name);
            rt.setDefault(true);
            rt.setVersion(seamVersion);
            SeamRuntimeManager.getInstance().addRuntime(rt);
        }
    }

    private static SeamVersion getSeamVersion(String seamGenBuildPath) {
        if (seamGenBuildPath == null || seamGenBuildPath.trim().length() <= 0) {
            return null;
        }
        String fullVersion = SeamUtil.getSeamVersionFromManifest((String)seamGenBuildPath);
        if (fullVersion == null) {
            return null;
        }
        String version = fullVersion.substring(0, 3);
        SeamVersion seamVersion = null;
        if (version != null) {
            seamVersion = SeamVersion.findByString((String)version);
        }
        return seamVersion;
    }

    private static boolean seamExists(String seamPath) {
        SeamRuntime[] seamRuntimes;
        SeamRuntime[] seamRuntimeArray = seamRuntimes = SeamRuntimeManager.getInstance().getRuntimes();
        int n = seamRuntimes.length;
        int n2 = 0;
        while (n2 < n) {
            SeamRuntime sr = seamRuntimeArray[n2];
            if (seamPath != null && seamPath.equals(sr.getHomeDir())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public RuntimeDefinition getRuntimeDefinition(File root, IProgressMonitor monitor) {
        if (monitor.isCanceled() || root == null) {
            return null;
        }
        String seamVersion = SeamHandler.getSeamVersionFromManifest(root.getAbsolutePath());
        if (seamVersion != null) {
            return new RuntimeDefinition(root.getName(), seamVersion, SEAM, root.getAbsoluteFile());
        }
        return null;
    }

    private static String getSeamVersionFromManifest(String seamHome) {
        File seamHomeFolder = new File(seamHome);
        if (seamHomeFolder == null || !seamHomeFolder.isDirectory()) {
            return null;
        }
        String[] seamFiles = seamHomeFolder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if ("seam-gen".equals(name)) {
                    return true;
                }
                return "lib".equals(name);
            }
        });
        if (seamFiles == null || seamFiles.length != 2) {
            return null;
        }
        File jarFile = new File(seamHome, "lib/jboss-seam.jar");
        if (!jarFile.isFile() && !(jarFile = new File(seamHome, seamJarName)).isFile()) {
            return null;
        }
        String[] attributes = new String[]{seamVersionAttributeName, RuntimeJarUtil.IMPLEMENTATION_VERSION};
        return RuntimeJarUtil.getImplementationVersion((File)jarFile, (String[])attributes);
    }

    public boolean exists(RuntimeDefinition runtimeDefinition) {
        if (runtimeDefinition == null || runtimeDefinition.getLocation() == null) {
            return false;
        }
        File seamRoot = SeamHandler.getSeamRoot(runtimeDefinition);
        if (seamRoot == null || !seamRoot.isDirectory()) {
            return false;
        }
        String path = seamRoot.getAbsolutePath();
        return SeamHandler.seamExists(path);
    }

    private static File getLocation(RuntimeDefinition runtimeDefinitions) {
        String type = runtimeDefinitions.getType();
        String version = runtimeDefinitions.getVersion();
        if ("EAP".equals(type) && version != null && version.startsWith("6")) {
            return runtimeDefinitions.getLocation();
        }
        if ("SOA_P".equals(type) || "EAP".equals(type) || "EPP".equals(type)) {
            return new File(runtimeDefinitions.getLocation(), "jboss-as");
        }
        if ("SOA_P_STD".equals(type)) {
            return new File(runtimeDefinitions.getLocation(), "jboss-esb");
        }
        if ("EWP".equals(type)) {
            return new File(runtimeDefinitions.getLocation(), "jboss-as-web");
        }
        if ("AS".equals(type) || "EAP_STD".equals(type)) {
            return runtimeDefinitions.getLocation();
        }
        return null;
    }

    public void computeIncludedRuntimeDefinition(RuntimeDefinition runtimeDefinition) {
        runtimeDefinition.getIncludedRuntimeDefinitions().clear();
        List runtimeDefinitions = runtimeDefinition.getIncludedRuntimeDefinitions();
        final File location = SeamHandler.getLocation(runtimeDefinition);
        File[] directories = runtimeDefinition.getLocation().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !file.equals(location);
            }
        });
        ArrayList definitions = new ArrayList();
        JBossRuntimeLocator locator = new JBossRuntimeLocator();
        HashSet<IRuntimeDetector> seamDetectors = new HashSet<IRuntimeDetector>();
        Set runtimeDetectors = RuntimeCoreActivator.getDefault().getRuntimeDetectors();
        for (IRuntimeDetector runtimeDetector : runtimeDetectors) {
            IRuntimeDetectorDelegate delegate;
            if (!(runtimeDetector instanceof RuntimeDetector) || !((delegate = ((RuntimeDetector)runtimeDetector).getDelegate()) instanceof SeamHandler)) continue;
            seamDetectors.add(runtimeDetector);
            break;
        }
        File[] fileArray = directories;
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            File directory = fileArray[n2];
            locator.searchDirectory(directory, definitions, 1, seamDetectors, (IProgressMonitor)new NullProgressMonitor());
            for (RuntimeDefinition definition : definitions) {
                definition.setParent(runtimeDefinition);
            }
            ++n2;
        }
        for (RuntimeDefinition definition : definitions) {
            if (runtimeDefinitions.contains(definition)) continue;
            runtimeDefinitions.add(definition);
        }
    }

    public String getVersion(RuntimeDefinition runtimeDefinition) {
        return runtimeDefinition.getVersion();
    }
}

