/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.editor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dadacoalition.yedit.YEditLog;
import org.dadacoalition.yedit.editor.scanner.YAMLScanner;
import org.dadacoalition.yedit.editor.scanner.YAMLToken;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class SymfonyCompatibilityMode {
    private YAMLScanner scanner;
    private Pattern replaceCharPattern = Pattern.compile("% | \\{ | \\} | \\[ | \\] | \\?", 4);

    public SymfonyCompatibilityMode(YAMLScanner scanner) {
        this.scanner = scanner;
    }

    public String fixScalars(IDocument document) {
        int rangeLength = document.getLength();
        this.scanner.setRange(document, 0, rangeLength);
        String replacedContent = "";
        IToken token = this.scanner.nextToken();
        while (token != Token.EOF) {
            try {
                YAMLToken yt;
                String tokenString = document.get(this.scanner.getTokenOffset(), this.scanner.getTokenLength());
                if (token instanceof YAMLToken && (yt = (YAMLToken)token).getTokenType() == YAMLToken.SCALAR && !this.startsWithQuote(tokenString)) {
                    YEditLog.logger.info("Replacing characters in string " + tokenString);
                    Matcher m = this.replaceCharPattern.matcher(tokenString);
                    tokenString = m.replaceAll("_");
                }
                replacedContent = String.valueOf(replacedContent) + tokenString;
            }
            catch (BadLocationException e) {
                YEditLog.logException(e, "Replacing special chars in unquoted scalars failed");
                return document.get();
            }
            int newOffset = this.scanner.getTokenOffset() + this.scanner.getTokenLength();
            this.scanner.setRange(document, newOffset, rangeLength -= this.scanner.getTokenLength());
            token = this.scanner.nextToken();
        }
        return replacedContent;
    }

    protected boolean startsWithQuote(String s) {
        return s.charAt(0) == '\'' || s.charAt(0) == '\"';
    }
}

