/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SourceEditorService;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.WithPart;

public final class ShowInSourceActionAssistContributor
extends PropertyEditorAssistContributor {
    @Text(value="Show in source")
    private static LocalizableText action;

    static {
        LocalizableText.init(ShowInSourceActionAssistContributor.class);
    }

    public ShowInSourceActionAssistContributor() {
        this.setId("System.ShowInSourceActionContributor");
        this.setPriority(320);
    }

    @Override
    public void contribute(PropertyEditorAssistContext context) {
        SapphirePart part = context.getPart();
        ElementHandle<?> property0 = null;
        if (part instanceof PropertyEditorPart) {
            property0 = ((PropertyEditorPart)part).property();
        } else if (part instanceof WithPart) {
            property0 = ((WithPart)part).property();
        }
        final Element element = part.getLocalModelElement();
        final SourceEditorService sourceEditorService = (SourceEditorService)element.adapt(SourceEditorService.class);
        if (sourceEditorService == null) {
            return;
        }
        boolean contribute = false;
        if (property0 == null) {
            contribute = true;
        } else if (!property0.definition().isDerived()) {
            boolean bl = contribute = !property0.empty();
        }
        if (!contribute) {
            return;
        }
        ElementHandle<?> property = property0;
        PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
        contribution.text("<p><a href=\"action\" nowrap=\"true\">" + ShowInSourceActionAssistContributor.escapeForXml(action.text()) + "</a></p>");
        contribution.link("action", new Runnable((Property)property){
            private final /* synthetic */ Property val$property;
            {
                this.val$property = property;
            }

            @Override
            public void run() {
                sourceEditorService.show(element, this.val$property != null ? this.val$property.definition() : null);
            }
        });
        PropertyEditorAssistSection section = context.getSection("actions");
        section.addContribution(contribution.create());
    }
}

