/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionManagerListener;
import org.eclipse.linuxtools.docker.core.IDockerConnectionManagerListener2;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettingsFinder;
import org.eclipse.linuxtools.docker.core.IDockerConnectionStorageManager;
import org.eclipse.linuxtools.internal.docker.core.DefaultDockerConnectionSettingsFinder;
import org.eclipse.linuxtools.internal.docker.core.DefaultDockerConnectionStorageManager;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerRefreshManager;

public class DockerConnectionManager {
    @Deprecated
    public static final String CONNECTIONS_FILE_NAME = "dockerconnections.xml";
    private static DockerConnectionManager instance;
    private List<IDockerConnection> connections;
    private ListenerList connectionManagerListeners;
    private IDockerConnectionSettingsFinder connectionSettingsFinder = new DefaultDockerConnectionSettingsFinder();
    private IDockerConnectionStorageManager connectionStorageManager = new DefaultDockerConnectionStorageManager();

    public static DockerConnectionManager getInstance() {
        if (instance == null) {
            instance = new DockerConnectionManager();
        }
        return instance;
    }

    private DockerConnectionManager() {
        this.reloadConnections();
    }

    public void reloadConnections() {
        this.connections = this.connectionStorageManager.loadConnections();
        for (IDockerConnection connection : this.connections) {
            try {
                connection.open(true);
                this.notifyListeners(connection, 0);
            }
            catch (DockerException e) {
                Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.core", e.getMessage()));
            }
        }
    }

    public void setConnectionSettingsFinder(IDockerConnectionSettingsFinder connectionSettingsFinder) {
        this.connectionSettingsFinder = connectionSettingsFinder;
    }

    public void setConnectionStorageManager(IDockerConnectionStorageManager connectionStorageManager) {
        this.connectionStorageManager = connectionStorageManager;
    }

    public void saveConnections() {
        this.connectionStorageManager.saveConnections(this.connections);
    }

    public IDockerConnection[] getConnections() {
        return this.connections.toArray(new IDockerConnection[this.connections.size()]);
    }

    public List<String> getConnectionNames() {
        ArrayList<String> connectionNames = new ArrayList<String>();
        for (IDockerConnection connection : this.connections) {
            connectionNames.add(connection.getName());
        }
        return Collections.unmodifiableList(connectionNames);
    }

    public IDockerConnection findConnection(String name) {
        if (name != null) {
            for (IDockerConnection connection : this.connections) {
                if (!connection.getName().equals(name)) continue;
                return connection;
            }
        }
        return null;
    }

    public void addConnection(IDockerConnection dockerConnection) throws DockerException {
        if (!dockerConnection.isOpen()) {
            dockerConnection.open(true);
        }
        this.connections.add(dockerConnection);
        this.saveConnections();
        this.notifyListeners(dockerConnection, 0);
    }

    public void removeConnection(IDockerConnection connection) {
        this.connections.remove(connection);
        this.saveConnections();
        this.notifyListeners(connection, 1);
        DockerContainerRefreshManager.getInstance().removeContainerRefreshThread(connection);
    }

    public void notifyConnectionRename() {
        this.saveConnections();
        this.notifyListeners(2);
    }

    public void addConnectionManagerListener(IDockerConnectionManagerListener listener) {
        if (this.connectionManagerListeners == null) {
            this.connectionManagerListeners = new ListenerList(1);
        }
        this.connectionManagerListeners.add((Object)listener);
    }

    public void removeConnectionManagerListener(IDockerConnectionManagerListener listener) {
        if (this.connectionManagerListeners != null) {
            this.connectionManagerListeners.remove((Object)listener);
        }
    }

    @Deprecated
    public void notifyListeners(int type) {
        if (this.connectionManagerListeners != null) {
            Object[] listeners = this.connectionManagerListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IDockerConnectionManagerListener)listeners[i]).changeEvent(type);
                ++i;
            }
        }
    }

    public void notifyListeners(IDockerConnection connection, int type) {
        if (this.connectionManagerListeners != null) {
            Object[] listeners = this.connectionManagerListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] instanceof IDockerConnectionManagerListener2) {
                    ((IDockerConnectionManagerListener2)listeners[i]).changeEvent(connection, type);
                } else {
                    ((IDockerConnectionManagerListener)listeners[i]).changeEvent(type);
                }
                ++i;
            }
        }
    }

    public List<IDockerConnectionSettings> findConnectionSettings() {
        return this.connectionSettingsFinder.findConnectionSettings();
    }
}

