/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.core.transform;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.activation.MimetypesFileTypeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.vpe.preview.core.Activator;
import org.jboss.tools.vpe.preview.core.transform.DomUtil;
import org.jboss.tools.vpe.preview.core.transform.ResourceAcceptor;
import org.jboss.tools.vpe.preview.core.transform.VpvDomBuilder;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModel;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModelHolder;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModelHolderRegistry;
import org.w3c.dom.Document;

public class VpvController {
    private VpvDomBuilder domBuilder;
    private VpvVisualModelHolderRegistry visualModelHolderRegistry;

    public VpvController(VpvDomBuilder domBuilder, VpvVisualModelHolderRegistry visualModelHolderRegistry) {
        this.domBuilder = domBuilder;
        this.visualModelHolderRegistry = visualModelHolderRegistry;
    }

    public synchronized void getResource(String path, Integer viewId, ResourceAcceptor resourceAcceptor) {
        VpvVisualModelHolder visualModelHolder;
        VpvVisualModel visualModel;
        IFile requestedFile;
        Path workspacePath;
        block19: {
            workspacePath = new Path(path);
            requestedFile = null;
            visualModel = null;
            IStructuredModel sourceModel = null;
            try {
                requestedFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)workspacePath);
                sourceModel = VpvController.getSourceModel(requestedFile);
                visualModel = this.getVisualModel(sourceModel);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                resourceAcceptor.acceptError();
                if (sourceModel != null) {
                    sourceModel.releaseFromRead();
                }
                break block19;
            }
            catch (Exception e) {
                try {
                    Activator.logError(e);
                    break block19;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (sourceModel != null) {
                        sourceModel.releaseFromRead();
                    }
                }
            }
            if (sourceModel == null) break block19;
            sourceModel.releaseFromRead();
        }
        if ((visualModelHolder = this.visualModelHolderRegistry.getHolderById(viewId)) != null) {
            visualModelHolder.setVisualModel(visualModel);
        }
        String htmlText = null;
        if (visualModel != null && visualModelHolder != null) {
            try {
                htmlText = DomUtil.nodeToString(visualModel.getVisualDocument());
            }
            catch (TransformerException e) {
                Activator.logError(e);
            }
        }
        if (htmlText != null) {
            resourceAcceptor.acceptText("<!DOCTYPE html>\n" + htmlText, "text/html");
        } else if (requestedFile != null && requestedFile.exists()) {
            this.acceptFile(requestedFile, resourceAcceptor);
        } else if (workspacePath.isAbsolute() && workspacePath.toFile().exists()) {
            this.acceptFile(workspacePath, resourceAcceptor);
        } else {
            resourceAcceptor.acceptError();
        }
    }

    private void acceptFile(IFile requestedFile, ResourceAcceptor resourceAcceptor) {
        File file;
        IPath location = requestedFile.getLocation();
        if (location != null && (file = location.toFile()) != null && file.exists()) {
            String mimeType = VpvController.getMimeType(file);
            resourceAcceptor.acceptFile(file, mimeType);
        }
    }

    private void acceptFile(Path workspacePath, ResourceAcceptor resourceAcceptor) {
        File file = workspacePath.toFile();
        String mimeType = VpvController.getMimeType(file);
        resourceAcceptor.acceptFile(file, mimeType);
    }

    private static IStructuredModel getSourceModel(IFile requestedFile) throws CoreException {
        IStructuredModel sourceModel = StructuredModelManager.getModelManager().getExistingModelForRead(requestedFile);
        if (sourceModel == null) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer buffer = null;
            IFileStore fileStore = EFS.getStore((URI)requestedFile.getFullPath().toFile().toURI());
            bufferManager.connectFileStore(fileStore, (IProgressMonitor)new NullProgressMonitor());
            buffer = bufferManager.getFileStoreTextFileBuffer(fileStore);
            IDocument document = buffer.getDocument();
            if (document instanceof IStructuredDocument) {
                IModelManager modelManager = StructuredModelManager.getModelManager();
                sourceModel = modelManager.getModelForRead((IStructuredDocument)document);
            }
        }
        return sourceModel;
    }

    private VpvVisualModel getVisualModel(IStructuredModel sourceModel) {
        IDOMDocument sourceDocument = null;
        if (sourceModel instanceof IDOMModel) {
            IDOMModel sourceDomModel = (IDOMModel)sourceModel;
            sourceDocument = sourceDomModel.getDocument();
        }
        if (sourceDocument != null) {
            try {
                return this.domBuilder.buildVisualModel((Document)sourceDocument);
            }
            catch (ParserConfigurationException e) {
                Activator.logError(e);
            }
        }
        return null;
    }

    private static String getMimeType(File file) {
        try {
            MimetypesFileTypeMap mimeTypes = new MimetypesFileTypeMap(Activator.getFileUrl("lib/mime.types").openStream());
            return mimeTypes.getContentType(file);
        }
        catch (IOException e) {
            Activator.logError(e);
            return "application/octet-stream";
        }
    }
}

