/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.server.jetty;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.jboss.tools.livereload.core.internal.server.jetty.LiveReloadWebSocket;
import org.jboss.tools.livereload.core.internal.server.jetty.LiveReloadWebSocketCreator;

@WebServlet(name="Livereload WebSocker Servlet", urlPatterns={"/livereload"})
public class LiveReloadWebSocketServlet
extends WebSocketServlet {
    private static final long serialVersionUID = 2515781694370015615L;
    private final List<LiveReloadWebSocket> webSockets = new ArrayList<LiveReloadWebSocket>();

    public void init() throws ServletException {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        ClassLoader jettyClassLoader = WebSocketServerFactory.class.getClassLoader();
        Thread.currentThread().setContextClassLoader(jettyClassLoader);
        super.init();
        Thread.currentThread().setContextClassLoader(ccl);
    }

    public void configure(WebSocketServletFactory factory) {
        factory.setCreator((WebSocketCreator)new LiveReloadWebSocketCreator());
    }

    public void destroy() {
        super.destroy();
        for (LiveReloadWebSocket webSocket : this.webSockets) {
            webSocket.destroy();
        }
        this.webSockets.clear();
    }
}

