/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.refactoring.jdt;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;

public abstract class AbstractMoveRefactoringParticipant
extends MoveParticipant
implements ISharableParticipant {
    protected IProject project;
    protected List<Object> elements;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        this.elements.add(element);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.getArguments().getUpdateReferences()) {
            return null;
        }
        HashSet<IResource> processedResources = new HashSet<IResource>();
        CompositeChange result = new CompositeChange(this.getName());
        Set projects = BeansCorePlugin.getModel().getProjects();
        for (IBeansProject beansProject : projects) {
            Set beansConfigs = beansProject.getConfigs();
            for (IBeansConfig beansConfig : beansConfigs) {
                if (!processedResources.contains(beansConfig.getElementResource())) {
                    this.addChange(result, beansConfig.getElementResource(), pm);
                    processedResources.add(beansConfig.getElementResource());
                }
                for (IBeansImport import_ : beansConfig.getImports()) {
                    for (IBeansConfig config : import_.getImportedBeansConfigs()) {
                        if (processedResources.contains(config.getElementResource())) continue;
                        this.addChange(result, config.getElementResource(), pm);
                        processedResources.add(config.getElementResource());
                    }
                }
            }
        }
        return result.getChildren().length == 0 ? null : result;
    }

    protected abstract void addChange(CompositeChange var1, IResource var2, IProgressMonitor var3) throws CoreException;
}

