/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.guides;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.UIConstants;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public class DescriptionSection
extends WizardPageSection {
    private final LiveExpression<String> model;
    private String label;
    private boolean isReadOnly = true;

    public DescriptionSection(IPageWithSections owner, LiveExpression<String> description) {
        super(owner);
        this.model = description;
    }

    public DescriptionSection readOnly(boolean isReadOnly) {
        Assert.isTrue((!isReadOnly || this.model instanceof LiveVariable ? 1 : 0) != 0, (String)"The model does not support editing");
        this.isReadOnly = isReadOnly;
        return this;
    }

    public LiveExpression<ValidationResult> getValidator() {
        return Validator.OK;
    }

    public void createContents(Composite page) {
        Composite composite;
        if (this.label != null) {
            composite = new Composite(page, 0);
            GridLayout layout = GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).create();
            composite.setLayout((Layout)layout);
            Label fieldNameLabel = new Label(composite, 0);
            fieldNameLabel.setText(this.label);
            GridDataFactory.fillDefaults().align(1, 1).hint(UIConstants.fieldLabelWidthHint((Control)fieldNameLabel), -1).applyTo((Control)fieldNameLabel);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        } else {
            composite = page;
        }
        int swtStyle = 2882;
        if (this.isReadOnly) {
            swtStyle |= 8;
        }
        final Text text = new Text(composite, swtStyle);
        if (!this.isReadOnly) {
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ((LiveVariable)DescriptionSection.this.model).setValue((Object)text.getText());
                }
            });
        }
        GC gc = new GC((Drawable)text);
        FontMetrics fm = gc.getFontMetrics();
        int preferredHeight = fm.getHeight() * 5;
        GridData data = new GridData(768);
        data.heightHint = preferredHeight;
        data.widthHint = 250;
        text.setLayoutData((Object)data);
        this.model.addListener((ValueListener)new ValueListener<String>(){

            public void gotValue(LiveExpression<String> exp, String value) {
                String oldText = text.getText();
                if (!oldText.equals(value)) {
                    text.setText(value);
                }
            }
        });
    }

    public DescriptionSection label(String label) {
        this.label = label;
        return this;
    }
}

