/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.github;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.http.ResponseEntity;
import org.springframework.ide.eclipse.wizard.gettingstarted.github.Repo;
import org.springframework.ide.eclipse.wizard.gettingstarted.github.auth.BasicAuthCredentials;
import org.springframework.ide.eclipse.wizard.gettingstarted.github.auth.Credentials;
import org.springframework.ide.eclipse.wizard.gettingstarted.github.auth.NullCredentials;
import org.springframework.ide.eclipse.wizard.gettingstarted.util.Spring3MappingJacksonHttpMessageConverter;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springsource.ide.eclipse.commons.frameworks.core.util.IOUtil;
import org.springsource.ide.eclipse.commons.gettingstarted.GettingStartedActivator;

public class GithubClient {
    private static final Pattern GITHUB_HOST = Pattern.compile("(.*\\.|)github\\.com");
    private static final int CONNECT_TIMEOUT = 10000;
    private static final boolean DEBUG = false;
    private static final boolean LOG_GITHUB_RATE_LIMIT = false;
    private final Credentials credentials;
    private final RestTemplate client;

    public GithubClient() {
        this(GithubClient.createDefaultCredentials());
    }

    public GithubClient(Credentials c) {
        this.credentials = c;
        this.client = this.createRestTemplate();
    }

    public static Credentials createDefaultCredentials() {
        String username = System.getProperty("github.user.name");
        String password = System.getProperty("github.user.password");
        if (username != null && password != null) {
            return new BasicAuthCredentials(GITHUB_HOST, username, password);
        }
        return new NullCredentials();
    }

    private String addHost(String path) {
        if (path.startsWith("http")) {
            return path;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return "https://api.github.com" + path;
    }

    public Repo[] getOrgRepos(String orgName) {
        return this.get("/orgs/{orgName}/repos", Repo[].class, orgName);
    }

    public Repo[] getUserRepos(String userName) {
        return this.get("/users/{userName}/repos", Repo[].class, userName);
    }

    public Repo[] getMyRepos() {
        try {
            return this.get("/user/repos", Repo[].class, new Object[0]);
        }
        catch (Throwable e) {
            GettingStartedActivator.log((Throwable)e);
            return new Repo[0];
        }
    }

    public Repo getRepo(String owner, String repo) {
        return this.get("/repos/{owner}/{repo}", Repo.class, owner, repo);
    }

    public <T> T get(String url, Class<T> type, Object ... vars) {
        url = this.addHost(url);
        if (type.isArray()) {
            ResponseEntity entity;
            Class<?> componentType = type.getComponentType();
            ArrayList<Object> results = new ArrayList<Object>();
            do {
                Object[] pageResults;
                entity = this.client.getForEntity(url, type, vars);
                Object[] objectArray = pageResults = (Object[])entity.getBody();
                int n = pageResults.length;
                int n2 = 0;
                while (n2 < n) {
                    Object r = objectArray[n2];
                    results.add(r);
                    ++n2;
                }
            } while ((url = GithubClient.getNextPageUrl(entity)) != null);
            return (T)results.toArray((Object[])Array.newInstance(componentType, results.size()));
        }
        try {
            return (T)this.client.getForObject(url, type, vars);
        }
        catch (HttpServerErrorException httpServerErrorException) {
            throw new Error("Error reading: " + url);
        }
    }

    private static <T> String getNextPageUrl(ResponseEntity<T> entity) {
        List linkHeader = entity.getHeaders().get((Object)"Link");
        if (linkHeader != null) {
            Pattern nextPat = Pattern.compile("<([^<]*)>;\\s*rel=\"next\"");
            for (String string : linkHeader) {
                System.out.println(string);
                Matcher m = nextPat.matcher(string);
                if (!m.find()) continue;
                return m.group(1);
            }
        }
        return null;
    }

    protected static String getNormalisedProtocol(String protocol) {
        return protocol.toUpperCase();
    }

    private RestTemplate createRestTemplate() {
        RestTemplate rest = new RestTemplate();
        rest = this.credentials.apply(rest);
        ArrayList<Spring3MappingJacksonHttpMessageConverter> messageConverters = new ArrayList<Spring3MappingJacksonHttpMessageConverter>();
        messageConverters.add(new Spring3MappingJacksonHttpMessageConverter());
        rest.setMessageConverters(messageConverters);
        return rest;
    }

    public void fetch(URL url, OutputStream writeTo) throws IOException {
        URLConnection conn = null;
        InputStream input = null;
        try {
            conn = url.openConnection();
            conn.setConnectTimeout(10000);
            this.credentials.apply(conn);
            conn.connect();
            input = conn.getInputStream();
            IOUtil.pipe((InputStream)input, (OutputStream)writeTo);
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void main(String[] args) {
        GithubClient gh = new GithubClient();
        int i = 0;
        while (i < 5) {
            Repo[] repos = gh.getOrgRepos("spring-guides");
            System.out.println(repos.length);
            ++i;
        }
    }
}

