/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java;

import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.PrefixMethodNameFilter;

public class ParameterMethodFilter
extends PrefixMethodNameFilter {
    private final String[] parameterTypes;
    private final String returnType;
    private final int parameterCount;

    public ParameterMethodFilter() {
        this.parameterTypes = null;
        this.returnType = null;
        this.parameterCount = -1;
    }

    public ParameterMethodFilter(String[] parameterTypes) {
        this.parameterTypes = parameterTypes;
        this.returnType = null;
        this.parameterCount = parameterTypes.length;
    }

    public ParameterMethodFilter(String returnType, String[] parameterTypes) {
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.parameterCount = parameterTypes.length;
    }

    public ParameterMethodFilter(String returnType) {
        this.parameterTypes = null;
        this.returnType = returnType;
        this.parameterCount = -1;
    }

    public ParameterMethodFilter(int parameterCount) {
        this.parameterTypes = null;
        this.returnType = null;
        this.parameterCount = parameterCount;
    }

    public ParameterMethodFilter(String returnType, int parameterCount) {
        this.parameterTypes = null;
        this.returnType = returnType;
        this.parameterCount = parameterCount;
    }

    @Override
    public boolean matches(IMethod method, String prefix) {
        return super.matchesMethodPrefix(method, prefix) && this.matchParamterCount(method) && this.matchParameterTypes(method) && this.matchReturnType(method);
    }

    private boolean matchReturnType(IMethod method) {
        IType type;
        IType mReturnType;
        return this.returnType == null || (mReturnType = JdtUtils.getJavaTypeForMethodReturnType(method, type = (IType)method.getParent())) != null && this.returnType.equals(mReturnType.getFullyQualifiedName());
    }

    private boolean matchParameterTypes(IMethod method) {
        if (this.parameterTypes != null) {
            IType type = (IType)method.getParent();
            List<IType> mParameterTypes = JdtUtils.getJavaTypesForMethodParameterTypes(method, type);
            if (this.parameterCount != mParameterTypes.size()) {
                return false;
            }
            int i = 0;
            while (i < mParameterTypes.size()) {
                if (mParameterTypes.get(i) == null || !this.parameterTypes[i].equals(mParameterTypes.get(i).getFullyQualifiedName())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean matchParamterCount(IMethod method) {
        try {
            return this.parameterCount == -1 && this.parameterTypes == null || method.getParameterNames().length == this.parameterCount;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

