/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core.validators;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;

public class NewProjectLocationValidator
extends Validator
implements ValueListener<String> {
    private String elementName;
    private LiveExpression<String> pathExp;
    private LiveExpression<String> projectNameExp;
    private static final FilenameFilter IGNORE_SCM_META_DATA = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.equals(".git");
        }
    };

    public NewProjectLocationValidator(String elementName, LiveExpression<String> path, LiveExpression<String> projectName) {
        Assert.isNotNull(path);
        Assert.isNotNull(projectName);
        this.elementName = elementName;
        this.pathExp = path;
        this.projectNameExp = projectName;
        path.addListener(this);
        projectName.addListener(this);
    }

    private File[] listFiles(File file) {
        return file.listFiles(IGNORE_SCM_META_DATA);
    }

    @Override
    protected ValidationResult compute() {
        String path = this.pathExp.getValue();
        if (path == null || "".equals(path)) {
            return ValidationResult.error(String.valueOf(this.elementName) + " should be defined");
        }
        String lastSegment = new Path(path).lastSegment();
        String projectName = this.projectNameExp.getValue();
        if (projectName != null && lastSegment != null && !lastSegment.equals(projectName)) {
            return ValidationResult.error(String.valueOf(this.elementName) + ": last segment of path should be '" + projectName + "'");
        }
        File file = new File(path);
        if (file.exists()) {
            if (file.isDirectory()) {
                if (!this.isEmptyDirectory(file)) {
                    return ValidationResult.error("'" + file + "' is not empty (contains '" + this.listFiles(file)[0] + "')");
                }
            } else {
                return ValidationResult.error("'" + file + "' exists but is not a directory");
            }
        }
        return ValidationResult.OK;
    }

    private boolean isEmptyDirectory(File file) {
        File[] files = this.listFiles(file);
        if (files != null) {
            return files.length == 0;
        }
        return false;
    }

    @Override
    public void gotValue(LiveExpression<String> exp, String path) {
        this.refresh();
    }
}

