/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.config.core.IConfigEditor;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.config.graph.parts.ActivityDiagramPart;
import org.springframework.ide.eclipse.config.graph.parts.ActivityDirectEditManager;
import org.springframework.ide.eclipse.config.graph.parts.BottomAnchor;
import org.springframework.ide.eclipse.config.graph.parts.LeftAnchor;
import org.springframework.ide.eclipse.config.graph.parts.Messages;
import org.springframework.ide.eclipse.config.graph.parts.RightAnchor;
import org.springframework.ide.eclipse.config.graph.parts.TopAnchor;
import org.springframework.ide.eclipse.config.graph.parts.TransitionPart;
import org.springframework.ide.eclipse.config.graph.policies.ActivityDirectEditPolicy;
import org.springframework.ide.eclipse.config.graph.policies.ActivityEditPolicy;
import org.springframework.ide.eclipse.config.graph.policies.ActivityNodeEditPolicy;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public abstract class ActivityPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
NodeEditPart {
    protected ActivityDirectEditManager manager;

    public ActivityPart(Activity activity) {
        this.setModel(activity);
    }

    public void activate() {
        super.activate();
        this.getActivity().addPropertyChangeListener(this);
    }

    protected void applyBoundsResults(CompoundDirectedGraph graph, Map<AbstractGraphicalEditPart, Object> map) {
        Node n = (Node)map.get(this);
        this.getFigure().setBounds(new Rectangle(n.x, n.y, n.width, n.height));
    }

    protected void applyGraphResults(CompoundDirectedGraph graph, Map<AbstractGraphicalEditPart, Object> map) {
        this.applyBoundsResults(graph, map);
        int i = 0;
        while (i < this.getSourceConnections().size()) {
            TransitionPart trans = (TransitionPart)this.getSourceConnections().get(i);
            trans.applyGraphResults(graph, map);
            ++i;
        }
    }

    protected void contributeEdgesToGraph(CompoundDirectedGraph graph, Map<AbstractGraphicalEditPart, Object> map) {
        int i = 0;
        while (i < this.getSourceConnections().size()) {
            TransitionPart part = (TransitionPart)this.getSourceConnections().get(i);
            part.contributeToGraph(graph, map);
            ++i;
        }
        i = 0;
        while (i < this.getChildren().size()) {
            ActivityPart child = (ActivityPart)this.getChildren().get(i);
            child.contributeEdgesToGraph(graph, map);
            ++i;
        }
    }

    protected abstract void contributeNodesToGraph(CompoundDirectedGraph var1, Subgraph var2, Map<AbstractGraphicalEditPart, Object> var3);

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ActivityEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ActivityDirectEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ActivityNodeEditPolicy());
    }

    public void deactivate() {
        super.deactivate();
        this.getActivity().removePropertyChangeListener(this);
    }

    protected Activity getActivity() {
        return (Activity)this.getModel();
    }

    protected abstract int getAnchorOffset();

    public abstract Activity getModelElement();

    protected List<Transition> getModelSourceConnections() {
        return this.getActivity().getOutgoingTransitions();
    }

    protected List<Transition> getModelTargetConnections() {
        return this.getActivity().getIncomingTransitions();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        ActivityDiagramPart diagram;
        EditPart part = this.getViewer().getContents();
        if (part instanceof ActivityDiagramPart && (diagram = (ActivityDiagramPart)part).getDirection() == 16) {
            return new RightAnchor(this.getFigure(), this.getAnchorOffset());
        }
        return new BottomAnchor(this.getFigure(), this.getAnchorOffset());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        ActivityDiagramPart diagram;
        EditPart part = this.getViewer().getContents();
        if (part instanceof ActivityDiagramPart && (diagram = (ActivityDiagramPart)part).getDirection() == 16) {
            return new RightAnchor(this.getFigure(), this.getAnchorOffset());
        }
        return new BottomAnchor(this.getFigure(), this.getAnchorOffset());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        ActivityDiagramPart diagram;
        EditPart part = this.getViewer().getContents();
        if (part instanceof ActivityDiagramPart && (diagram = (ActivityDiagramPart)part).getDirection() == 16) {
            return new LeftAnchor(this.getFigure(), this.getAnchorOffset());
        }
        return new TopAnchor(this.getFigure(), this.getAnchorOffset());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        ActivityDiagramPart diagram;
        EditPart part = this.getViewer().getContents();
        if (part instanceof ActivityDiagramPart && (diagram = (ActivityDiagramPart)part).getDirection() == 16) {
            return new LeftAnchor(this.getFigure(), this.getAnchorOffset());
        }
        return new TopAnchor(this.getFigure(), this.getAnchorOffset());
    }

    protected void handleBoundsChange(PropertyChangeEvent event) {
        IFigure figure = this.getFigure();
        Rectangle constraint = (Rectangle)event.getNewValue();
        ActivityDiagramPart diagram = (ActivityDiagramPart)this.getParent();
        diagram.setLayoutConstraint((EditPart)this, figure, constraint);
    }

    public boolean isManualLayout() {
        EditPart part = this.getViewer().getContents();
        if (part instanceof ActivityDiagramPart) {
            ActivityDiagramPart diagramPart = (ActivityDiagramPart)part;
            return diagramPart.isManualLayout();
        }
        return false;
    }

    protected void performDirectEdit() {
    }

    protected void performOpen() {
        this.showProperties();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" && this.getEditPolicy("DirectEditPolicy") != null) {
            this.performDirectEdit();
        }
        if (request.getType() == "open") {
            this.performOpen();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("children".equals(prop)) {
            this.refreshChildren();
        } else if ("incomings".equals(prop)) {
            this.refreshTargetConnections();
        } else if ("outgoings".equals(prop)) {
            this.refreshSourceConnections();
        } else if ("name".equals(prop)) {
            this.refreshVisuals();
        } else if ("bounds".equals(prop)) {
            this.handleBoundsChange(evt);
        }
        ((GraphicalEditPart)this.getViewer().getContents()).getFigure().revalidate();
    }

    public void refreshAll() {
        this.refresh();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (children.get(i) instanceof ActivityPart) {
                ActivityPart child = (ActivityPart)children.get(i);
                child.refreshAll();
            }
            ++i;
        }
        List sources = this.getSourceConnections();
        int i2 = 0;
        while (i2 < sources.size()) {
            if (sources.get(i2) instanceof TransitionPart) {
                TransitionPart trans = (TransitionPart)sources.get(i2);
                trans.refresh();
            }
            ++i2;
        }
        List targets = this.getTargetConnections();
        int i3 = 0;
        while (i3 < targets.size()) {
            if (targets.get(i3) instanceof TransitionPart) {
                TransitionPart trans = (TransitionPart)targets.get(i3);
                trans.refresh();
            }
            ++i3;
        }
    }

    protected abstract void refreshFigureVisuals();

    protected void refreshTooltipVisuals() {
        if (this.getFigure() != null) {
            Label tooltip = (Label)this.getFigure().getToolTip();
            if (tooltip == null) {
                tooltip = new Label();
                this.getFigure().setToolTip((IFigure)tooltip);
            }
            tooltip.setText(this.getActivity().getName());
        }
    }

    protected void refreshVisuals() {
        this.refreshFigureVisuals();
        this.refreshTooltipVisuals();
    }

    protected void setFigure(IFigure figure) {
        figure.getBounds().setSize(0, 0);
        super.setFigure(figure);
    }

    public void showProperties() {
        try {
            IConfigEditor editor;
            Object obj;
            IViewPart props = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet");
            if (props instanceof ISelectionListener && (obj = (editor = this.getModelElement().getDiagram().getGraphicalEditor().getEditor()).getAdapter(ISelectionProvider.class)) instanceof ISelectionProvider) {
                ISelectionProvider provider = (ISelectionProvider)obj;
                ((ISelectionListener)props).selectionChanged((IWorkbenchPart)editor, provider.getSelection());
            }
        }
        catch (PartInitException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.graph", Messages.StructuredActivityPart_ERROR_OPENING_VIEW, (Throwable)e));
        }
    }

    public String toString() {
        return this.getModel().toString();
    }
}

