/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.model.commands;

import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.config.graph.model.commands.AbstractTextCommand;
import org.springframework.ide.eclipse.config.graph.parts.FixedConnectionAnchor;

public class ReconnectFixedTargetCommand
extends AbstractTextCommand {
    private String id;
    private String attr;
    private Activity source;
    private Activity target;
    private Transition transition;
    private IDOMElement sourceElement;
    private IDOMElement targetElement;
    private FixedConnectionAnchor targetAnchor;
    private Activity oldTarget;
    private IDOMElement oldTargetElement;
    private IDOMAttr transitionAttr;

    public ReconnectFixedTargetCommand(ITextEditor textEditor) {
        super(textEditor);
    }

    public boolean canExecute() {
        if (this.source == null || this.target == null || this.source.equals(this.target)) {
            return false;
        }
        this.sourceElement = this.source.getInput();
        this.targetElement = this.target.getInput();
        this.oldTargetElement = this.oldTarget.getInput();
        if (this.sourceElement == null || this.targetElement == null || this.oldTargetElement == null) {
            return false;
        }
        if (!(this.transition.getInput() instanceof IDOMAttr)) {
            return false;
        }
        this.transitionAttr = (IDOMAttr)this.transition.getInput();
        if (this.targetAnchor != null && this.transitionAttr.getOwnerElement().equals(this.sourceElement)) {
            return false;
        }
        if (this.targetAnchor == null && this.transitionAttr.getOwnerElement().equals(this.oldTargetElement)) {
            return false;
        }
        if (this.targetAnchor != null) {
            this.attr = this.targetAnchor.getConnectionLabel();
            this.id = this.transitionAttr.getValue();
        } else {
            this.attr = this.transitionAttr.getName();
            this.id = this.targetElement.getAttribute(BeansSchemaConstants.ATTR_ID);
        }
        return this.id != null && this.id.trim().length() != 0;
    }

    public void execute() {
        if (this.targetAnchor != null) {
            IDOMDocument document = (IDOMDocument)this.transitionAttr.getOwnerDocument();
            IDOMModel model = document.getModel();
            model.beginRecording((Object)this);
            this.oldTargetElement.removeAttribute(this.transitionAttr.getName());
            this.targetElement.setAttribute(this.attr, this.id);
            model.endRecording((Object)this);
        } else {
            this.sourceElement.setAttribute(this.attr, this.id);
        }
    }

    public void setTarget(Activity activity) {
        this.target = activity;
    }

    public void setTargetAnchor(FixedConnectionAnchor anchor) {
        this.targetAnchor = anchor;
    }

    public void setTransition(Transition trans) {
        this.transition = trans;
        this.source = trans.source;
        this.oldTarget = trans.target;
    }
}

