/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.springframework.ide.eclipse.config.graph.ConfigGraphCommonImages;

public class StartTag
extends Label {
    private final int direction;

    public StartTag(String name, int direction) {
        this.direction = direction;
        this.setText(name);
        if (direction == 16) {
            this.setTextPlacement(4);
            this.setIcon(CommonImages.getImage((ImageDescriptor)ConfigGraphCommonImages.SEQUENCE_BEGIN_HORIZONTAL));
            this.setBorder((Border)new MarginBorder(0, 2, 2, 9));
        } else {
            this.setIcon(CommonImages.getImage((ImageDescriptor)ConfigGraphCommonImages.SEQUENCE_BEGIN_VERTICAL));
            this.setBorder((Border)new MarginBorder(2, 0, 2, 9));
        }
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        Rectangle r = this.getTextBounds();
        r.resize(-2, 0).expand(1, 1);
        r.x -= 2;
        g.drawLine(r.x, r.y, r.right(), r.y);
        g.drawLine(r.x, r.bottom(), r.right(), r.bottom());
        g.drawLine(r.x, r.bottom(), r.x, r.y);
        g.drawLine(r.right() + 7, r.y + r.height / 2, r.right(), r.y);
        g.drawLine(r.right() + 7, r.y + r.height / 2, r.right(), r.bottom());
    }
}

