/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui.conversion;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.testng.eclipse.ui.conversion.AnnotationRewriter;
import org.testng.eclipse.ui.conversion.BaseQuickAssistProcessor;
import org.testng.eclipse.ui.conversion.IRewriteProvider;
import org.testng.eclipse.ui.conversion.JUnitRewriteCorrectionProposal;

public class JUnitConverterQuickAssistProcessor
extends BaseQuickAssistProcessor
implements IQuickAssistProcessor {
    public boolean hasAssists(IInvocationContext context) throws CoreException {
        IType[] types;
        IImportDeclaration[] imports = context.getCompilationUnit().getImports();
        int i = 0;
        while (i < imports.length) {
            IImportDeclaration id = imports[i];
            String name = id.getElementName();
            if (name.indexOf("junit") != -1) {
                return true;
            }
            ++i;
        }
        IType[] iTypeArray = types = context.getCompilationUnit().getTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (type.getFullyQualifiedName().contains("Test")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ArrayList vResult = Lists.newArrayList();
        if (this.hasAssists(context)) {
            ICompilationUnit cu = context.getCompilationUnit();
            CompilationUnit astRoot = JUnitConverterQuickAssistProcessor.createCompilationUnit(cu);
            AST ast = context.getASTRoot().getAST();
            IRewriteProvider[] providers = new IRewriteProvider[]{new AnnotationRewriter()};
            int i = 0;
            while (i < providers.length) {
                ASTRewrite rewriter = providers[i].createRewriter(astRoot, ast);
                vResult.add(new JUnitRewriteCorrectionProposal(providers[i].getName(), cu, rewriter, 1));
                ++i;
            }
        }
        return vResult.toArray(new IJavaCompletionProposal[vResult.size()]);
    }

    private static void ppp(String s) {
        System.out.println("[JUnitConverterQuickAssistProcessor] " + s);
    }
}

