/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.configurator;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.springframework.util.StringUtils;
import org.springsource.ide.eclipse.commons.configurator.ConfigurableExtension;
import org.springsource.ide.eclipse.commons.configurator.WorkspaceConfiguratorParticipant;
import org.springsource.ide.eclipse.commons.internal.configurator.Activator;
import org.springsource.ide.eclipse.commons.internal.configurator.ConfiguratorImporter;
import org.springsource.ide.eclipse.commons.internal.configurator.InstallableItem;

public class Configurator {
    private static final String PARAM_TARGET = "targetDir";
    private static final String PARAM_EXTENSION = "extension";
    private final List<WorkspaceConfiguratorParticipant> participants = new ArrayList<WorkspaceConfiguratorParticipant>();

    public IStatus execute(Map<?, ?> parameters) {
        return this.execute(parameters, false);
    }

    public IStatus execute(Map<?, ?> parameters, boolean errorIfNoParticipant) {
        this.participants.clear();
        String targetPath = (String)parameters.get(PARAM_TARGET);
        if (targetPath != null) {
            return this.execute(targetPath, errorIfNoParticipant);
        }
        String extensionId = (String)parameters.get(PARAM_EXTENSION);
        if (extensionId != null) {
            for (InstallableItem item : ConfiguratorImporter.ParticipantExtensionPointReader.getInstallableItems()) {
                IStatus result;
                if (!extensionId.equals(item.getId())) continue;
                ConfiguratorImporter importer = new ConfiguratorImporter();
                File installLocation = importer.getInstallLocation();
                if (installLocation == null || (result = item.install(installLocation, (IProgressMonitor)new NullProgressMonitor())).getSeverity() == 4) break;
                return this.execute(item.getTargetLocation(installLocation).getAbsolutePath(), errorIfNoParticipant);
            }
            if (errorIfNoParticipant) {
                return new Status(4, "org.springsource.ide.eclipse.commons.configurator", "No install item found to configure request");
            }
            this.persistRequest("extension=" + extensionId);
            return Status.OK_STATUS;
        }
        return new Status(4, "org.springsource.ide.eclipse.commons.configurator", "Missing parameter 'targetDir' or 'extension'");
    }

    private IStatus execute(String targetPath, boolean errorIfNoParticipant) {
        File file = new File(targetPath);
        if (file.exists() && file.isDirectory()) {
            for (WorkspaceConfiguratorParticipant configurator : ConfiguratorImporter.ParticipantExtensionPointReader.getParticipants()) {
                ConfigurableExtension extension = configurator.createExtension(file, (IProgressMonitor)new NullProgressMonitor());
                if (extension == null) continue;
                this.participants.add(configurator);
                try {
                    extension.configure((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    return new Status(4, "org.springsource.ide.eclipse.commons.configurator", 1, "Error occured configuring workspace", (Throwable)e);
                }
            }
        } else {
            return new Status(4, "org.springsource.ide.eclipse.commons.configurator", "Parameter 'targetDir' does not denote a valid path");
        }
        if (this.participants.isEmpty()) {
            if (errorIfNoParticipant) {
                return new Status(4, "org.springsource.ide.eclipse.commons.configurator", "No participant found to configure request");
            }
            this.persistRequest(targetPath);
        }
        return Status.OK_STATUS;
    }

    public void executePendingRequests() {
        String configureTargets = Activator.getDefault().getPreferenceStore().getString("org.springsource.ide.eclipse.commons.configurator.configuretargets");
        ArrayList<String> newConfigureTargets = new ArrayList<String>();
        if (StringUtils.hasLength((String)configureTargets)) {
            StringTokenizer targets = new StringTokenizer(configureTargets, File.pathSeparator);
            while (targets.hasMoreTokens()) {
                String target = targets.nextToken();
                HashMap<String, String> parameters = new HashMap<String, String>();
                if (target.startsWith("extension=")) {
                    parameters.put(PARAM_EXTENSION, target.substring("extension=".length()));
                } else {
                    parameters.put(PARAM_TARGET, target);
                }
                IStatus status = this.execute(parameters, true);
                if (status.isOK()) continue;
                newConfigureTargets.add(target);
            }
        }
        Activator.getDefault().getPreferenceStore().setValue("org.springsource.ide.eclipse.commons.configurator.configuretargets", StringUtils.collectionToDelimitedString(newConfigureTargets, (String)File.pathSeparator));
    }

    private void persistRequest(String target) {
        String configureTargets = Activator.getDefault().getPreferenceStore().getString("org.springsource.ide.eclipse.commons.configurator.configuretargets");
        configureTargets = StringUtils.hasLength((String)configureTargets) ? String.valueOf(configureTargets) + File.pathSeparatorChar + target : target;
        Activator.getDefault().getPreferenceStore().setValue("org.springsource.ide.eclipse.commons.configurator.configuretargets", configureTargets);
    }

    public IStatus undo(Map<?, ?> parameters) {
        File file;
        String targetPath = (String)parameters.get(PARAM_TARGET);
        if (targetPath != null && (file = new File(targetPath)).exists() && file.isDirectory()) {
            for (WorkspaceConfiguratorParticipant configurator : this.participants) {
                ConfigurableExtension extension = configurator.createExtension(file, (IProgressMonitor)new NullProgressMonitor());
                if (extension == null) continue;
                extension.unConfigure((IProgressMonitor)new NullProgressMonitor());
            }
        }
        return Status.OK_STATUS;
    }
}

