/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.tasks;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.springsource.ide.eclipse.commons.frameworks.ui.FrameworkUIActivator;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.tasks.IUIRunnable;

public class SynchUITask {
    private IUIRunnable userRunnable;
    private String taskName;

    public SynchUITask(IUIRunnable runnable, String taskName) {
        this.userRunnable = runnable;
        this.taskName = taskName;
    }

    protected Shell getShell() {
        Shell shell = null;
        if (this.userRunnable != null) {
            shell = this.userRunnable.getShell();
        }
        if (shell == null && (shell = Display.getDefault().getActiveShell()) == null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                shell = window.getShell();
                if (shell != null) break;
                ++n2;
            }
        }
        return shell;
    }

    public void execute() {
        if (this.userRunnable == null) {
            return;
        }
        Shell shell = this.getShell();
        if (shell != null) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
            IProgressMonitor monitor = dialog.getProgressMonitor();
            if (monitor != null) {
                monitor.setTaskName(this.taskName);
            }
            try {
                dialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SynchUITask.this.userRunnable.run(monitor);
                    }
                });
            }
            catch (InvocationTargetException e) {
                FrameworkUIActivator.log((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.frameworks.ui", "Unexpected error", (Throwable)e));
            }
            catch (InterruptedException e) {
                FrameworkUIActivator.log((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.frameworks.ui", "Operation cancelled", (Throwable)e));
            }
        }
    }
}

