/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.generatediff;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class GenerateDiffFileOperation
implements IRunnableWithProgress {
    private static String ECLIPSE_PATCH_HEADER = "### Eclipse Workspace Patch 1.0";
    private static String ECLIPSE_PROJECT_MARKER = "#P ";
    private static String EOL = System.getProperty("line.separator");
    private File outputFile;
    private IResource[] resources;
    private IResource[] unaddedResources;
    private Shell shell;
    private boolean recursive;
    private boolean toClipboard;
    private ArrayList newFiles;
    private IResource[] selectedResources;
    private final boolean eclipseFormat;
    private final boolean projectRelative;

    GenerateDiffFileOperation(IResource[] resources, IResource[] unaddedResources, File file, boolean toClipboard, boolean recursive, boolean eclipseFormat, boolean projectRelative, Shell shell) {
        this.resources = resources;
        this.unaddedResources = unaddedResources;
        this.outputFile = file;
        this.eclipseFormat = eclipseFormat;
        this.projectRelative = projectRelative;
        this.shell = shell;
        this.recursive = recursive;
        this.toClipboard = toClipboard;
    }

    protected Hashtable getProviderMapping(IResource[] resources) {
        Hashtable<RepositoryProvider, ArrayList<IResource>> result = new Hashtable<RepositoryProvider, ArrayList<IResource>>();
        int i = 0;
        while (i < resources.length) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resources[i].getProject());
            ArrayList<IResource> list = (ArrayList<IResource>)result.get(provider);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resources[i]);
            ++i;
        }
        return result;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        ISVNClientAdapter svnClient = null;
        ISVNRepositoryLocation repository = null;
        try {
            try {
                monitor.beginTask("", 500);
                monitor.setTaskName(Policy.bind("GenerateSVNDiff.working"));
                OutputStream os = this.toClipboard ? new ByteArrayOutputStream() : new FileOutputStream(this.outputFile);
                File tmpFile = File.createTempFile("sub", "");
                tmpFile.deleteOnExit();
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resources[0]);
                this.newFiles = new ArrayList();
                if (this.unaddedResources.length > 0) {
                    int i = 0;
                    while (i < this.unaddedResources.length) {
                        this.newFiles.add(this.unaddedResources[i]);
                        ++i;
                    }
                    if (this.newFiles.size() > 0) {
                        try {
                            Hashtable table = this.getProviderMapping(this.newFiles.toArray(new IResource[this.newFiles.size()]));
                            Set keySet = table.keySet();
                            Iterator iterator = keySet.iterator();
                            while (iterator.hasNext()) {
                                IProgressMonitor subMonitor = Policy.subMonitorFor(monitor, 100);
                                SVNTeamProvider provider = (SVNTeamProvider)iterator.next();
                                List list = (List)table.get(provider);
                                IResource[] providerResources = list.toArray(new IResource[list.size()]);
                                provider.add(providerResources, 2, subMonitor);
                            }
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
                repository = svnResource.getRepository();
                svnClient = repository.getSVNClient();
                try {
                    int length;
                    monitor.worked(100);
                    File[] files = this.getVersionedFiles();
                    if (this.selectedResources == null) {
                        svnClient.diff(files, tmpFile, this.recursive);
                    } else if (this.eclipseFormat) {
                        HashSet includedResources = new HashSet();
                        includedResources.addAll(Arrays.asList(this.unaddedResources));
                        includedResources.addAll(Arrays.asList(this.resources));
                        this.createEclipsePatch(includedResources.toArray(new IResource[0]), tmpFile, this.recursive);
                    } else {
                        File relativeToPath = null;
                        if (this.projectRelative) {
                            relativeToPath = this.selectedResources[0].getProject().getLocation().toFile();
                        } else {
                            relativeToPath = this.getRelativeToPath();
                            if (relativeToPath.isFile()) {
                                relativeToPath = relativeToPath.getParentFile();
                            }
                        }
                        svnClient.createPatch(files, relativeToPath, tmpFile, this.recursive);
                    }
                    monitor.worked(300);
                    FileInputStream is = new FileInputStream(tmpFile);
                    byte[] buffer = new byte[30000];
                    while ((length = ((InputStream)is).read(buffer)) != -1) {
                        os.write(buffer, 0, length);
                    }
                }
                finally {
                    os.close();
                }
                if (this.newFiles.size() > 0) {
                    int i = 0;
                    while (i < this.newFiles.size()) {
                        IResource resource = (IResource)this.newFiles.get(i);
                        try {
                            SVNWorkspaceRoot.getSVNResourceFor((IResource)resource).revert();
                        }
                        catch (Exception exception) {}
                        ++i;
                    }
                }
                boolean emptyDiff = false;
                if (this.toClipboard) {
                    final ByteArrayOutputStream baos = (ByteArrayOutputStream)os;
                    if (baos.size() == 0) {
                        emptyDiff = true;
                    } else {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                                Clipboard clipboard = new Clipboard(GenerateDiffFileOperation.this.shell.getDisplay());
                                clipboard.setContents((Object[])new String[]{baos.toString()}, new Transfer[]{plainTextTransfer});
                                clipboard.dispose();
                            }
                        });
                    }
                } else if (this.outputFile.length() == 0L) {
                    emptyDiff = true;
                    this.outputFile.delete();
                }
                if (emptyDiff) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openInformation((Shell)GenerateDiffFileOperation.this.shell, (String)Policy.bind("GenerateSVNDiff.noDiffsFoundTitle"), (String)Policy.bind("GenerateSVNDiff.noDiffsFoundMsg"));
                        }
                    });
                }
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            if (repository != null) {
                repository.returnSVNClient(svnClient);
            }
            monitor.done();
            throw throwable;
        }
        if (repository != null) {
            repository.returnSVNClient(svnClient);
        }
        monitor.done();
    }

    private File getRelativeToPath() {
        if (this.selectedResources.length == 1) {
            return new File(this.selectedResources[0].getLocation().toString());
        }
        String commonRoot = null;
        String path = this.selectedResources[0].getLocation().toString();
        int i = 0;
        block0: while (i < path.length()) {
            String partialPath = path.substring(0, i + 1);
            if (partialPath.endsWith("/") || partialPath.endsWith("\\")) {
                int j = 1;
                while (j < this.selectedResources.length) {
                    if (!this.selectedResources[j].getLocation().toString().startsWith(partialPath)) break block0;
                    ++j;
                }
                commonRoot = partialPath.substring(0, i);
            }
            ++i;
        }
        if (commonRoot != null) {
            return new File(commonRoot);
        }
        return null;
    }

    private File[] getVersionedFiles() {
        ArrayList<File> versionedFileList = new ArrayList<File>();
        ArrayList<IResource> unaddedResourceList = new ArrayList<IResource>();
        int i = 0;
        while (i < this.unaddedResources.length) {
            unaddedResourceList.add(this.unaddedResources[i]);
            ++i;
        }
        i = 0;
        while (i < this.resources.length) {
            if (!this.containsResource(unaddedResourceList, this.resources[i]) || this.containsResource(this.newFiles, this.resources[i])) {
                versionedFileList.add(new File(this.resources[i].getLocation().toOSString()));
            }
            ++i;
        }
        File[] files = new File[versionedFileList.size()];
        versionedFileList.toArray(files);
        return files;
    }

    private boolean containsResource(ArrayList list, IResource resource) {
        if (list.contains(resource)) {
            return true;
        }
        IResource parent = resource;
        while (parent != null) {
            if (!list.contains(parent = parent.getParent())) continue;
            return true;
        }
        return false;
    }

    public void setSelectedResources(IResource[] selectedResources) {
        this.selectedResources = selectedResources;
    }

    private void createEclipsePatch(IResource[] paths, File outputFile, boolean recurse) throws SVNClientException {
        FileOutputStream os = null;
        FileInputStream is = null;
        ISVNClientAdapter client = null;
        ISVNRepositoryLocation repository = null;
        try {
            try {
                List files;
                IProject project;
                byte[] buffer = new byte[4096];
                os = new FileOutputStream(outputFile);
                if (paths.length > 0) {
                    os.write(ECLIPSE_PATCH_HEADER.getBytes());
                    os.write(EOL.getBytes());
                }
                HashMap projectToResources = new HashMap();
                int i = 0;
                while (i < paths.length) {
                    IResource resource = paths[i];
                    project = resource.getProject();
                    files = (ArrayList<File>)projectToResources.get(project);
                    if (files == null) {
                        files = new ArrayList<File>();
                        projectToResources.put(project, files);
                    }
                    files.add(resource.getLocation().toFile());
                    ++i;
                }
                for (Map.Entry entry : projectToResources.entrySet()) {
                    project = (IResource)entry.getKey();
                    files = (List)entry.getValue();
                    repository = SVNWorkspaceRoot.getSVNResourceFor((IResource)project).getRepository();
                    client = repository.getSVNClient();
                    os.write(ECLIPSE_PROJECT_MARKER.getBytes());
                    os.write(project.getName().getBytes());
                    os.write(EOL.getBytes());
                    File tempFile = File.createTempFile("tempDiff", ".txt");
                    tempFile.deleteOnExit();
                    client.createPatch(files.toArray(new File[files.size()]), project.getLocation().toFile(), tempFile, recurse);
                    SVNWorkspaceRoot.getSVNResourceFor((IResource)project).getRepository().returnSVNClient(client);
                    client = null;
                    repository = null;
                    try {
                        int bytes_read;
                        is = new FileInputStream(tempFile);
                        while ((bytes_read = ((InputStream)is).read(buffer)) != -1) {
                            os.write(buffer, 0, bytes_read);
                        }
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (is == null) continue;
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception e) {
                throw new SVNClientException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            if (repository != null) {
                repository.returnSVNClient(client);
            }
            throw throwable;
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
        if (repository != null) {
            repository.returnSVNClient(client);
        }
    }
}

