/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.net.MalformedURLException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.repository.RepositoryFilters;
import org.tigris.subversion.subclipse.ui.repository.model.AllRootsElement;
import org.tigris.subversion.subclipse.ui.repository.model.RemoteContentProvider;
import org.tigris.subversion.subclipse.ui.wizards.SVNWizardPage;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MoveRemoteResourceWizardMainPage
extends SVNWizardPage {
    private static final int LIST_WIDTH = 250;
    private static final int LIST_HEIGHT = 300;
    private Text urlParentText;
    private Text resourceNameText;
    private TreeViewer viewer;
    private ISVNRemoteFolder parentFolder;
    private String resourceName = "";
    private ISelectionChangedListener treeSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (selection instanceof ISVNRemoteFolder) {
                MoveRemoteResourceWizardMainPage.this.parentFolder = (ISVNRemoteFolder)selection;
            } else if (selection instanceof IAdaptable) {
                IAdaptable a = (IAdaptable)selection;
                Object adapter = a.getAdapter(ISVNRemoteFolder.class);
                MoveRemoteResourceWizardMainPage.this.parentFolder = (ISVNRemoteFolder)adapter;
            }
            if (MoveRemoteResourceWizardMainPage.this.parentFolder != null) {
                MoveRemoteResourceWizardMainPage.this.urlParentText.setText(MoveRemoteResourceWizardMainPage.this.parentFolder.getUrl().toString());
            }
        }
    };

    public MoveRemoteResourceWizardMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.move_rename_remote_resource_page_context");
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                MoveRemoteResourceWizardMainPage.this.resourceName = MoveRemoteResourceWizardMainPage.this.resourceNameText.getText();
                MoveRemoteResourceWizardMainPage.this.validateFields();
            }
        };
        MoveRemoteResourceWizardMainPage.createLabel(composite, Policy.bind("MoveRemoteResourceWizardMainPage.selectParentUrl"));
        this.urlParentText = MoveRemoteResourceWizardMainPage.createTextField(composite);
        this.urlParentText.addListener(13, listener);
        this.urlParentText.addListener(24, listener);
        this.urlParentText.setEditable(false);
        DrillDownComposite drillDown = new DrillDownComposite(composite, 2048);
        GridData spec = new GridData(1808);
        spec.widthHint = 250;
        spec.heightHint = 300;
        drillDown.setLayoutData((Object)spec);
        this.viewer = new TreeViewer((Composite)drillDown, 768);
        drillDown.setChildTree(this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new RemoteContentProvider());
        this.viewer.setInput((Object)new AllRootsElement());
        this.viewer.addFilter(RepositoryFilters.FOLDERS_ONLY);
        this.viewer.addSelectionChangedListener(this.treeSelectionChangedListener);
        MoveRemoteResourceWizardMainPage.createLabel(composite, Policy.bind("MoveRemoteResourceWizardMainPage.resourceName"));
        this.resourceNameText = MoveRemoteResourceWizardMainPage.createTextField(composite);
        this.resourceNameText.addListener(13, listener);
        this.resourceNameText.addListener(24, listener);
        this.resourceNameText.setText(this.resourceName);
        this.validateFields();
        this.resourceNameText.setFocus();
        this.setControl((Control)composite);
        if (this.parentFolder != null) {
            Object toSelect = null;
            toSelect = this.parentFolder.getParent() == null ? this.parentFolder.getRepository() : this.parentFolder;
            this.viewer.expandToLevel(toSelect, 0);
            this.viewer.setSelection((ISelection)new StructuredSelection(toSelect), true);
        }
    }

    private void validateFields() {
        if (this.resourceNameText.getText().length() == 0) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        try {
            new SVNUrl(Util.appendPath((String)this.urlParentText.getText(), (String)this.resourceNameText.getText()));
        }
        catch (MalformedURLException malformedURLException) {
            this.setErrorMessage(Policy.bind("MoveRemoteResourceWizardMainPage.invalidUrl"));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.resourceNameText.setFocus();
        }
    }

    public ISVNRemoteFolder getParentFolder() {
        return this.parentFolder;
    }

    public String getResourceName() {
        return this.resourceNameText.getText();
    }

    public void setRemoteResource(ISVNRemoteResource remoteResource) {
        this.parentFolder = remoteResource.getParent();
        this.resourceName = remoteResource.getName();
    }
}

