/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.tigris.subversion.subclipse.ui.ISVNRepositorySourceProvider;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.wizards.CloudForgeComposite;

public class ConfigurationWizardRepositorySourceProviderPage
extends WizardPage {
    private ISVNRepositorySourceProvider[] repositorySourceProviders;
    private TreeViewer treeViewer;
    private ISVNRepositorySourceProvider selectedRepositorySourceProvider;
    public static final String REPOSITORY_PROVIDERS_WIKI_URL = "http://subclipse.tigris.org/wiki/RepositoryProviders";

    public ConfigurationWizardRepositorySourceProviderPage(String pageName, String title, ImageDescriptor titleImage, ISVNRepositorySourceProvider[] repositorySourceProviders) {
        super(pageName, title, titleImage);
        this.repositorySourceProviders = repositorySourceProviders;
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        outerContainer.setLayout((Layout)new GridLayout());
        outerContainer.setLayoutData((Object)new GridData(768));
        Composite treeGroup = new Composite(outerContainer, 0);
        GridLayout treeLayout = new GridLayout();
        treeLayout.numColumns = 1;
        treeGroup.setLayout((Layout)treeLayout);
        treeGroup.setLayoutData((Object)new GridData(768));
        this.treeViewer = new TreeViewer(treeGroup, 2052);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new RepositorySourceLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new RepositorySourceContentProvider());
        this.treeViewer.setUseHashlookup(true);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.minimumHeight = 300;
        layoutData.minimumWidth = 300;
        this.treeViewer.getControl().setLayoutData((Object)layoutData);
        this.treeViewer.setInput((Object)this);
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)"URL"));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedObject = ((IStructuredSelection)ConfigurationWizardRepositorySourceProviderPage.this.treeViewer.getSelection()).getFirstElement();
                if (selectedObject instanceof ISVNRepositorySourceProvider) {
                    ConfigurationWizardRepositorySourceProviderPage.this.selectedRepositorySourceProvider = (ISVNRepositorySourceProvider)selectedObject;
                } else {
                    ConfigurationWizardRepositorySourceProviderPage.this.selectedRepositorySourceProvider = null;
                }
                ConfigurationWizardRepositorySourceProviderPage.this.setPageComplete(!ConfigurationWizardRepositorySourceProviderPage.this.treeViewer.getSelection().isEmpty());
            }
        });
        Hyperlink repositoryProviderLink = new Hyperlink(treeGroup, 0);
        repositoryProviderLink.setUnderlined(true);
        repositoryProviderLink.setForeground(Display.getDefault().getSystemColor(9));
        repositoryProviderLink.setText("Click here to see the list of available providers.");
        repositoryProviderLink.setToolTipText(REPOSITORY_PROVIDERS_WIKI_URL);
        repositoryProviderLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent evt) {
                ConfigurationWizardRepositorySourceProviderPage.showAvailableProviders();
            }
        });
        CloudForgeComposite cloudForgeComposite = new CloudForgeComposite(outerContainer, 0);
        GridData data = new GridData(1048);
        cloudForgeComposite.setLayoutData(data);
        this.setControl((Control)outerContainer);
    }

    public ISVNRepositorySourceProvider getSelectedRepositorySourceProvider() {
        return this.selectedRepositorySourceProvider;
    }

    public static void showAvailableProviders() {
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(REPOSITORY_PROVIDERS_WIKI_URL));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Available Repository Providers", (String)e.getMessage());
        }
    }

    class RepositorySourceLabelProvider
    extends LabelProvider {
        RepositorySourceLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ISVNRepositorySourceProvider) {
                return ((ISVNRepositorySourceProvider)element).getImage();
            }
            return SVNUIPlugin.getPlugin().getImageDescriptor("obj16/url_source_repo.gif").createImage();
        }

        public String getText(Object element) {
            if (element instanceof ISVNRepositorySourceProvider) {
                return ((ISVNRepositorySourceProvider)element).getName();
            }
            return element.toString();
        }
    }

    private class RepositorySourceContentProvider
    implements ITreeContentProvider {
        private RepositorySourceContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<Object> children = new ArrayList<Object>();
            if (parentElement == ConfigurationWizardRepositorySourceProviderPage.this) {
                children.add("URL");
                ISVNRepositorySourceProvider[] iSVNRepositorySourceProviderArray = ConfigurationWizardRepositorySourceProviderPage.this.repositorySourceProviders;
                int n = 0;
                int n2 = iSVNRepositorySourceProviderArray.length;
                while (n < n2) {
                    ISVNRepositorySourceProvider repositorySourceProvider = iSVNRepositorySourceProviderArray[n];
                    children.add(repositorySourceProvider);
                    ++n;
                }
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

