/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.ui.Policy;

public abstract class SVNSynchronizeOperation
extends SynchronizeModelOperation {
    protected SVNSynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SyncInfoSet syncSet = this.getSyncInfoSet();
        if (!this.promptForConflictHandling(this.getShell(), syncSet)) {
            return;
        }
        Map projectSyncInfos = this.getProjectSyncInfoSetMap(syncSet);
        monitor.beginTask(null, projectSyncInfos.size() * 100);
        for (IProject project : projectSyncInfos.keySet()) {
            SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.tigris.subversion.subclipse.core.svnnature");
            if (provider == null) continue;
            this.run(provider, (SyncInfoSet)projectSyncInfos.get(project), Policy.subMonitorFor(monitor, 100));
        }
        monitor.done();
    }

    protected abstract boolean promptForConflictHandling(Shell var1, SyncInfoSet var2);

    protected Map getProjectSyncInfoSetMap(SyncInfoSet syncSet) {
        HashMap<IProject, SyncInfoSet> map = new HashMap<IProject, SyncInfoSet>();
        SyncInfo[] infos = syncSet.getSyncInfos();
        int i = 0;
        while (i < infos.length) {
            SyncInfo info = infos[i];
            IProject project = info.getLocal().getProject();
            SyncInfoSet set = (SyncInfoSet)map.get(project);
            if (set == null) {
                set = new SyncInfoSet();
                map.put(project, set);
            }
            set.add(info);
            ++i;
        }
        return map;
    }

    protected IResource[] extractResources(IResource[] selectedResources, SyncInfoSet set) {
        IResource[] setResources = set.getResources();
        IProject project = setResources[0].getProject();
        ArrayList<IResource> projectResources = new ArrayList<IResource>();
        int i = 0;
        while (i < selectedResources.length) {
            if (selectedResources[i].getProject().equals((Object)project)) {
                projectResources.add(selectedResources[i]);
            }
            ++i;
        }
        IResource[] resourceArray = new IResource[projectResources.size()];
        projectResources.toArray(resourceArray);
        return resourceArray;
    }

    protected abstract void run(SVNTeamProvider var1, SyncInfoSet var2, IProgressMonitor var3) throws InvocationTargetException, InterruptedException;
}

