/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.authentication;

import java.util.Properties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.SubclipseTrayDialog;

public class SSHPromptDialog
extends SubclipseTrayDialog {
    private String realm;
    private String username;
    private String password;
    private int sshPort;
    private String keyFile;
    private String passphrase;
    private boolean save;
    private boolean maySave;
    private Text userText;
    private Text passwordText;
    private Combo keyFileCombo;
    private Text passphraseText;
    private Button passwordButton;
    private Button keyFileButton;
    private Button browseButton;
    private Text sshPortText;
    private boolean portError;
    private Button saveButton;
    private Button okButton;
    private String[] keyFiles = new String[0];
    private static int WIDTH = 300;

    public SSHPromptDialog(Shell parentShell, String realm, String username, int sshPort, boolean maySave) {
        super(parentShell);
        this.realm = realm;
        this.username = username;
        this.sshPort = sshPort;
        this.maySave = maySave;
        this.keyFiles = SVNUIPlugin.getPlugin().getRepositoryManager().getKeyFilesManager().getPreviousKeyFiles();
    }

    protected Control createDialogArea(Composite parent) {
        Composite rtnGroup = (Composite)super.createDialogArea(parent);
        this.getShell().setText(Policy.bind("SSHPromptDialog.title"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        rtnGroup.setLayout((Layout)layout);
        rtnGroup.setLayoutData((Object)new GridData(32));
        Label realmLabel = new Label(rtnGroup, 0);
        realmLabel.setText(Policy.bind("PasswordPromptDialog.repository"));
        Text realmText = new Text(rtnGroup, 2048);
        GridData gd = new GridData();
        gd.widthHint = WIDTH;
        realmText.setLayoutData((Object)gd);
        realmText.setEditable(false);
        realmText.setText(this.realm);
        Label userLabel = new Label(rtnGroup, 0);
        userLabel.setText(Policy.bind("PasswordPromptDialog.username"));
        this.userText = new Text(rtnGroup, 2048);
        gd = new GridData();
        gd.widthHint = WIDTH;
        this.userText.setLayoutData((Object)gd);
        this.userText.setText(this.username == null ? "" : this.username);
        Group radioGroup = new Group(rtnGroup, 0);
        radioGroup.setText(Policy.bind("SSHPromptDialog.authentication"));
        GridLayout radioLayout = new GridLayout();
        radioLayout.numColumns = 1;
        radioGroup.setLayout((Layout)radioLayout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        radioGroup.setLayoutData((Object)gd);
        this.passwordButton = new Button((Composite)radioGroup, 16);
        this.passwordButton.setText(Policy.bind("SSHPromptDialog.passwordauth"));
        this.keyFileButton = new Button((Composite)radioGroup, 16);
        this.keyFileButton.setText(Policy.bind("SSHPromptDialog.keyauth"));
        this.passwordButton.setSelection(true);
        Label pwdLabel = new Label(rtnGroup, 0);
        pwdLabel.setText(Policy.bind("PasswordPromptDialog.password"));
        this.passwordText = new Text(rtnGroup, 2048);
        gd = new GridData();
        gd.widthHint = WIDTH;
        this.passwordText.setLayoutData((Object)gd);
        this.passwordText.setEchoChar('*');
        Label keyFileLabel = new Label(rtnGroup, 0);
        keyFileLabel.setText(Policy.bind("SSHPromptDialog.keyfile"));
        Composite keyFileGroup = new Composite(rtnGroup, 0);
        GridLayout keyFileLayout = new GridLayout();
        keyFileLayout.numColumns = 2;
        keyFileLayout.marginWidth = 0;
        keyFileLayout.marginHeight = 0;
        keyFileGroup.setLayout((Layout)keyFileLayout);
        gd = new GridData(768);
        keyFileGroup.setLayoutData((Object)gd);
        this.keyFileCombo = new Combo(keyFileGroup, 2048);
        gd = new GridData();
        gd.widthHint = WIDTH;
        this.keyFileCombo.setLayoutData((Object)gd);
        this.keyFileCombo.setEnabled(false);
        if (this.keyFiles != null && this.keyFiles.length > 0) {
            int i = 0;
            while (i < this.keyFiles.length) {
                this.keyFileCombo.add(this.keyFiles[i]);
                ++i;
            }
            this.keyFileCombo.setText(this.keyFiles[0]);
        }
        this.browseButton = new Button(keyFileGroup, 8);
        this.browseButton.setText(Policy.bind("SSHPromptDialog.browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String returnFile;
                Properties properties = System.getProperties();
                String home = (String)properties.get("user.home");
                FileDialog fileDialog = new FileDialog(SSHPromptDialog.this.getShell(), 4096);
                if (home != null) {
                    fileDialog.setFilterPath(home);
                }
                if ((returnFile = fileDialog.open()) != null) {
                    SSHPromptDialog.this.keyFileCombo.setText(returnFile);
                }
            }
        });
        this.browseButton.setEnabled(false);
        Label passphraseLabel = new Label(rtnGroup, 0);
        passphraseLabel.setText(Policy.bind("SSHPromptDialog.passphrase"));
        this.passphraseText = new Text(rtnGroup, 2048);
        gd = new GridData();
        gd.widthHint = WIDTH;
        this.passphraseText.setEchoChar('*');
        this.passphraseText.setLayoutData((Object)gd);
        this.passphraseText.setEnabled(false);
        Label portLabel = new Label(rtnGroup, 0);
        portLabel.setText(Policy.bind("SSHPromptDialog.port"));
        this.sshPortText = new Text(rtnGroup, 2048);
        gd = new GridData();
        gd.widthHint = 40;
        this.sshPortText.setLayoutData((Object)gd);
        this.sshPortText.setTextLimit(5);
        this.sshPortText.setText(Integer.toString(this.sshPort));
        if (this.maySave) {
            this.saveButton = new Button(rtnGroup, 32);
            this.saveButton.setText(Policy.bind("SSHPromptDialog.save"));
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.saveButton.setLayoutData((Object)gd);
        }
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                SSHPromptDialog.this.okButton.setEnabled(SSHPromptDialog.this.canFinish());
            }
        };
        this.userText.addModifyListener(modifyListener);
        this.passwordText.addModifyListener(modifyListener);
        this.keyFileCombo.addModifyListener(modifyListener);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SSHPromptDialog.this.passwordButton.getSelection()) {
                    SSHPromptDialog.this.keyFileCombo.setEnabled(false);
                    SSHPromptDialog.this.browseButton.setEnabled(false);
                    SSHPromptDialog.this.passphraseText.setEnabled(false);
                    SSHPromptDialog.this.passwordText.setEnabled(true);
                    SSHPromptDialog.this.passwordText.setFocus();
                } else {
                    SSHPromptDialog.this.keyFileCombo.setEnabled(true);
                    SSHPromptDialog.this.browseButton.setEnabled(true);
                    SSHPromptDialog.this.passphraseText.setEnabled(true);
                    SSHPromptDialog.this.passwordText.setEnabled(false);
                    SSHPromptDialog.this.keyFileCombo.setFocus();
                }
                SSHPromptDialog.this.okButton.setEnabled(SSHPromptDialog.this.canFinish());
            }
        };
        this.passwordButton.addSelectionListener((SelectionListener)selectionListener);
        this.keyFileButton.addSelectionListener((SelectionListener)selectionListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)rtnGroup, "org.tigris.subversion.subclipse.ui.ssh_prompt_dialog_context");
        if (this.username != null) {
            this.passwordText.setFocus();
        } else {
            this.userText.setFocus();
        }
        return rtnGroup;
    }

    private boolean canFinish() {
        if (this.userText.getText().trim().length() == 0) {
            return false;
        }
        if (this.passwordButton.getSelection()) {
            return this.passwordText.getText().trim().length() > 0;
        }
        return this.keyFileCombo.getText().trim().length() > 0;
    }

    public Button createButton(Composite parent, int id, String label, boolean isDefault) {
        Button button = super.createButton(parent, id, label, isDefault);
        if (id == 0) {
            this.okButton = button;
            this.okButton.setEnabled(false);
        }
        return button;
    }

    protected void okPressed() {
        this.portError = false;
        try {
            this.sshPort = Integer.parseInt(this.sshPortText.getText().trim());
        }
        catch (Exception exception) {
            this.portError = true;
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("SSHPromptDialog.invalidPortTitle"), (String)Policy.bind("SSHPromptDialog.invalidPortMessage"));
        }
        if (this.portError) {
            return;
        }
        this.username = this.userText.getText().trim();
        this.password = this.passwordText.getText().trim();
        if (this.passwordButton.getSelection()) {
            this.keyFile = null;
            this.passphrase = null;
        } else {
            this.keyFile = this.keyFileCombo.getText().trim();
            this.passphrase = this.passphraseText.getText().trim();
        }
        if (this.maySave) {
            this.save = this.saveButton.getSelection();
        }
        if (this.keyFile != null && this.keyFile.length() > 0) {
            SVNUIPlugin.getPlugin().getRepositoryManager().getKeyFilesManager().addKeyFile(this.keyFile);
        }
        super.okPressed();
    }

    public boolean isSave() {
        return this.save;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public String getPassphrase() {
        return this.passphrase;
    }
}

