/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.LockResourcesCommand;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardLockPage;

public class LockAction
extends WorkbenchWindowAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        if (action != null && !action.isEnabled()) {
            action.setEnabled(true);
        } else if (this.getSelectedResources() != null && this.getSelectedResources().length > 0) {
            final IResource[] resources = this.getSelectedResources();
            SvnWizardLockPage lockPage = new SvnWizardLockPage(resources);
            SvnWizard wizard = new SvnWizard(lockPage);
            SvnWizardDialog dialog = new SvnWizardDialog(this.getShell(), (IWizard)wizard);
            wizard.setParentDialog((Dialog)dialog);
            if (dialog.open() == 0) {
                final String comment = lockPage.getComment();
                final boolean stealLock = lockPage.isStealLock();
                this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        try {
                            try {
                                Hashtable table = LockAction.this.getProviderMapping(LockAction.this.getSelectedResources());
                                Set keySet = table.keySet();
                                for (SVNTeamProvider provider : keySet) {
                                    LockResourcesCommand command = new LockResourcesCommand(provider.getSVNWorkspaceRoot(), resources, stealLock, comment);
                                    command.run(Policy.subMonitorFor(monitor, 1000));
                                }
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                }, true, 1);
            }
        }
    }

    protected boolean isEnabledForSVNResource(ISVNLocalResource svnResource) {
        try {
            boolean enabled = super.isEnabledForSVNResource(svnResource);
            if (enabled) {
                return !svnResource.getStatusFromCache().isLocked();
            }
            return enabled;
        }
        catch (SVNException sVNException) {
            return false;
        }
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected boolean isEnabledForIgnoredResources() {
        return false;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return false;
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    protected String getImageId() {
        return "Menu Lock";
    }
}

