/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.DebugTypeSelectionDialog;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodSearchEngine;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.launch.MainTypeNameLaunchTabModel;
import org.springframework.ide.eclipse.boot.launch.util.DelegatingLaunchConfigurationTabSection;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.SelectionModel;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.UIConstants;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public class MainTypeLaunchTabSection
extends DelegatingLaunchConfigurationTabSection {
    public MainTypeLaunchTabSection(IPageWithSections owner, LiveVariable<IProject> project, MainTypeNameLaunchTabModel model) {
        super(owner, model, MainTypeLaunchTabSection.createUi(owner, project, model));
    }

    private static IPageSection createUi(IPageWithSections owner, final LiveVariable<IProject> project, final SelectionModel<String> mainTypeName) {
        return new WizardPageSection(owner){
            private Text fMainText;
            private Button fSearchButton;

            private LiveVariable<String> mainTypeName() {
                return mainTypeName.selection;
            }

            private LiveVariable<IProject> project() {
                return project;
            }

            public LiveExpression<ValidationResult> getValidator() {
                return mainTypeName.validator;
            }

            public void createContents(Composite parent) {
                String label = "Main type";
                GridDataFactory grabHor = GridDataFactory.fillDefaults().grab(true, false);
                Composite field = new Composite(parent, 0);
                GridLayout layout = GridLayoutFactory.fillDefaults().numColumns(3).create();
                field.setLayout((Layout)layout);
                grabHor.applyTo((Control)field);
                Label fieldNameLabel = new Label(field, 0);
                fieldNameLabel.setText(label);
                GridDataFactory.fillDefaults().hint(UIConstants.fieldLabelWidthHint((Control)fieldNameLabel), -1).align(1, 0x1000000).applyTo((Control)fieldNameLabel);
                this.fMainText = new Text(field, 2048);
                grabHor.applyTo((Control)this.fMainText);
                this.fMainText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        this.mainTypeName().setValue((Object)fMainText.getText());
                    }
                });
                this.mainTypeName().addListener((ValueListener)new ValueListener<String>(){

                    public void gotValue(LiveExpression<String> exp, String newName) {
                        String oldName;
                        if (fMainText != null && newName != null && !(oldName = fMainText.getText()).equals(newName)) {
                            fMainText.setText(newName);
                        }
                    }
                });
                this.fSearchButton = SWTFactory.createPushButton((Composite)field, (String)"Search...", null);
                this.fSearchButton.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.handleSearchButtonSelected();
                    }
                });
            }

            protected void handleSearchButtonSelected() {
                IJavaProject project2 = this.getJavaProject();
                IJavaElement[] elements = null;
                if (project2 == null || !project2.exists()) {
                    IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
                    if (model != null) {
                        try {
                            elements = model.getJavaProjects();
                        }
                        catch (JavaModelException e) {
                            JDIDebugUIPlugin.log((Throwable)e);
                        }
                    }
                } else {
                    elements = new IJavaElement[]{project2};
                }
                if (elements == null) {
                    elements = new IJavaElement[]{};
                }
                int constraints = 1;
                IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)constraints);
                MainMethodSearchEngine engine = new MainMethodSearchEngine();
                IType[] types = null;
                try {
                    types = engine.searchMainMethods(this.owner.getRunnableContext(), searchScope, false);
                }
                catch (Exception e) {
                    BootActivator.log((Throwable)e);
                    return;
                }
                DebugTypeSelectionDialog mmsd = new DebugTypeSelectionDialog(this.owner.getShell(), types, LauncherMessages.JavaMainTab_Choose_Main_Type_11);
                if (mmsd.open() == 1) {
                    return;
                }
                Object[] results = mmsd.getResult();
                IType type = (IType)results[0];
                if (type != null) {
                    this.fMainText.setText(type.getFullyQualifiedName());
                    this.project().setValue((Object)type.getJavaProject().getProject());
                }
            }

            private IJavaProject getJavaProject() {
                try {
                    return JavaCore.create((IProject)((IProject)this.project().getValue()));
                }
                catch (Exception e) {
                    BootActivator.log((Throwable)e);
                    return null;
                }
            }
        };
    }
}

