/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.naming;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class EnumValueNameCheck
extends Check {
    public static final String MSG_CONST = "enum.name.const.invalidPattern";
    public static final String MSG_OBJ = "enum.name.obj.invalidPattern";
    public static final String DEFAULT_CONST_PATTERN = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    public static final String DEFAULT_OBJ_PATTERN = "^[A-Z][a-zA-Z0-9]*$";
    private static final String[] DEFAULT_EXCLUSION = new String[]{"toString"};
    private Pattern objRegexp;
    private String objFormat;
    private Pattern constRegexp;
    private String constFormat;
    private final List<Pattern> excludes;

    public EnumValueNameCheck() {
        this.setConstFormat(DEFAULT_CONST_PATTERN);
        this.setObjFormat(DEFAULT_OBJ_PATTERN);
        this.excludes = Lists.newArrayList();
        this.setExcludes(DEFAULT_EXCLUSION);
    }

    public final void setConstFormat(String constRegexp) {
        this.constRegexp = Pattern.compile(constRegexp, 0);
        this.constFormat = constRegexp;
    }

    public final void setObjFormat(String objectRegexp) {
        this.objRegexp = Pattern.compile(objectRegexp, 0);
        this.objFormat = objectRegexp;
    }

    public void setExcludes(String[] excludes) {
        this.excludes.clear();
        for (String exclude : excludes) {
            this.excludes.add(Pattern.compile(exclude));
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{155};
    }

    public void visitToken(DetailAST ast) {
        Pattern pattern;
        DetailAST nameAST = ast.findFirstToken(58);
        boolean enumIsClass = this.isClassEnumeration(ast);
        Pattern pattern2 = pattern = enumIsClass ? this.objRegexp : this.constRegexp;
        if (!pattern.matcher(nameAST.getText()).find()) {
            String format = enumIsClass ? this.objFormat : this.constFormat;
            String msg = enumIsClass ? MSG_OBJ : MSG_CONST;
            this.log(nameAST.getLineNo(), nameAST.getColumnNo(), msg, new Object[]{nameAST.getText(), format});
        }
    }

    private boolean isClassEnumeration(DetailAST ast) {
        return EnumValueNameCheck.hasMembers(ast, this.excludes);
    }

    private static boolean hasMembers(DetailAST ast, List<Pattern> excludes) {
        DetailAST objBlock = ast.getParent();
        assert (objBlock.getType() == 6);
        boolean memberFound = false;
        for (DetailAST member = objBlock.getFirstChild(); member != null; member = member.getNextSibling()) {
            if (member.getType() != 9 && member.getType() != 10) continue;
            DetailAST memberIdent = member.findFirstToken(58);
            assert (memberIdent != null);
            String identifierStr = memberIdent.getText();
            if (EnumValueNameCheck.isAnyMatched(excludes, identifierStr)) continue;
            memberFound = true;
            break;
        }
        return memberFound;
    }

    private static boolean isAnyMatched(Collection<Pattern> patterns, String value) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(value).find()) continue;
            return true;
        }
        return false;
    }
}

