/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;

public class MultipleVariableDeclarationsExtendedCheck
extends Check {
    public static final String MSG_VAR_DECLARATIONS_COMMA = "multiple.variable.declarations.comma";
    public static final String MSG_VAR_DECLARATIONS = "multiple.variable.declarations";
    private boolean ignoreCycles;
    private boolean ignoreMethods;

    public void setIgnoreCycles(boolean value) {
        this.ignoreCycles = value;
    }

    public void setIgnoreMethods(boolean value) {
        this.ignoreMethods = value;
    }

    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    public void work(DetailAST ast) {
        boolean isCommaSeparated;
        DetailAST nextNode = ast.getNextSibling();
        boolean bl = isCommaSeparated = nextNode != null && nextNode.getType() == 74;
        if (nextNode == null) {
            return;
        }
        if (nextNode.getType() == 74 || nextNode.getType() == 45) {
            nextNode = nextNode.getNextSibling();
        }
        if (nextNode != null && nextNode.getType() == 10) {
            DetailAST firstNode = CheckUtils.getFirstNode((DetailAST)ast);
            if (isCommaSeparated) {
                this.log(firstNode, MSG_VAR_DECLARATIONS_COMMA, new Object[0]);
                return;
            }
            DetailAST lastNode = MultipleVariableDeclarationsExtendedCheck.getLastNode(ast);
            DetailAST firstNextNode = CheckUtils.getFirstNode((DetailAST)nextNode);
            if (firstNextNode.getLineNo() == lastNode.getLineNo()) {
                this.log(firstNode, MSG_VAR_DECLARATIONS, new Object[0]);
            }
        }
    }

    public void visitToken(DetailAST ast) {
        boolean inClass;
        DetailAST token = ast;
        boolean inFor = ast.getParent().getType() == 35;
        boolean bl = inClass = ast.getParent().getParent().getType() == 14;
        if (inClass) {
            this.work(token);
        } else if (!this.ignoreCycles && inFor) {
            this.work(token);
        } else if (!(this.ignoreMethods || inClass || inFor)) {
            this.work(token);
        }
    }

    private static DetailAST getLastNode(DetailAST node) {
        DetailAST currentNode = node;
        for (DetailAST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST newNode = MultipleVariableDeclarationsExtendedCheck.getLastNode(child);
            if (newNode.getLineNo() <= currentNode.getLineNo() && (newNode.getLineNo() != currentNode.getLineNo() || newNode.getColumnNo() <= currentNode.getColumnNo())) continue;
            currentNode = newNode;
        }
        return currentNode;
    }
}

